/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.function;

import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.mixin.accessors.world.AccessorRecipeManager;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ReloadableCache<T>
implements Function<Level, T> {
    private final Function<Level, T> delegate;
    private WeakReference<RecipeManager> recipeManager = new WeakReference<Object>(null);
    private boolean cached = false;
    @Nullable
    private T cachedValue;

    protected ReloadableCache(Function<Level, T> delegate) {
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public T apply(Level level) {
        if (!this.isCached() || this.hasGameReloaded(level)) {
            this.recipeManager = new WeakReference<RecipeManager>(level.getRecipeManager());
            this.cachedValue = this.delegate.apply(level);
            this.cached = true;
        }
        return this.cachedValue;
    }

    public void invalidate() {
        this.cached = false;
        this.cachedValue = null;
        this.recipeManager = new WeakReference<Object>(null);
    }

    public boolean isCached() {
        return this.cached;
    }

    public boolean hasGameReloaded(Level level) {
        return this.recipeManager.get() != level.getRecipeManager();
    }

    public void apply(Level level, Consumer<T> consumer) {
        consumer.accept(this.apply(level));
    }

    public static <T> ReloadableCache<T> of(Supplier<T> supplier) {
        return new ReloadableCache<Object>(level -> supplier.get());
    }

    public static <T> ReloadableCache<T> of(Function<Level, T> delegate) {
        return new ReloadableCache<T>(delegate);
    }

    public static <T> ReloadableCache<T> of(ResourceKey<? extends Registry<T>> registry, ResourceLocation id) {
        return ReloadableCache.of((Level level) -> level.registryAccess().registryOrThrow(registry).get(id));
    }

    public static <T> ReloadableCache<T> of(RecipeType<? extends Recipe<?>> type, ResourceLocation id) {
        return ReloadableCache.of((Level level) -> {
            RecipeManager patt5416$temp = level.getRecipeManager();
            if (patt5416$temp instanceof AccessorRecipeManager) {
                AccessorRecipeManager accessor = (AccessorRecipeManager)patt5416$temp;
                return accessor.bookshelf$getTypeMap(type).get(id);
            }
            return null;
        });
    }
}

