/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.registry;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.darkhax.bookshelf.api.block.IItemBlockProvider;
import net.darkhax.bookshelf.api.commands.ICommandBuilder;
import net.darkhax.bookshelf.api.item.tab.ITabBuilder;
import net.darkhax.bookshelf.api.registry.CommandArgumentRegistryEntries;
import net.darkhax.bookshelf.api.registry.IOwnedRegistryEntries;
import net.darkhax.bookshelf.api.registry.RecipeTypeEntries;
import net.darkhax.bookshelf.api.registry.RegistryEntries;
import net.darkhax.bookshelf.api.registry.VillagerTradeEntries;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;

public class RegistryDataProvider {
    private final String ownerId;
    public final IOwnedRegistryEntries<Block> blocks = new RegistryEntries<Block>(this::getOwner, Registries.BLOCK);
    public final IOwnedRegistryEntries<Fluid> fluids = new RegistryEntries<Fluid>(this::getOwner, Registries.FLUID);
    public final IOwnedRegistryEntries<Item> items = new RegistryEntries<Item>(this::getOwner, Registries.ITEM);
    public final IOwnedRegistryEntries<BannerPattern> bannerPatterns = new RegistryEntries<BannerPattern>(this::getOwner, Registries.BANNER_PATTERN);
    public final IOwnedRegistryEntries<MobEffect> mobEffects = new RegistryEntries<MobEffect>(this::getOwner, Registries.MOB_EFFECT);
    public final IOwnedRegistryEntries<SoundEvent> sounds = new RegistryEntries<SoundEvent>(this::getOwner, Registries.SOUND_EVENT);
    public final IOwnedRegistryEntries<Potion> potions = new RegistryEntries<Potion>(this::getOwner, Registries.POTION);
    public final IOwnedRegistryEntries<Enchantment> enchantments = new RegistryEntries<Enchantment>(this::getOwner, Registries.ENCHANTMENT);
    public final IOwnedRegistryEntries<EntityType<?>> entities = new RegistryEntries(this::getOwner, Registries.ENTITY_TYPE);
    public final IOwnedRegistryEntries<BlockEntityType<?>> blockEntities = new RegistryEntries(this::getOwner, Registries.BLOCK_ENTITY_TYPE);
    public final IOwnedRegistryEntries<ParticleType<?>> particleTypes = new RegistryEntries(this::getOwner, Registries.PARTICLE_TYPE);
    public final IOwnedRegistryEntries<MenuType<?>> menus = new RegistryEntries(this::getOwner, Registries.MENU);
    public final IOwnedRegistryEntries<RecipeSerializer<?>> recipeSerializers = new RegistryEntries(this::getOwner, Registries.RECIPE_SERIALIZER);
    public final IOwnedRegistryEntries<PaintingVariant> paintings = new RegistryEntries<PaintingVariant>(this::getOwner, Registries.PAINTING_VARIANT);
    public final IOwnedRegistryEntries<Attribute> attributes = new RegistryEntries<Attribute>(this::getOwner, Registries.ATTRIBUTE);
    public final IOwnedRegistryEntries<StatType<?>> stats = new RegistryEntries(this::getOwner, Registries.STAT_TYPE);
    public final IOwnedRegistryEntries<VillagerProfession> villagerProfessions = new RegistryEntries<VillagerProfession>(this::getOwner, Registries.VILLAGER_PROFESSION);
    public final CommandArgumentRegistryEntries commandArguments = new CommandArgumentRegistryEntries(this::getOwner, Registries.COMMAND_ARGUMENT_TYPE);
    public final RecipeTypeEntries recipeTypes = new RecipeTypeEntries(this::getOwner);
    public final IOwnedRegistryEntries<ICommandBuilder> commands = new RegistryEntries<ICommandBuilder>(this::getOwner, "Command");
    public final VillagerTradeEntries trades = new VillagerTradeEntries();
    public final IOwnedRegistryEntries<PreparableReloadListener> resourceListeners = new RegistryEntries<PreparableReloadListener>(this::getOwner, "Resource Listener");
    public final IOwnedRegistryEntries<PreparableReloadListener> dataListeners = new RegistryEntries<PreparableReloadListener>(this::getOwner, "Data Listener");
    public final IOwnedRegistryEntries<Consumer<ITabBuilder>> creativeTabs = new RegistryEntries<Consumer<ITabBuilder>>(this::getOwner, "Creative Tabs");

    public RegistryDataProvider(String ownerId) {
        this.ownerId = ownerId;
        this.recipeSerializers.addRegistryListener((id, serializer) -> {
            if (serializer.codec() == null) {
                throw new IllegalStateException("Recipe serializer '" + id.toString() + "' attempted to register serializer '" + serializer.getClass() + "' with null codec.");
            }
        });
    }

    public final RegistryDataProvider withItemTab(Supplier<ItemStack> icon) {
        this.creativeTabs.add(() -> arg_0 -> this.lambda$withItemTab$2((Supplier)icon, arg_0), "creative_tab");
        return this;
    }

    public final RegistryDataProvider withAutoItemBlocks() {
        this.blocks.addRegistryListener((id, block) -> {
            if (block instanceof IItemBlockProvider) {
                IItemBlockProvider provider = (IItemBlockProvider)block;
                if (provider.hasItemBlock((Block)block)) {
                    this.items.add(() -> provider.createItemBlock((Block)block), (ResourceLocation)id);
                }
            } else {
                this.items.add(() -> IItemBlockProvider.DEFAULT.createItemBlock((Block)block), (ResourceLocation)id);
            }
        });
        return this;
    }

    public String getOwner() {
        return this.ownerId;
    }

    private /* synthetic */ void lambda$withItemTab$2(Supplier icon, ITabBuilder builder) {
        builder.icon(icon);
        builder.displayItems((flags, output) -> output.acceptItemIter(this.items));
    }
}

