/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.data.recipes.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class ShapelessDurabilityRecipe
extends ShapelessRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final ItemStack output;
    private final int damageAmount;

    public ShapelessDurabilityRecipe(String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients, int damageAmount) {
        super(group, category, result, ingredients);
        this.damageAmount = damageAmount;
        this.output = result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList keptItems = super.getRemainingItems((Container)inv);
        return Services.INVENTORY_HELPER.keepDamageableItems(inv, (NonNullList<ItemStack>)keptItems, this.damageAmount);
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getDamageAmount() {
        return this.damageAmount;
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessDurabilityRecipe> {
        private static final Codec<ShapelessDurabilityRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(ShapelessRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapelessRecipe::category), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("result").forGetter(ShapelessDurabilityRecipe::getOutput), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            Object[] nonEmptyIngredients = (Ingredient[])ingredients.stream().filter(ingredient -> !ingredient.isEmpty()).toArray(Ingredient[]::new);
            if (nonEmptyIngredients.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return nonEmptyIngredients.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])nonEmptyIngredients));
        }, DataResult::success).forGetter(ShapelessRecipe::getIngredients), BookshelfCodecs.INT.get("damageAmount", ShapelessDurabilityRecipe::getDamageAmount, 1)).apply((Applicative)instance, ShapelessDurabilityRecipe::new));

        public Codec<ShapelessDurabilityRecipe> codec() {
            return CODEC;
        }

        public ShapelessDurabilityRecipe fromNetwork(FriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            int ingredientSize = buffer.readVarInt();
            NonNullList ingredients = NonNullList.withSize((int)ingredientSize, (Object)Ingredient.EMPTY);
            for (int index = 0; index < ingredients.size(); ++index) {
                ingredients.set(index, (Object)Ingredient.fromNetwork((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.readItem();
            int damageAmount = buffer.readVarInt();
            return new ShapelessDurabilityRecipe(group, category, output, (NonNullList<Ingredient>)ingredients, damageAmount);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapelessDurabilityRecipe toWrite) {
            buffer.writeUtf(toWrite.getGroup());
            buffer.writeEnum((Enum)toWrite.category());
            buffer.writeVarInt(toWrite.getIngredients().size());
            for (Ingredient ingredient : toWrite.getIngredients()) {
                ingredient.toNetwork(buffer);
            }
            buffer.writeItem(toWrite.output);
            buffer.writeVarInt(toWrite.damageAmount);
        }
    }
}

