/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.api.modules.template;

import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.SCConfig;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.template.ModuleWorker;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotRepair;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ModularEnchantments;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.addons.ModuleEnchants;

public abstract class ModuleTool
extends ModuleWorker {
    private int initialDurability = -1;
    private EntityDataAccessor<Integer> DURABILITY;
    private int remainingRepairUnits;
    private int maximumRepairUnits = 1;
    protected ModuleEnchants enchanter;
    private final int[] durabilityRect = new int[]{10, 15, 52, 8};

    public ModuleTool(EntityMinecartModular cart) {
        super(cart);
    }

    public abstract int getMaxDurability();

    public abstract ResourceLocation getRepairItem();

    public abstract int getRepairItemUnits(@Nonnull ItemStack var1);

    public abstract int getRepairSpeed();

    public abstract boolean useDurability();

    @Override
    public void init() {
        super.init();
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleEnchants)) continue;
            this.enchanter = (ModuleEnchants)module;
            this.enchanter.addType(ModularEnchantments.EnchantmentType.TOOL);
            break;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/tool.png");
        this.drawBox(guiGraphics, gui, 0, 0, 1.0f);
        this.drawBox(guiGraphics, gui, 0, 8, this.useDurability() ? (float)this.getCurrentDurability() / (float)this.getMaxDurability() : 1.0f);
        this.drawBox(guiGraphics, gui, 0, 16, (float)this.remainingRepairUnits / (float)this.maximumRepairUnits);
        if (this.inRect(x, y, this.durabilityRect)) {
            this.drawBox(guiGraphics, gui, 0, 24, 1.0f);
        }
    }

    private void drawBox(GuiGraphics guiGraphics, GuiMinecart gui, int u, int v, float mult) {
        int w = (int)((float)this.durabilityRect[2] * mult);
        if (w > 0) {
            this.drawImage(guiGraphics, gui, this.durabilityRect[0], this.durabilityRect[1], u, v, w, this.durabilityRect[3]);
        }
    }

    public boolean isValidRepairMaterial(@Nonnull ItemStack item) {
        return this.getRepairItemUnits(item) > 0;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotRepair(this, this.getCart(), slotId, 76, 8);
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    public int guiWidth() {
        return 100;
    }

    @Override
    public int guiHeight() {
        return 50;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        Object str;
        if (this.useDurability()) {
            str = Localization.MODULES.TOOLS.DURABILITY.translate(new String[0]) + ": " + this.getCurrentDurability() + "/" + this.getMaxDurability();
            str = this.isBroken() ? (String)str + " [" + Localization.MODULES.TOOLS.BROKEN.translate(new String[0]) + "]" : (String)str + " [" + 100 * this.getCurrentDurability() / this.getMaxDurability() + "%]";
            str = (String)str + "\n";
            if (this.isRepairing()) {
                if (this.isActuallyRepairing()) {
                    str = (String)str + " [" + this.getRepairPercentage() + "%]";
                } else if (!((Boolean)SCConfig.allowCartToRunWithRepairItems.get()).booleanValue()) {
                    str = (String)str + Localization.MODULES.TOOLS.DECENT.translate(new String[0]);
                }
            } else {
                Item item = (Item)BuiltInRegistries.ITEM.get(this.getRepairItem());
                if (item != Items.AIR) {
                    str = (String)str + Localization.MODULES.TOOLS.INSTRUCTION.translate(item.getName(new ItemStack((ItemLike)item)).getString());
                }
            }
        } else {
            str = Localization.MODULES.TOOLS.UNBREAKABLE.translate(new String[0]);
            if (this.isRepairing() && !this.isActuallyRepairing()) {
                str = (String)str + " " + Localization.MODULES.TOOLS.UNBREAKABLE_REPAIR.translate(new String[0]);
            }
        }
        this.drawStringOnMouseOver(guiGraphics, gui, (String)str, x, y, this.durabilityRect);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.DURABILITY = this.createDw(EntityDataSerializers.INT);
        this.registerDw(this.DURABILITY, this.getMaxDurability());
    }

    @Override
    public void update() {
        super.update();
        if (this.initialDurability != -1 && !this.getCart().level().isClientSide) {
            this.setDurability(this.initialDurability);
            this.initialDurability = -1;
        }
        if (!this.getCart().level().isClientSide && this.useDurability()) {
            int units;
            if (this.isActuallyRepairing()) {
                boolean dif = true;
                --this.remainingRepairUnits;
                this.setDurability(this.getCurrentDurability() + 1 * this.getRepairSpeed());
                if (this.getCurrentDurability() > this.getMaxDurability()) {
                    this.setDurability(this.getCurrentDurability());
                }
            }
            if (!this.isActuallyRepairing() && (units = this.getRepairItemUnits(this.getStack(0))) > 0 && units <= this.getMaxDurability() - this.getCurrentDurability()) {
                int n;
                this.remainingRepairUnits = n = units / this.getRepairSpeed();
                this.maximumRepairUnits = n;
                ItemStack stack = this.getStack(0);
                stack.shrink(1);
                if (this.getStack(0).getCount() <= 0) {
                    this.setStack(0, ItemStack.EMPTY);
                }
            }
        }
    }

    @Override
    public boolean stopEngines() {
        return this.isRepairing();
    }

    public boolean isRepairing() {
        return !this.getStack(0).isEmpty() && (Boolean)SCConfig.allowCartToRunWithRepairItems.get() == false || this.isActuallyRepairing();
    }

    public boolean isActuallyRepairing() {
        return this.remainingRepairUnits > 0;
    }

    public boolean isBroken() {
        return this.getCurrentDurability() == 0 && this.useDurability();
    }

    public void damageTool(int val) {
        int unbreaking;
        int n = unbreaking = this.enchanter != null ? this.enchanter.getUnbreakingLevel() : 0;
        if (this.getCart().random.nextInt(100) < 100 / (unbreaking + 1)) {
            this.setDurability(this.getCurrentDurability() - val);
            if (this.getCurrentDurability() < 0) {
                this.setDurability(0);
            }
        }
        if (this.enchanter != null) {
            this.enchanter.damageEnchant(ModularEnchantments.EnchantmentType.TOOL, val);
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        int dataint = data;
        if (dataint < 0) {
            dataint += 65536;
        }
        if (id == 0) {
            this.setDurability(this.getCurrentDurability() & 0xFFFF0000 | dataint);
        } else if (id == 1) {
            this.setDurability(this.getCurrentDurability() & 0xFFFF | dataint << 16);
        } else if (id == 2) {
            this.remainingRepairUnits = data;
        } else if (id == 3) {
            this.maximumRepairUnits = data;
        }
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        tagCompound.putInt(this.generateNBTName("Durability", id), this.getCurrentDurability());
        tagCompound.putShort(this.generateNBTName("Repair", id), (short)this.remainingRepairUnits);
        tagCompound.putShort(this.generateNBTName("MaxRepair", id), (short)this.maximumRepairUnits);
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        this.setDurability(tagCompound.getInt(this.generateNBTName("Durability", id)));
        this.remainingRepairUnits = tagCompound.getShort(this.generateNBTName("Repair", id));
        this.maximumRepairUnits = tagCompound.getShort(this.generateNBTName("MaxRepair", id));
    }

    public void setDurability(int amount) {
        this.updateDw(this.DURABILITY, amount);
    }

    public int getCurrentDurability() {
        return this.getDw(this.DURABILITY);
    }

    public int getRepairPercentage() {
        return 100 - 100 * this.remainingRepairUnits / this.maximumRepairUnits;
    }

    @Override
    public boolean hasExtraData() {
        return true;
    }

    @Override
    public CompoundTag writeExtraData() {
        CompoundTag tag = super.writeExtraData();
        tag.putInt("durability", this.getCurrentDurability());
        tag.putShort("repair", (short)this.remainingRepairUnits);
        tag.putShort("max_repair", (short)this.maximumRepairUnits);
        return tag;
    }

    @Override
    public void readExtraData(CompoundTag nbt) {
        this.initialDurability = nbt.getInt("durability");
        this.remainingRepairUnits = nbt.getShort("repair");
        this.maximumRepairUnits = nbt.getShort("max_repair");
    }
}

