/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vswe.stevescarts.blocks.BlockContainerBase;
import vswe.stevescarts.blocks.tileentities.TileEntityDistributor;

public class BlockDistributor
extends BlockContainerBase {
    public static final MapCodec<BlockDistributor> CODEC = BlockDistributor.simpleCodec(BlockDistributor::new);

    public BlockDistributor(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult use(@NotNull BlockState blockState, Level world, @NotNull BlockPos blockPos, @NotNull Player playerEntity, @NotNull InteractionHand hand, @NotNull BlockHitResult rayTraceResult) {
        if (!world.isClientSide && !playerEntity.isCrouching()) {
            playerEntity.openMenu((MenuProvider)world.getBlockEntity(blockPos), blockPos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityDistributor(blockPos, blockState);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

