/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.blocks.tileentities.TileEntityBase;
import vswe.stevescarts.blocks.tileentities.TileEntityCargo;
import vswe.stevescarts.blocks.tileentities.TileEntityLiquid;
import vswe.stevescarts.blocks.tileentities.TileEntityManager;
import vswe.stevescarts.containers.ContainerDistributor;
import vswe.stevescarts.helpers.DistributorSetting;
import vswe.stevescarts.helpers.DistributorSide;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.storages.SCTank;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.network.PacketHandler;
import vswe.stevescarts.network.packets.PacketDistributorTile;

public class TileEntityDistributor
extends TileEntityBase
implements WorldlyContainer,
MenuProvider {
    private final ArrayList<DistributorSide> sides;
    private boolean dirty = true;
    private TileEntityManager[] inventories;
    public IItemHandler[] invHandlers = new IItemHandler[6];
    public boolean hasTop;
    public boolean hasBot;
    public final Map<Direction, IFluidHandler> fluidHandlerMap;

    public TileEntityDistributor(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.EXTERNAL_DISTRIBUTOR_TILE.get(), blockPos, blockState);
        this.sides = new ArrayList<DistributorSide>();
        this.sides.add(new DistributorSide(0, Localization.GUI.DISTRIBUTOR.SIDE_ORANGE, Direction.UP));
        this.sides.add(new DistributorSide(1, Localization.GUI.DISTRIBUTOR.SIDE_PURPLE, Direction.DOWN));
        this.sides.add(new DistributorSide(2, Localization.GUI.DISTRIBUTOR.SIDE_YELLOW, Direction.NORTH));
        this.sides.add(new DistributorSide(3, Localization.GUI.DISTRIBUTOR.SIDE_GREEN, Direction.WEST));
        this.sides.add(new DistributorSide(4, Localization.GUI.DISTRIBUTOR.SIDE_BLUE, Direction.SOUTH));
        this.sides.add(new DistributorSide(5, Localization.GUI.DISTRIBUTOR.SIDE_RED, Direction.EAST));
        this.fluidHandlerMap = new HashMap<Direction, IFluidHandler>();
        for (final Direction facing : Direction.values()) {
            this.fluidHandlerMap.put(facing, new IFluidHandler(){

                public int getTanks() {
                    SCTank[] tanks = TileEntityDistributor.this.getTanks(facing);
                    return tanks.length;
                }

                @Nonnull
                public FluidStack getFluidInTank(int tank) {
                    SCTank[] tanks = TileEntityDistributor.this.getTanks(facing);
                    return tanks[tank].getFluid();
                }

                public int getTankCapacity(int tank) {
                    SCTank[] tanks = TileEntityDistributor.this.getTanks(facing);
                    return tanks[tank].getCapacity();
                }

                public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                    SCTank[] tanks = TileEntityDistributor.this.getTanks(facing);
                    return tanks[tank].isFluidValid(stack);
                }

                public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                    SCTank[] tanks = TileEntityDistributor.this.getTanks(facing);
                    int amount = 0;
                    for (SCTank tank : tanks) {
                        amount += tank.fill(resource, action);
                    }
                    return amount;
                }

                @Nonnull
                public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                    return TileEntityDistributor.this.drain(facing, resource, resource.getAmount(), action);
                }

                @Nonnull
                public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                    return TileEntityDistributor.this.drain(facing, FluidStack.EMPTY, maxDrain, action);
                }
            });
        }
    }

    public ArrayList<DistributorSide> getSides() {
        return this.sides;
    }

    public void load(@NotNull CompoundTag compoundNBT) {
        super.load(compoundNBT);
        for (DistributorSide side : this.getSides()) {
            side.setData(compoundNBT.getInt("Side" + side.getId()));
        }
    }

    public void saveAdditional(@NotNull CompoundTag compoundNBT) {
        super.saveAdditional(compoundNBT);
        for (DistributorSide side : this.getSides()) {
            compoundNBT.putInt("Side" + side.getId(), side.getData());
        }
    }

    @Override
    public void tick() {
        this.dirty = true;
    }

    protected void sendPacket(int id) {
        this.sendPacket(id, new byte[0]);
    }

    protected void sendPacket(int id, byte data) {
        this.sendPacket(id, new byte[]{data});
    }

    public void sendPacket(int id, byte[] data) {
        PacketHandler.sendToServer(new PacketDistributorTile(this.getBlockPos(), id, data));
    }

    public void receivePacket(int id, byte[] data, ServerPlayer player) {
        if (id == 0 || id == 1) {
            byte settingId = data[0];
            byte sideId = data[1];
            if (settingId >= 0 && settingId < DistributorSetting.settings.size() && sideId >= 0 && sideId < this.getSides().size()) {
                if (id == 0) {
                    this.getSides().get(sideId).set(settingId);
                } else {
                    this.getSides().get(sideId).reset(settingId);
                }
                this.setChanged();
            }
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.getTag());
    }

    public TileEntityManager[] getInventories() {
        if (this.dirty) {
            this.generateInventories();
            this.dirty = false;
        }
        return this.inventories;
    }

    public HashMap<Integer, Integer> getInventorySides() {
        TileEntityManager[] managers = this.getInventories();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int id = 0;
        for (int i = 0; i < managers.length; ++i) {
            for (int j = 0; j < managers[i].getContainerSize(); ++j) {
                map.put(id++, i);
            }
        }
        return map;
    }

    private void generateInventories() {
        TileEntityManager bot = this.generateManager(-1);
        TileEntityManager top = this.generateManager(1);
        this.hasTop = top != null;
        this.hasBot = bot != null;
        this.inventories = this.populateManagers(top, bot, this.hasTop, this.hasBot);
    }

    private TileEntityManager[] populateManagers(TileEntityManager topElement, TileEntityManager botElement, boolean hasTopElement, boolean hasBotElement) {
        if (!hasTopElement && !hasBotElement) {
            return new TileEntityManager[0];
        }
        if (!hasBotElement) {
            return new TileEntityManager[]{topElement};
        }
        if (!hasTopElement) {
            return new TileEntityManager[]{botElement};
        }
        return new TileEntityManager[]{botElement, topElement};
    }

    private TileEntityManager generateManager(int y) {
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().offset(0, y, 0));
        if (blockEntity instanceof TileEntityManager) {
            TileEntityManager tile = (TileEntityManager)blockEntity;
            return tile;
        }
        return null;
    }

    @Override
    public boolean isUsableByPlayer(Player entityplayer) {
        return this.level.getBlockEntity(this.getBlockPos()) == this && entityplayer.distanceToSqr((Entity)entityplayer) <= 64.0;
    }

    private int translateSlotId(int slot, TileEntityManager manager) {
        return slot % manager.getContainerSize();
    }

    private TileEntityManager getManagerFromSlotId(int slot) {
        TileEntityManager[] invs = this.getInventories();
        int id = this.getInventorySides().getOrDefault(slot, 0);
        if (!this.hasTop || !this.hasBot) {
            id = 0;
        }
        if (id < 0 || id >= invs.length) {
            return null;
        }
        return invs[id];
    }

    public int getContainerSize() {
        return Arrays.stream(this.getInventories()).mapToInt(TileEntityManager::getContainerSize).sum();
    }

    public boolean isEmpty() {
        return false;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        TileEntityManager manager = this.getManagerFromSlotId(slot);
        if (manager != null) {
            return manager.getItem(this.translateSlotId(slot, manager));
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        TileEntityManager manager = this.getManagerFromSlotId(slot);
        if (manager != null) {
            return manager.removeItem(this.translateSlotId(slot, manager), amount);
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        TileEntityManager manager = this.getManagerFromSlotId(slot);
        if (manager != null) {
            return manager.removeItemNoUpdate(this.translateSlotId(slot, manager));
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        TileEntityManager manager = this.getManagerFromSlotId(slot);
        if (manager != null) {
            manager.setItem(this.translateSlotId(slot, manager), stack);
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    private boolean isChunkValid(DistributorSide side, TileEntityManager manager, int chunkId, boolean top) {
        for (DistributorSetting setting : DistributorSetting.settings) {
            if (!setting.isEnabled(this) || !side.isSet(setting.getId()) || !setting.isValid(manager, chunkId, top)) continue;
            return true;
        }
        return false;
    }

    private FluidStack drain(Direction from, @Nonnull FluidStack target, int maxDrain, IFluidHandler.FluidAction doDrain) {
        SCTank[] tanks;
        FluidStack totalDrained = FluidStack.EMPTY;
        for (SCTank tank : tanks = this.getTanks(from)) {
            FluidStack drained;
            FluidStack contents = tank.getFluid();
            if (contents.isEmpty() || !target.isEmpty() && !contents.isFluidEqual(target) || (drained = tank.drain(maxDrain, doDrain)).isEmpty()) continue;
            maxDrain -= drained.getAmount();
            if (totalDrained.isEmpty()) {
                totalDrained = drained;
            } else {
                totalDrained.grow(drained.getAmount());
            }
            if (target.isEmpty()) {
                target = drained;
            }
            if (maxDrain > 0) continue;
            return totalDrained;
        }
        return totalDrained;
    }

    private boolean hasAnyTank(Direction facing) {
        return facing != null && this.getInventories().length > 0 && this.getTanks(facing).length > 0;
    }

    public SCTank[] getTanks(Direction direction) {
        TileEntityManager[] invs = this.getInventories();
        if (invs.length > 0) {
            for (DistributorSide side : this.getSides()) {
                if (side.getSide() != direction) continue;
                ArrayList<SCTank> tanks = new ArrayList<SCTank>();
                if (this.hasTop && this.hasBot) {
                    this.populateTanks(tanks, side, invs[0], false);
                    this.populateTanks(tanks, side, invs[1], true);
                } else if (this.hasTop) {
                    this.populateTanks(tanks, side, invs[0], true);
                } else if (this.hasBot) {
                    this.populateTanks(tanks, side, invs[0], false);
                }
                return tanks.toArray(new SCTank[tanks.size()]);
            }
        }
        return new SCTank[0];
    }

    private void populateTanks(ArrayList<SCTank> tanks, DistributorSide side, TileEntityManager manager, boolean top) {
        if (manager instanceof TileEntityLiquid) {
            TileEntityLiquid fluid = (TileEntityLiquid)manager;
            SCTank[] managerTanks = fluid.getTanks();
            for (int i = 0; i < 4; ++i) {
                if (!this.isChunkValid(side, manager, i, top) || tanks.contains((Object)managerTanks[i])) continue;
                tanks.add(managerTanks[i]);
            }
        }
    }

    private void populateSlots(ArrayList<Integer> slotchunks, DistributorSide side, TileEntityManager manager, boolean top) {
        if (manager instanceof TileEntityCargo) {
            for (int i = 0; i < 4; ++i) {
                int chunkid;
                if (!this.isChunkValid(side, manager, i, top) || slotchunks.contains(chunkid = i + (top ? 4 : 0))) continue;
                slotchunks.add(chunkid);
            }
        }
    }

    public int[] getSlotsForFace(@NotNull Direction direction) {
        TileEntityManager[] invs = this.getInventories();
        if (invs.length > 0) {
            for (DistributorSide otherSide : this.getSides()) {
                if (otherSide.getFacing() != direction) continue;
                ArrayList<Integer> slotchunks = new ArrayList<Integer>();
                if (this.hasTop && this.hasBot) {
                    this.populateSlots(slotchunks, otherSide, invs[0], false);
                    this.populateSlots(slotchunks, otherSide, invs[1], true);
                } else if (this.hasTop) {
                    this.populateSlots(slotchunks, otherSide, invs[0], true);
                } else if (this.hasBot) {
                    this.populateSlots(slotchunks, otherSide, invs[0], false);
                }
                int[] ret = new int[slotchunks.size() * 15];
                int id = 0;
                for (int chunkid : slotchunks) {
                    for (int i = 0; i < 15; ++i) {
                        ret[id] = chunkid * 15 + i;
                        ++id;
                    }
                }
                return ret;
            }
        }
        return new int[0];
    }

    public boolean canPlaceItemThroughFace(int id, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return true;
    }

    public boolean canTakeItemThroughFace(int id, @NotNull ItemStack itemStack, @NotNull Direction direction) {
        return true;
    }

    public void clearContent() {
    }

    @NotNull
    public Component getDisplayName() {
        return Component.literal((String)"container.distributor");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
        return new ContainerDistributor(id, playerInventory, this);
    }
}

