/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.guis;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import vswe.stevescarts.api.IModuleItem;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.api.modules.data.ModuleDataHull;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.containers.ContainerCartAssembler;
import vswe.stevescarts.containers.slots.SlotAssembler;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.DropDownMenuItem;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.helpers.TitleBox;
import vswe.stevescarts.network.PacketHandler;
import vswe.stevescarts.network.packets.PacketCreateCart;

public class GuiCartAssembler
extends AbstractContainerScreen<ContainerCartAssembler> {
    private ArrayList<TextWithColor> statusLog;
    private boolean hasErrors;
    private boolean firstLoad = true;
    private static ResourceLocation[] backgrounds = new ResourceLocation[4];
    private static final ResourceLocation textureLeft;
    private static final ResourceLocation textureRight;
    private static final ResourceLocation textureExtra;
    private final int[] assembleRect;
    private final String validChars;
    private int dropdownX = -1;
    private int dropdownY = -1;
    private int scrollingX;
    private int scrollingY;
    private boolean isScrolling;
    private final int[] blackBackground;
    private final ContainerCartAssembler containerCartAssembler;
    private final TileEntityCartAssembler assembler;
    private final int[] assemblingProgRect = new int[]{375, 180, 115, 11};
    private final int[] fuelProgRect = new int[]{375, 200, 115, 11};
    private boolean spin = true;

    public GuiCartAssembler(ContainerCartAssembler containerCartAssembler, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)containerCartAssembler, playerInventory, iTextComponent);
        this.assembleRect = new int[]{390, 160, 80, 11};
        this.validChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        this.blackBackground = new int[]{145, 15, 222, 148};
        this.containerCartAssembler = containerCartAssembler;
        this.assembler = containerCartAssembler.getAssembler();
        this.imageWidth = 512;
        this.imageHeight = 256;
    }

    private void updateErrorList() {
        ArrayList<TextWithColor> lines = new ArrayList<TextWithColor>();
        if (this.assembler.getItem(0).isEmpty()) {
            this.addText(lines, Localization.GUI.ASSEMBLER.ASSEMBLE_INSTRUCTION.translate(new String[0]));
            this.hasErrors = true;
        } else {
            ItemStack stack = this.assembler.getItem(0);
            Item item = stack.getItem();
            if (!(item instanceof IModuleItem)) {
                this.hasErrors = false;
                this.statusLog = lines;
                return;
            }
            IModuleItem cartModule = (IModuleItem)item;
            ModuleData hulldata = cartModule.getModuleData();
            if (hulldata == null || !(hulldata instanceof ModuleDataHull)) {
                this.addText(lines, Localization.GUI.ASSEMBLER.INVALID_HULL.translate(new String[0]), 10357518);
                this.hasErrors = true;
            } else {
                ModuleDataHull hull = (ModuleDataHull)hulldata;
                this.addText(lines, Localization.GUI.ASSEMBLER.HULL_CAPACITY.translate(new String[0]) + ": " + hull.getCapacity());
                this.addText(lines, Localization.GUI.ASSEMBLER.COMPLEXITY_CAP.translate(new String[0]) + ": " + hull.getComplexityMax());
                this.addText(lines, Localization.GUI.ASSEMBLER.TOTAL_COST.translate(new String[0]) + ": " + this.assembler.getTotalCost());
                this.addText(lines, Localization.GUI.ASSEMBLER.TOTAl_TIME.translate(new String[0]) + ": " + this.formatTime((int)((float)this.assembler.generateAssemblingTime() / this.assembler.getEfficiency())));
                this.addNewLine(lines);
                ArrayList<String> errors = this.assembler.getErrors();
                boolean bl = this.hasErrors = errors.size() > 0;
                if (errors.size() == 0) {
                    this.addText(lines, Localization.GUI.ASSEMBLER.NO_ERROR.translate(new String[0]), 22566);
                } else {
                    for (String error : errors) {
                        this.addText(lines, error, 10357518);
                    }
                }
            }
        }
        this.statusLog = lines;
    }

    private void addText(ArrayList<TextWithColor> lines, String text) {
        this.addText(lines, text, 0x404040);
    }

    private void addText(ArrayList<TextWithColor> lines, String text, int color) {
        List newlines = ComponentRenderUtils.wrapComponents((FormattedText)Component.literal((String)text), (int)130, (Font)this.font);
        for (FormattedCharSequence line : newlines) {
            lines.add(new TextWithColor(line, color));
        }
    }

    private void addNewLine(ArrayList<TextWithColor> lines) {
        lines.add(null);
    }

    protected void renderBg(GuiGraphics guiGraphics, float p_230450_2_, int mouseX, int mouseY) {
        if (this.firstLoad) {
            this.updateErrorList();
            this.firstLoad = false;
        }
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        guiGraphics.blit(backgrounds[this.assembler.getSimulationInfo().getBackground()], j + 143, k + 15, 0, 0, 220, 148);
        guiGraphics.blit(textureLeft, j, k, 0, 0, 256, this.imageHeight);
        guiGraphics.blit(textureRight, j + 256, k, 0, 0, this.imageWidth - 256, this.imageHeight);
        guiGraphics.blit(textureRight, j + 256, k, 0, 0, this.imageWidth - 256, this.imageHeight);
        ResourceHelper.bindResource(textureExtra);
        ArrayList<SlotAssembler> slots = this.assembler.getSlots();
        for (SlotAssembler slot : slots) {
            int srcY;
            int srcX;
            int size;
            int targetX = slot.getX() - 1;
            int targetY = slot.getY() - 1;
            if (slot.useLargeInterface()) {
                targetX -= 3;
                targetY -= 3;
                size = 24;
                srcX = 0;
                srcY = 0;
            } else {
                size = 18;
                if (!slot.getItem().isEmpty() && TileEntityCartAssembler.getSlotStatus(slot.getItem()) <= 0) {
                    srcX = TileEntityCartAssembler.getSlotStatus(slot.getItem()) == TileEntityCartAssembler.getRemovedSize() ? 140 : 122;
                    srcY = 40;
                } else {
                    srcX = 24;
                    srcY = 0;
                }
            }
            guiGraphics.blit(textureExtra, j + targetX, k + targetY, srcX, srcY, size, size);
            int animationTick = slot.getAnimationTick();
            if (animationTick < 0) {
                animationTick = 0;
            }
            if (animationTick < 8 && !slot.useLargeInterface()) {
                guiGraphics.blit(textureExtra, j + targetX + 1, k + targetY + 1, 0, 24 + animationTick, 16, 8 - animationTick);
                guiGraphics.blit(textureExtra, j + targetX + 1, k + targetY + 1 + 8 + animationTick, 0, 32, 16, 8 - animationTick);
            }
            slot.update();
        }
        for (TitleBox box : this.assembler.getTitleBoxes()) {
            int targetY2 = box.getY() - 12;
            int targetX2 = box.getX();
            guiGraphics.blit(textureExtra, j + targetX2, k + targetY2, 0, 40, 115, 11);
            guiGraphics.blit(textureExtra, j + targetX2 + 8, k + targetY2 + 2, 0, 51 + box.getID() * 7, 115, 7);
        }
        int srcX2 = 42;
        int srcY2 = 0;
        if (this.assembler.getIsDisassembling()) {
            srcX2 = 158;
            srcY2 = 40;
        }
        if (this.hasErrors) {
            srcY2 += 22;
        } else if (this.inRect(mouseX - j, mouseY - k, this.assembleRect)) {
            srcY2 += 11;
        }
        guiGraphics.blit(textureExtra, j + this.assembleRect[0], k + this.assembleRect[1], srcX2, srcY2, this.assembleRect[2], this.assembleRect[3]);
        float assemblingProgress = 0.0f;
        if (this.containerCartAssembler.getIsAssembling()) {
            assemblingProgress = (float)this.containerCartAssembler.getAssemblingTime() / (float)this.containerCartAssembler.getMaxAssemblingTime();
        }
        this.drawProgressBar(guiGraphics, this.assemblingProgRect, assemblingProgress, 22, mouseX, mouseY);
        this.drawProgressBar(guiGraphics, this.fuelProgRect, (float)this.containerCartAssembler.getFuel() / (float)this.assembler.getMaxFuelLevel(), 31, mouseX, mouseY);
        this.renderDropDownMenu(guiGraphics, textureExtra, mouseX, mouseY);
        this.renderEntityInInventory(this.leftPos + 256, this.topPos + 100, 50);
    }

    public void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(Minecraft.getInstance().font, Localization.GUI.ASSEMBLER.TITLE.translate(new String[0]), 18, 6, 0xFFFFFF);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Object assemblingInfo;
        ArrayList<TextWithColor> lines;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.assembler.isErrorListOutdated) {
            this.updateErrorList();
            this.assembler.isErrorListOutdated = false;
        }
        if ((lines = this.statusLog) != null) {
            int lineCount = lines.size();
            boolean dotdotdot = false;
            if (lineCount > 11) {
                lineCount = 10;
                dotdotdot = true;
            }
            for (int i = 0; i < lineCount; ++i) {
                TextWithColor info = lines.get(i);
                if (info == null) continue;
                guiGraphics.drawString(Minecraft.getInstance().font, info.getText(), this.leftPos + 370, this.topPos + 40 + i * 10, info.getColor(), false);
            }
            if (dotdotdot) {
                guiGraphics.drawString(Minecraft.getInstance().font, "...", this.leftPos + 370, this.topPos + 40 + lineCount * 10, 0x404040, false);
            }
        }
        if (this.containerCartAssembler.getIsAssembling()) {
            float assemblingProgress = (float)this.containerCartAssembler.getAssemblingTime() / (float)this.containerCartAssembler.getMaxAssemblingTime();
            assemblingInfo = Localization.GUI.ASSEMBLER.ASSEMBLE_PROGRESS.translate(new String[0]) + ": " + this.formatProgress(assemblingProgress);
            assemblingInfo = (String)assemblingInfo + ": " + Localization.GUI.ASSEMBLER.TIME_LEFT.translate(new String[0]) + ": " + this.formatTime((int)((float)(this.containerCartAssembler.getMaxAssemblingTime() - this.containerCartAssembler.getAssemblingTime()) / this.assembler.getEfficiency()));
        } else {
            assemblingInfo = Localization.GUI.ASSEMBLER.IDLE_MESSAGE.translate(new String[0]);
        }
        if (!this.hasErrors) {
            if (this.assembler.getIsDisassembling()) {
                this.drawProgressBarInfo(guiGraphics, this.assembleRect, mouseX, mouseY, Localization.GUI.ASSEMBLER.MODIFY_CART.translate(new String[0]));
            } else {
                this.drawProgressBarInfo(guiGraphics, this.assembleRect, mouseX, mouseY, Localization.GUI.ASSEMBLER.ASSEMBLE_CART.translate(new String[0]));
            }
        }
        this.drawProgressBarInfo(guiGraphics, this.assemblingProgRect, mouseX, mouseY, (String)assemblingInfo);
        this.drawProgressBarInfo(guiGraphics, this.fuelProgRect, mouseX, mouseY, Localization.GUI.ASSEMBLER.FUEL_LEVEL.translate(new String[0]) + ": " + this.containerCartAssembler.getFuel() + "/" + this.assembler.getMaxFuelLevel());
    }

    private String formatProgress(float progress) {
        float percentage = (float)((int)(progress * 10000.0f)) / 100.0f;
        return String.format("%05.2f%%", Float.valueOf(percentage));
    }

    private String formatTime(int ticks) {
        int seconds = ticks / 20;
        ticks -= seconds * 20;
        int minutes = seconds / 60;
        seconds -= minutes * 60;
        int hours = minutes / 60;
        return String.format("%02d:%02d:%02d", hours, minutes -= hours * 60, seconds);
    }

    private void drawProgressBarInfo(GuiGraphics guiGraphics, int[] rect, int x, int y, String str) {
        if (this.inRect(x - this.getGuiLeft(), y - this.getGuiTop(), rect)) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)str), x, y);
        }
    }

    private void drawProgressBar(GuiGraphics guiGraphics, int[] rect, float progress, int barSrcY, int x, int y) {
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        int boxSrcY = 0;
        if (this.inRect(x - j, y - k, rect)) {
            boxSrcY = 11;
        }
        guiGraphics.blit(textureExtra, j + rect[0], k + rect[1], 122, boxSrcY, rect[2], rect[3]);
        if (progress != 0.0f) {
            if (progress > 1.0f) {
                progress = 1.0f;
            }
            guiGraphics.blit(textureExtra, j + rect[0] + 1, k + rect[1] + 1, 122, barSrcY, (int)((float)rect[2] * progress), rect[3] - 2);
        }
    }

    public void renderEntityInInventory(int p_98851_, int p_98852_, int p_98853_) {
        if (this.assembler.getHullModule() == null) {
            return;
        }
        this.assembler.createPlaceholder();
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.pushPose();
        posestack.translate((double)p_98851_, (double)p_98852_, 1050.0);
        posestack.scale(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack posestack1 = new PoseStack();
        posestack1.translate(0.0, 0.0, 1000.0);
        posestack1.scale((float)p_98853_, (float)p_98853_, (float)p_98853_);
        Quaternionf quaternion = Axis.YN.rotationDegrees(this.assembler.getRoll() * 10.0f);
        Quaternionf quaternion1 = Axis.XP.rotationDegrees(180.0f);
        if (this.spin) {
            posestack1.mulPose(quaternion);
        }
        quaternion.mul((Quaternionfc)quaternion1);
        posestack1.mulPose(quaternion);
        EntityMinecartModular entityMinecartModular = this.assembler.getPlaceholder();
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        quaternion1.conjugate();
        entityrenderdispatcher.overrideCameraOrientation(quaternion1);
        entityrenderdispatcher.setRenderShadow(false);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        if (entityMinecartModular != null) {
            RenderSystem.runAsFancy(() -> entityrenderdispatcher.render((Entity)entityMinecartModular, 0.0, 0.0, 0.0, 0.0f, 1.0f, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0));
        }
        multibuffersource$buffersource.endBatch();
        entityrenderdispatcher.setRenderShadow(true);
        posestack.popPose();
        RenderSystem.applyModelViewMatrix();
        Lighting.setupFor3DItems();
    }

    private void renderDropDownMenu(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int x, int y) {
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        if (this.dropdownX != -1 && this.dropdownY != -1) {
            ArrayList<DropDownMenuItem> items = this.assembler.getDropDown();
            block5: for (int i = 0; i < items.size(); ++i) {
                DropDownMenuItem item = items.get(i);
                int[] rect = item.getRect(this.dropdownX, this.dropdownY, i);
                int[] subrect = new int[]{};
                int srcX = 0;
                int srcY = item.getIsLarge() ? 113 : 93;
                guiGraphics.blit(resourceLocation, j + rect[0], k + rect[1], srcX, srcY, rect[2], rect[3]);
                if (item.getIsLarge()) {
                    this.drawString(guiGraphics, resourceLocation, item.getName(), j + rect[0] + 55, k + rect[1] + 7);
                }
                guiGraphics.blit(resourceLocation, j + rect[0] + 34, k + rect[1] + 2, item.getImageID() % 16 * 16, 179 + item.getImageID() / 16 * 16, 16, 16);
                if (item.hasSubmenu()) {
                    subrect = item.getSubRect(this.dropdownX, this.dropdownY, i);
                    srcX = item.getIsSubMenuOpen() ? 0 : 43;
                    srcY = 133;
                    guiGraphics.blit(resourceLocation, j + subrect[0], k + subrect[1], srcX, srcY, subrect[2], subrect[3]);
                }
                switch (item.getType()) {
                    case BOOL: {
                        this.drawBooleanBox(guiGraphics, resourceLocation, x, y, 5 + rect[0], 5 + rect[1], item.getBOOL());
                        continue block5;
                    }
                    case INT: {
                        if (item.getIsSubMenuOpen()) {
                            this.drawIncreamentBox(guiGraphics, resourceLocation, x, y, this.getOffSetXForSubMenuBox(0, 2) + subrect[0], 3 + subrect[1]);
                            this.drawDecreamentBox(guiGraphics, resourceLocation, x, y, this.getOffSetXForSubMenuBox(1, 2) + subrect[0], 3 + subrect[1]);
                        }
                        int targetX = rect[0] + 16;
                        int targetY = rect[1] + 7;
                        int valueToWrite = item.getINT();
                        if (valueToWrite >= 10) {
                            this.drawDigit(guiGraphics, resourceLocation, valueToWrite / 10, -1, targetX, targetY);
                            this.drawDigit(guiGraphics, resourceLocation, valueToWrite % 10, 1, targetX, targetY);
                            continue block5;
                        }
                        this.drawDigit(guiGraphics, resourceLocation, valueToWrite, 0, targetX, targetY);
                        continue block5;
                    }
                    case MULTIBOOL: {
                        if (!item.getIsSubMenuOpen()) continue block5;
                        int count = item.getMULTIBOOLCount();
                        for (int bool = 0; bool < count; ++bool) {
                            this.drawBooleanBox(guiGraphics, resourceLocation, x, y, subrect[0] + this.getOffSetXForSubMenuBox(bool, count), subrect[1] + 3, item.getMULTIBOOL(bool));
                        }
                        continue block5;
                    }
                }
            }
        }
    }

    private void drawString(GuiGraphics guiGraphics, ResourceLocation resourceLocation, String str, int x, int y) {
        str = str.toUpperCase();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            int index = this.validChars.indexOf(c);
            if (index == -1) continue;
            guiGraphics.blit(resourceLocation, x + 7 * i, y, 8 * index, 165, 6, 7);
        }
    }

    private int getOffSetXForSubMenuBox(int id, int count) {
        return 2 + (int)(20.0f + ((float)id - (float)count / 2.0f) * 10.0f);
    }

    private void drawDigit(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int digit, int offset, int targetX, int targetY) {
        int srcX = digit * 8;
        int srcY = 172;
        guiGraphics.blit(resourceLocation, this.getGuiLeft() + (targetX += offset * 4), this.getGuiTop() + targetY, srcX, 172, 6, 7);
    }

    private void drawIncreamentBox(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int mouseX, int mouseY, int x, int y) {
        this.drawStandardBox(guiGraphics, resourceLocation, mouseX, mouseY, x, y, 10);
    }

    private void drawDecreamentBox(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int mouseX, int mouseY, int x, int y) {
        this.drawStandardBox(guiGraphics, resourceLocation, mouseX, mouseY, x, y, 20);
    }

    private void drawBooleanBox(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int mouseX, int mouseY, int x, int y, boolean itemvalue) {
        this.drawStandardBox(guiGraphics, resourceLocation, mouseX, mouseY, x, y, 0);
        if (itemvalue) {
            guiGraphics.blit(resourceLocation, this.getGuiLeft() + x + 2, this.getGuiTop() + y + 2, 0, 159, 6, 6);
        }
    }

    public boolean inRect(int x, int y, int[] coords) {
        return coords != null && x >= coords[0] && x < coords[0] + coords[2] && y >= coords[1] && y < coords[1] + coords[3];
    }

    private void drawStandardBox(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int mouseX, int mouseY, int x, int y, int srcX) {
        int targetX = this.getGuiLeft() + x;
        int targetY = this.getGuiTop() + y;
        int srcY = 149;
        guiGraphics.blit(resourceLocation, targetX, targetY, srcX, 149, 10, 10);
        if (this.inRect(mouseX, mouseY, new int[]{targetX, targetY, 10, 10})) {
            guiGraphics.blit(resourceLocation, targetX, targetY, 30, 149, 10, 10);
        }
    }

    private boolean clickBox(int mouseX, int mouseY, int x, int y) {
        return this.inRect(mouseX, mouseY, new int[]{x, y, 10, 10});
    }

    public void mouseMoved(double x0, double y0) {
    }

    public boolean mouseDragged(double x0, double y0, int button, double p_231045_6_, double p_231045_8_) {
        super.mouseMoved(x0, y0);
        int x = (int)(x0 - (double)this.getGuiLeft());
        int y = (int)(y0 - (double)this.getGuiTop());
        if (this.dropdownX != -1 && this.dropdownY != -1) {
            ArrayList<DropDownMenuItem> items = this.assembler.getDropDown();
            for (int i = 0; i < items.size(); ++i) {
                boolean insideRect;
                DropDownMenuItem item = items.get(i);
                boolean insideSubRect = false;
                if (item.hasSubmenu()) {
                    insideSubRect = this.inRect(x, y, item.getSubRect(this.dropdownX, this.dropdownY, i));
                    if (!insideSubRect && item.getIsSubMenuOpen()) {
                        item.setIsSubMenuOpen(false);
                    } else if (insideSubRect && !item.getIsSubMenuOpen()) {
                        item.setIsSubMenuOpen(true);
                    }
                }
                boolean bl = insideRect = insideSubRect || this.inRect(x, y, item.getRect(this.dropdownX, this.dropdownY, i));
                if (!insideRect && item.getIsLarge()) {
                    item.setIsLarge(false);
                    continue;
                }
                if (!insideRect || item.getIsLarge()) continue;
                item.setIsLarge(true);
            }
        }
        if (this.isScrolling) {
            if (button != -1) {
                this.isScrolling = false;
                this.assembler.setSpinning(true);
            } else {
                this.assembler.setYaw(this.assembler.getYaw() + (float)x - (float)this.scrollingX);
                this.assembler.setRoll(this.assembler.getRoll() + (float)y - (float)this.scrollingY);
                this.scrollingX = x;
                this.scrollingY = y;
            }
        }
        return true;
    }

    public boolean mouseClicked(double x0, double y0, int button) {
        super.mouseClicked(x0, y0, button);
        int x = (int)(x0 - (double)this.getGuiLeft());
        int y = (int)(y0 - (double)this.getGuiTop());
        if (this.inRect(x, y, this.assembleRect)) {
            PacketHandler.sendToServer(new PacketCreateCart(this.assembler.getBlockPos(), 0, new byte[0]));
            return true;
        }
        if (this.inRect(x, y, this.blackBackground)) {
            if (button == 0) {
                if (!this.isScrolling) {
                    this.scrollingX = x;
                    this.scrollingY = y;
                    this.isScrolling = true;
                    this.spin = !this.spin;
                    return true;
                }
            } else if (button == 1) {
                this.dropdownX = x;
                this.dropdownY = y;
                if (this.dropdownY + this.assembler.getDropDown().size() * 20 > 164) {
                    this.dropdownY = 164 - this.assembler.getDropDown().size() * 20;
                    return true;
                }
            }
        } else {
            ArrayList<SlotAssembler> slots = this.assembler.getSlots();
            for (int i = 1; i < slots.size(); ++i) {
                SlotAssembler slot = slots.get(i);
                int targetX = slot.getX() - 1;
                int targetY = slot.getY() - 1;
                int size = 18;
                if (!this.inRect(x, y, new int[]{targetX, targetY, 18, 18}) || slot.getItem().isEmpty() || TileEntityCartAssembler.getSlotStatus(slot.getItem()) > 0) continue;
                PacketHandler.sendToServer(new PacketCreateCart(this.assembler.getBlockPos(), 1, new byte[]{(byte)i}));
                return true;
            }
        }
        if (button == 0 && this.dropdownX != -1 && this.dropdownY != -1) {
            boolean anyLargeItem = false;
            ArrayList<DropDownMenuItem> items = this.assembler.getDropDown();
            block6: for (int j = 0; j < items.size(); ++j) {
                DropDownMenuItem item = items.get(j);
                if (!item.getIsLarge()) continue;
                anyLargeItem = true;
                int[] rect = item.getRect(this.dropdownX, this.dropdownY, j);
                int[] subrect = new int[]{};
                if (item.hasSubmenu() && item.getIsSubMenuOpen()) {
                    subrect = item.getSubRect(this.dropdownX, this.dropdownY, j);
                }
                switch (item.getType()) {
                    case BOOL: {
                        if (!this.clickBox(x, y, 5 + rect[0], 5 + rect[1])) continue block6;
                        item.setBOOL(!item.getBOOL());
                        continue block6;
                    }
                    case INT: {
                        if (!item.getIsSubMenuOpen()) continue block6;
                        if (this.clickBox(x, y, this.getOffSetXForSubMenuBox(0, 2) + subrect[0], 3 + subrect[1])) {
                            item.setINT(item.getINT() + 1);
                        }
                        if (!this.clickBox(x, y, this.getOffSetXForSubMenuBox(1, 2) + subrect[0], 3 + subrect[1])) continue block6;
                        item.setINT(item.getINT() - 1);
                        continue block6;
                    }
                    case MULTIBOOL: {
                        if (!item.getIsSubMenuOpen()) continue block6;
                        int count = item.getMULTIBOOLCount();
                        for (int bool = 0; bool < count; ++bool) {
                            if (!this.clickBox(x, y, subrect[0] + this.getOffSetXForSubMenuBox(bool, count), subrect[1] + 3)) continue;
                            item.setMULTIBOOL(bool, !item.getMULTIBOOL(bool));
                            continue block6;
                        }
                        continue block6;
                    }
                }
            }
            if (!anyLargeItem) {
                int n = -1;
                this.dropdownY = -1;
                this.dropdownX = -1;
            }
        }
        return true;
    }

    static {
        for (int i = 0; i < backgrounds.length; ++i) {
            GuiCartAssembler.backgrounds[i] = ResourceHelper.getResource("/gui/garageBackground" + i + ".png");
        }
        textureLeft = ResourceHelper.getResource("/gui/garagePart1.png");
        textureRight = ResourceHelper.getResource("/gui/garagePart2.png");
        textureExtra = ResourceHelper.getResource("/gui/garageExtra.png");
    }

    private record TextWithColor(FormattedCharSequence text, int color) {
        public FormattedCharSequence getText() {
            return this.text;
        }

        public int getColor() {
            return this.color;
        }
    }
}

