/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.entities.EntityMinecartModular;

public class RenderModulerCart
extends EntityRenderer<EntityMinecartModular> {
    public RenderModulerCart(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(EntityMinecartModular entity, float yaw, float tickDelta, @NotNull PoseStack poseStack, @NotNull MultiBufferSource vertexConsumers, int light) {
        boolean flip;
        if (entity.isInvisible()) {
            return;
        }
        if (entity.getModules() != null) {
            for (ModuleBase module : entity.getModules()) {
                if (module.shouldCartRender()) continue;
                return;
            }
        }
        super.render((Entity)entity, yaw, tickDelta, poseStack, vertexConsumers, light);
        poseStack.pushPose();
        long randomIsh = (long)entity.getId() * 493286711L;
        randomIsh = randomIsh * randomIsh * 4392167121L + randomIsh * 98761L;
        float h = (((float)(randomIsh >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float j = (((float)(randomIsh >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float k = (((float)(randomIsh >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        poseStack.translate(h, j, k);
        double renderX = Mth.lerp((double)tickDelta, (double)entity.xOld, (double)entity.getX());
        double renderY = Mth.lerp((double)tickDelta, (double)entity.yOld, (double)entity.getY());
        double renderZ = Mth.lerp((double)tickDelta, (double)entity.zOld, (double)entity.getZ());
        double offset = 0.3f;
        Vec3 vec3 = entity.getPos(renderX, renderY, renderZ);
        float pitch = Mth.lerp((float)tickDelta, (float)entity.xRotO, (float)entity.getXRot());
        if (vec3 != null) {
            Vec3 vec3d2 = entity.getPosOffs(renderX, renderY, renderZ, offset);
            Vec3 vec3d3 = entity.getPosOffs(renderX, renderY, renderZ, -offset);
            if (vec3d2 == null) {
                vec3d2 = vec3;
            }
            if (vec3d3 == null) {
                vec3d3 = vec3;
            }
            poseStack.translate(vec3.x - renderX, (vec3d2.y + vec3d3.y) / 2.0 - renderY, vec3.z - renderZ);
            Vec3 vec3d4 = vec3d3.add(-vec3d2.x, -vec3d2.y, -vec3d2.z);
            if (vec3d4.length() != 0.0) {
                vec3d4 = vec3d4.normalize();
                yaw = (float)(Math.atan2(vec3d4.z, vec3d4.x) * 180.0 / Math.PI);
                pitch = (float)(Math.atan(vec3d4.y) * 73.0);
            }
        }
        boolean bl = flip = entity.getDeltaMovement().x > 0.0 != entity.getDeltaMovement().z > 0.0;
        if (entity.cornerFlip) {
            flip = !flip;
        }
        if (entity.getRenderFlippedYaw(yaw + (flip ? 0.0f : 180.0f))) {
            flip = !flip;
        }
        poseStack.translate(0.0, 0.375, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        poseStack.mulPose(Axis.ZP.rotationDegrees(-pitch));
        float damageWobbleTicks = (float)entity.getHurtTime() - tickDelta;
        float damageWobbleStrength = Mth.clamp((float)(entity.getDamage() - tickDelta), (float)0.0f, (float)Float.MAX_VALUE);
        if (damageWobbleStrength < 0.0f) {
            damageWobbleStrength = 0.0f;
        }
        if (damageWobbleTicks > 0.0f) {
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)damageWobbleTicks) * damageWobbleTicks * damageWobbleStrength / 10.0f * (float)entity.getHurtDir()));
        }
        yaw += flip ? 0.0f : 180.0f;
        poseStack.mulPose(Axis.YP.rotationDegrees(flip ? 0.0f : 180.0f));
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        if (entity.getModules() != null) {
            for (ModuleBase module : entity.getModules()) {
                if (!module.haveModels()) continue;
                for (ModelCartbase model : module.getModels()) {
                    if (model.getRenderType(module) == null) continue;
                    model.applyEffects(module, poseStack, vertexConsumers, yaw, pitch, 0.0f);
                    model.renderToBuffer(poseStack, vertexConsumers.getBuffer(model.getRenderType(module)), light, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }
        poseStack.popPose();
        this.renderLabels(entity, poseStack, vertexConsumers, light);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull EntityMinecartModular p_114482_) {
        return new ResourceLocation("textures/entity/minecart.png");
    }

    protected void renderLabels(EntityMinecartModular cart, PoseStack poseStack, MultiBufferSource bufferSource, int p_114502_) {
        ArrayList<Component> labels = cart.getLabel();
        if (labels == null || this.entityRenderDispatcher.distanceToSqr((Entity)cart) > 4096.0) {
            return;
        }
        float f = cart.getBbHeight() + 1.5f;
        poseStack.pushPose();
        poseStack.translate(0.0, (double)f, 0.0);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        poseStack.scale(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        float f1 = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        Font font = this.getFont();
        int height = 0;
        for (int i = 0; i < labels.size(); ++i) {
            Component label = labels.get(i);
            float f2 = -font.width((FormattedText)label) / 2;
            font.drawInBatch(label, f2, (float)height, 0x20FFFFFF, false, matrix4f, bufferSource, Font.DisplayMode.NORMAL, j, p_114502_);
            font.drawInBatch(label, f2, (float)height, -1, false, matrix4f, bufferSource, Font.DisplayMode.NORMAL, 0, p_114502_);
            Objects.requireNonNull(font);
            height += 9;
        }
        poseStack.popPose();
    }
}

