/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.containers;

import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class ContainerBase
extends AbstractContainerMenu {
    public ContainerBase(@Nullable MenuType<?> p_i50105_1_, int p_i50105_2_) {
        super(p_i50105_1_, p_i50105_2_);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slotIndex) {
        ItemStack originalStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        int numSlots = this.slots.size();
        if (slot != null && slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            originalStack = stackInSlot.copy();
            if ((slotIndex < numSlots - 36 || !this.tryShiftItem(stackInSlot, numSlots)) && (slotIndex >= numSlots - 36 && slotIndex < numSlots - 9 ? !this.shiftItemStack(stackInSlot, numSlots - 9, numSlots) : (slotIndex >= numSlots - 9 && slotIndex < numSlots ? !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots - 9) : !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots)))) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(stackInSlot, originalStack);
            if (stackInSlot.getCount() <= 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stackInSlot.getCount() == originalStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stackInSlot);
        }
        return originalStack;
    }

    protected boolean shiftItemStack(ItemStack stackToShift, int start, int end) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.isStackable()) {
            for (slotIndex = start; stackToShift.getCount() > 0 && slotIndex < end; ++slotIndex) {
                int max;
                slot = (Slot)this.slots.get(slotIndex);
                stackInSlot = slot.getItem();
                if (stackInSlot.isEmpty() || !ContainerBase.canStacksMerge(stackInSlot, stackToShift)) continue;
                int resultingStackSize = stackInSlot.getCount() + stackToShift.getCount();
                if (resultingStackSize <= (max = Math.min(stackToShift.getMaxStackSize(), slot.getMaxStackSize()))) {
                    stackToShift.setCount(0);
                    stackInSlot.setCount(resultingStackSize);
                    slot.setChanged();
                    changed = true;
                    continue;
                }
                if (stackInSlot.getCount() >= max) continue;
                stackToShift.setCount(stackToShift.getCount() - (max - stackInSlot.getCount()));
                stackInSlot.setCount(max);
                slot.setChanged();
                changed = true;
            }
        }
        if (stackToShift.getCount() > 0) {
            for (slotIndex = start; stackToShift.getCount() > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.slots.get(slotIndex);
                stackInSlot = slot.getItem();
                if (!stackInSlot.isEmpty()) continue;
                int max = Math.min(stackToShift.getMaxStackSize(), slot.getMaxStackSize());
                stackInSlot = stackToShift.copy();
                stackInSlot.setCount(Math.min(stackToShift.getCount(), max));
                stackToShift.setCount(stackToShift.getCount() - stackInSlot.getCount());
                slot.set(stackInSlot);
                slot.setChanged();
                changed = true;
            }
        }
        return changed;
    }

    private boolean tryShiftItem(ItemStack stackToShift, int numSlots) {
        for (int machineIndex = 0; machineIndex < numSlots - 36; ++machineIndex) {
            Slot slot = (Slot)this.slots.get(machineIndex);
            if (!slot.mayPlace(stackToShift) || !this.shiftItemStack(stackToShift, machineIndex, machineIndex + 1)) continue;
            return true;
        }
        return false;
    }

    public static boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        if (stack1.isEmpty() || stack2.isEmpty()) {
            return false;
        }
        return ItemStack.isSameItemSameTags((ItemStack)stack1, (ItemStack)stack2);
    }

    public void receiveGuiData(int id, int data) {
    }
}

