/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.containers.slots;

import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import vswe.stevescarts.api.modules.ModuleType;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.items.ItemCarts;

public class SlotAssembler
extends Slot {
    private final ModuleType moduleType;
    private final int xPos;
    private final int yPos;
    private final TileEntityCartAssembler assembler;
    private int openingAnimation;
    private final int id;
    private boolean isValid;
    private final boolean useLarge;

    public SlotAssembler(TileEntityCartAssembler assembler, int i, int j, int k, ModuleType moduleType, boolean useLarge, int id) {
        super((Container)assembler, i, j, k);
        this.assembler = assembler;
        this.useLarge = useLarge;
        this.moduleType = moduleType;
        this.xPos = j;
        this.yPos = k;
        this.isValid = true;
        this.id = id;
    }

    private void invalidationCheck() {
        this.x = -3000;
        this.y = -3000;
        if (this.openingAnimation > 8) {
            this.openingAnimation = 8;
        }
    }

    public void update() {
        if (this.assembler.getLevel() == null) {
            return;
        }
        if (!this.assembler.getLevel().isClientSide) {
            if (!this.isValid() && this.hasItem()) {
                this.assembler.puke(this.getItem());
                this.set(ItemStack.EMPTY);
            }
        } else if (this.isValid()) {
            if (this.openingAnimation == 8) {
                this.x = this.getX();
                this.y = this.getY();
                ++this.openingAnimation;
            } else if (this.openingAnimation < 8) {
                ++this.openingAnimation;
            }
        } else {
            this.openingAnimation = this.openingAnimation > 0 ? --this.openingAnimation : this.id * -3;
        }
    }

    public void setChanged() {
        super.setChanged();
        if (this.shouldUpdatePlaceholder()) {
            this.assembler.updatePlaceholder();
        } else {
            this.assembler.isErrorListOutdated = true;
        }
    }

    public boolean useLargeInterface() {
        return this.useLarge;
    }

    public boolean mayPlace(@Nonnull ItemStack itemstack) {
        return this.isValid && ModuleData.isValidModuleItem(this.moduleType, itemstack);
    }

    public void invalidate() {
        this.isValid = false;
        this.invalidationCheck();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public void validate() {
        this.isValid = true;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int getAnimationTick() {
        return this.openingAnimation;
    }

    public int getX() {
        return this.xPos;
    }

    public int getY() {
        return this.yPos;
    }

    public TileEntityCartAssembler getAssembler() {
        return this.assembler;
    }

    public boolean shouldUpdatePlaceholder() {
        return true;
    }

    public boolean mayPickup(Player player) {
        if (this.getItem().getItem() instanceof ItemCarts && this.assembler.getIsAssembling()) {
            return false;
        }
        return !this.getItem().isEmpty() && (!this.getItem().hasTag() || !this.getItem().getTag().contains("ModifyStatus") || this.getItem().getTag().getInt("ModifyStatus") > 0);
    }
}

