/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.containers.slots;

import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.helpers.storages.SCTank;

public class SlotLiquidInput
extends SlotStevesCarts {
    private SCTank tank;
    private int maxsize;

    public SlotLiquidInput(Container iinventory, SCTank tank, int maxsize, int i, int j, int k) {
        super(iinventory, i, j, k);
        this.tank = tank;
        this.maxsize = maxsize;
    }

    public boolean mayPlace(@NotNull ItemStack itemStack) {
        Optional opt = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (!opt.isPresent()) {
            return false;
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)opt.orElseThrow(RuntimeException::new);
        FluidStack fluidStack = fluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        if (fluidStack.isEmpty() && !this.tank.getFluid().isEmpty()) {
            return true;
        }
        return this.tank.getFluid().isEmpty() || this.tank.getFluid().isFluidEqual(fluidStack);
    }

    public int getMaxStackSize() {
        if (this.maxsize != -1) {
            return this.maxsize;
        }
        return Math.min(8, this.tank.getCapacity() / 1000);
    }
}

