/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Nullable;
import vswe.stevescarts.helpers.ModularEnchantments;

public class EnchantmentData {
    @Nullable
    private Enchantment enchant;
    private int value;
    private boolean dirty = false;

    public EnchantmentData(Enchantment enchant) {
        this.enchant = enchant;
        this.value = 0;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int val) {
        this.value = val;
        this.dirty = true;
    }

    public void setEnchantment(Enchantment enchant) {
        this.enchant = enchant;
        this.dirty = true;
    }

    public Enchantment getEnchant() {
        return this.enchant;
    }

    public void damageEnchant(int dmg) {
        this.damageEnchantLevel(dmg, this.getValue(), 1);
        if (this.getValue() <= 0) {
            this.setEnchantment(null);
        }
    }

    private boolean damageEnchantLevel(int dmg, int value, int level) {
        if (this.enchant == null) {
            return false;
        }
        if (level > this.enchant.getMaxLevel() || value <= 0) {
            return false;
        }
        int levelvalue = ModularEnchantments.getValue(this.enchant, level);
        if (!this.damageEnchantLevel(dmg, value - levelvalue, level + 1)) {
            int dmgdealt = dmg * (int)Math.pow(2.0, level - 1);
            if (dmgdealt > value) {
                dmgdealt = value;
            }
            this.setValue(this.getValue() - dmgdealt);
        }
        return true;
    }

    public int getLevel() {
        if (this.enchant == null) {
            return 0;
        }
        int value = this.getValue();
        for (int i = 0; i < this.enchant.getMaxLevel(); ++i) {
            if (value <= 0) {
                return i;
            }
            value -= ModularEnchantments.getValue(this.enchant, i + 1);
        }
        return this.enchant.getMaxLevel();
    }

    public String getInfoText() {
        if (this.enchant == null) {
            return "";
        }
        int value = this.getValue();
        int level = 0;
        int percentage = 0;
        for (level = 1; level <= this.enchant.getMaxLevel(); ++level) {
            if (value <= 0) continue;
            int levelvalue = ModularEnchantments.getValue(this.enchant, level);
            percentage = 100 * value / levelvalue;
            if ((value -= levelvalue) < 0) break;
        }
        return ChatFormatting.YELLOW + this.enchant.getFullname(this.getLevel()).getString() + "\n" + percentage + "% left of this tier";
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.enchant == null ? -1 : this.value);
        if (this.enchant != null) {
            buf.writeResourceLocation(Objects.requireNonNull(BuiltInRegistries.ENCHANTMENT.getKey((Object)this.enchant)));
        }
    }

    public static EnchantmentData read(FriendlyByteBuf buf) {
        int value = buf.readVarInt();
        EnchantmentData data = new EnchantmentData(value == -1 ? null : (Enchantment)BuiltInRegistries.ENCHANTMENT.get(buf.readResourceLocation()));
        data.setValue(value);
        return data;
    }

    public boolean isDirty() {
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        return false;
    }
}

