/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers;

import java.util.Collection;
import java.util.HashMap;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.interfaces.IActivatorModule;
import vswe.stevescarts.api.modules.interfaces.ISuppliesModule;
import vswe.stevescarts.api.modules.template.ModuleChest;
import vswe.stevescarts.arcade.monopoly.Villager;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.modules.addons.ModuleChunkLoader;
import vswe.stevescarts.modules.addons.ModuleInvisible;
import vswe.stevescarts.modules.addons.ModulePowerObserver;
import vswe.stevescarts.modules.addons.ModuleShield;
import vswe.stevescarts.modules.realtimers.ModuleCage;
import vswe.stevescarts.modules.realtimers.ModuleCakeServer;
import vswe.stevescarts.modules.realtimers.ModuleShooter;
import vswe.stevescarts.modules.storages.tanks.ModuleTank;
import vswe.stevescarts.modules.workers.ModuleBridge;
import vswe.stevescarts.modules.workers.ModuleFertilizer;
import vswe.stevescarts.modules.workers.ModuleRailer;
import vswe.stevescarts.modules.workers.ModuleTorch;
import vswe.stevescarts.modules.workers.tools.ModuleDrill;
import vswe.stevescarts.modules.workers.tools.ModuleFarmer;
import vswe.stevescarts.modules.workers.tools.ModuleWoodcutter;

public class ModuleState {
    private static HashMap<Byte, ModuleState> states = new HashMap();
    private Class<? extends ModuleBase> moduleClass;
    private Localization.GUI.DETECTOR name;
    private byte id;
    private STATETYPE type;

    public static HashMap<Byte, ModuleState> getStates() {
        return states;
    }

    public static Collection<ModuleState> getStateList() {
        return states.values();
    }

    public ModuleState(int id, Class<? extends ModuleBase> moduleClass, Localization.GUI.DETECTOR name, STATETYPE type) {
        this.moduleClass = moduleClass;
        this.name = name;
        this.id = (byte)id;
        this.type = type;
        states.put(this.id, this);
    }

    public boolean evaluate(EntityMinecartModular cart) {
        switch (this.type) {
            case SUPPLY: {
                for (ModuleBase module : cart.getModules()) {
                    if (!this.isModuleOfCorrectType(module) || !(module instanceof ISuppliesModule)) continue;
                    return ((ISuppliesModule)((Object)module)).haveSupplies();
                }
                break;
            }
            case ACTIVATION: {
                for (ModuleBase module : cart.getModules()) {
                    if (!this.isModuleOfCorrectType(module) || !(module instanceof IActivatorModule)) continue;
                    return ((IActivatorModule)((Object)module)).isActive(0);
                }
                break;
            }
            case INVENTORY: {
                if (!(this instanceof ModuleStateInv)) break;
                boolean hasModule = false;
                for (ModuleBase module2 : cart.getModules()) {
                    if (!this.isModuleOfCorrectType(module2)) continue;
                    ModuleChest chest = (ModuleChest)module2;
                    if (((ModuleStateInv)this).full && !chest.isCompletelyFilled()) {
                        return false;
                    }
                    if (!((ModuleStateInv)this).full && !chest.isCompletelyEmpty()) {
                        return false;
                    }
                    hasModule = true;
                }
                return hasModule;
            }
            case PASSENGER: {
                if (cart.getPassengers().isEmpty()) break;
                Entity passenger = (Entity)cart.getPassengers().get(0);
                return ((ModuleStatePassenger)this).passengerClass.isAssignableFrom(passenger.getClass()) && ((ModuleStatePassenger)this).isPassengerValid(passenger);
            }
            case POWER: {
                for (ModuleBase module2 : cart.getModules()) {
                    if (!this.isModuleOfCorrectType(module2)) continue;
                    return ((ModulePowerObserver)module2).isAreaActive(((ModuleStatePower)this).areaId);
                }
                break;
            }
            case TANK: {
                if (!(this instanceof ModuleStateTank)) break;
                boolean hasModule2 = false;
                for (ModuleBase module3 : cart.getModules()) {
                    if (!this.isModuleOfCorrectType(module3)) continue;
                    ModuleTank tank = (ModuleTank)module3;
                    boolean result = ((ModuleStateTank)this).full ? tank.isCompletelyFilled() : tank.isCompletelyEmpty();
                    if (result == ((ModuleStateTank)this).individual) {
                        return result;
                    }
                    hasModule2 = !((ModuleStateTank)this).individual;
                }
                return hasModule2;
            }
        }
        return false;
    }

    private boolean isModuleOfCorrectType(ModuleBase module) {
        return this.moduleClass.isAssignableFrom(module.getClass());
    }

    public String getName() {
        return this.name.translate(new String[0]);
    }

    public byte getID() {
        return this.id;
    }

    static {
        new ModuleState(0, ModuleRailer.class, Localization.GUI.DETECTOR.RAIL, STATETYPE.SUPPLY);
        new ModuleState(1, ModuleTorch.class, Localization.GUI.DETECTOR.TORCH, STATETYPE.SUPPLY);
        new ModuleState(2, ModuleWoodcutter.class, Localization.GUI.DETECTOR.SAPLING, STATETYPE.SUPPLY);
        new ModuleState(3, ModuleFarmer.class, Localization.GUI.DETECTOR.SEED, STATETYPE.SUPPLY);
        new ModuleState(5, ModuleBridge.class, Localization.GUI.DETECTOR.BRIDGE, STATETYPE.SUPPLY);
        new ModuleState(40, ModuleShooter.class, Localization.GUI.DETECTOR.PROJECTILE, STATETYPE.SUPPLY);
        new ModuleState(41, ModuleFertilizer.class, Localization.GUI.DETECTOR.FERTILIZING, STATETYPE.SUPPLY);
        new ModuleState(49, ModuleCakeServer.class, Localization.GUI.DETECTOR.CAKE, STATETYPE.SUPPLY);
        new ModuleState(6, ModuleShield.class, Localization.GUI.DETECTOR.SHIELD, STATETYPE.ACTIVATION);
        new ModuleState(7, ModuleChunkLoader.class, Localization.GUI.DETECTOR.CHUNK, STATETYPE.ACTIVATION);
        new ModuleState(8, ModuleInvisible.class, Localization.GUI.DETECTOR.INVISIBILITY, STATETYPE.ACTIVATION);
        new ModuleState(9, ModuleDrill.class, Localization.GUI.DETECTOR.DRILL, STATETYPE.ACTIVATION);
        new ModuleState(12, ModuleCage.class, Localization.GUI.DETECTOR.CAGE, STATETYPE.ACTIVATION);
        new ModuleStateInv(10, Localization.GUI.DETECTOR.STORAGE_FULL, true);
        new ModuleStateInv(11, Localization.GUI.DETECTOR.STORAGE_EMPTY, false);
        new ModuleStatePassenger(13, Localization.GUI.DETECTOR.PASSENGER, LivingEntity.class);
        new ModuleStatePassenger(14, Localization.GUI.DETECTOR.ANIMAL, Animal.class);
        new ModuleStatePassenger(15, Localization.GUI.DETECTOR.TAMEABLE, TamableAnimal.class);
        new ModuleStatePassenger(16, Localization.GUI.DETECTOR.BREEDABLE, AgeableMob.class);
        new ModuleStatePassenger(17, Localization.GUI.DETECTOR.HOSTILE, Mob.class);
        new ModuleStatePassenger(18, Localization.GUI.DETECTOR.CREEPER, Creeper.class);
        new ModuleStatePassenger(19, Localization.GUI.DETECTOR.SKELETON, Skeleton.class);
        new ModuleStatePassenger(20, Localization.GUI.DETECTOR.SPIDER, Spider.class);
        new ModuleStatePassenger(21, Localization.GUI.DETECTOR.ZOMBIE, Zombie.class);
        new ModuleStatePassenger(22, Localization.GUI.DETECTOR.PIG_MAN, Piglin.class);
        new ModuleStatePassenger(23, Localization.GUI.DETECTOR.SILVERFISH, Silverfish.class);
        new ModuleStatePassenger(24, Localization.GUI.DETECTOR.BLAZE, Blaze.class);
        new ModuleStatePassenger(25, Localization.GUI.DETECTOR.BAT, Bat.class);
        new ModuleStatePassenger(26, Localization.GUI.DETECTOR.WITCH, Witch.class);
        new ModuleStatePassenger(27, Localization.GUI.DETECTOR.PIG, Piglin.class);
        new ModuleStatePassenger(28, Localization.GUI.DETECTOR.SHEEP, Sheep.class);
        new ModuleStatePassenger(29, Localization.GUI.DETECTOR.COW, Cow.class);
        new ModuleStatePassenger(30, Localization.GUI.DETECTOR.MOOSHROOM, MushroomCow.class);
        new ModuleStatePassenger(31, Localization.GUI.DETECTOR.CHICKEN, Chicken.class);
        new ModuleStatePassenger(32, Localization.GUI.DETECTOR.WOLF, Wolf.class);
        new ModuleStatePassenger(34, Localization.GUI.DETECTOR.OCELOT, Ocelot.class);
        new ModuleStatePassenger(35, Localization.GUI.DETECTOR.VILLAGER, Villager.class);
        new ModuleStatePassenger(36, Localization.GUI.DETECTOR.PLAYER, Player.class);
        new ModuleStatePassenger(37, Localization.GUI.DETECTOR.ZOMBIE, Zombie.class){

            @Override
            public boolean isPassengerValid(Entity passenger) {
                return passenger instanceof ZombieVillager;
            }
        };
        new ModuleStatePassenger(38, Localization.GUI.DETECTOR.CHILD, AgeableMob.class){

            @Override
            public boolean isPassengerValid(Entity passenger) {
                return ((AgeableMob)passenger).getAge() > 0;
            }
        };
        new ModuleStatePassenger(39, Localization.GUI.DETECTOR.TAMED, TamableAnimal.class){

            @Override
            public boolean isPassengerValid(Entity passenger) {
                return ((TamableAnimal)passenger).isTame();
            }
        };
        new ModuleStatePower(42, Localization.GUI.DETECTOR.POWER_RED, 0);
        new ModuleStatePower(43, Localization.GUI.DETECTOR.POWER_BLUE, 1);
        new ModuleStatePower(44, Localization.GUI.DETECTOR.POWER_GREEN, 2);
        new ModuleStatePower(45, Localization.GUI.DETECTOR.POWER_YELLOW, 3);
        new ModuleStateTank(46, Localization.GUI.DETECTOR.TANKS_FULL, true, false);
        new ModuleStateTank(47, Localization.GUI.DETECTOR.TANKS_EMPTY, false, false);
        new ModuleStateTank(48, Localization.GUI.DETECTOR.TANK_EMPTY, false, true);
    }

    public static enum STATETYPE {
        SUPPLY,
        ACTIVATION,
        INVENTORY,
        PASSENGER,
        POWER,
        TANK;

    }

    private static class ModuleStateInv
    extends ModuleState {
        private boolean full;

        public ModuleStateInv(int id, Localization.GUI.DETECTOR name, boolean full) {
            super(id, ModuleChest.class, name, STATETYPE.INVENTORY);
            this.full = full;
        }
    }

    private static class ModuleStatePassenger
    extends ModuleState {
        private Class passengerClass;

        public ModuleStatePassenger(int id, Localization.GUI.DETECTOR name, Class passengerClass) {
            super(id, null, name, STATETYPE.PASSENGER);
            this.passengerClass = passengerClass;
        }

        public boolean isPassengerValid(Entity passenger) {
            return this.passengerClass.isAssignableFrom(passenger.getClass());
        }
    }

    private static class ModuleStatePower
    extends ModuleState {
        private int areaId;

        public ModuleStatePower(int id, Localization.GUI.DETECTOR name, int areaId) {
            super(id, ModulePowerObserver.class, name, STATETYPE.POWER);
            this.areaId = areaId;
        }
    }

    private static class ModuleStateTank
    extends ModuleState {
        private boolean full;
        private boolean individual;

        public ModuleStateTank(int id, Localization.GUI.DETECTOR name, boolean full, boolean individual) {
            super(id, ModuleTank.class, name, STATETYPE.TANK);
            this.full = full;
            this.individual = individual;
        }
    }
}

