/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers;

import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;

public class RecipeHelper {
    public static Optional<RecipeHolder<SmeltingRecipe>> findSmeltRecipe(ItemStack stack, Level level) {
        return RecipeHelper.findRecipe(RecipeType.SMELTING, new DummySingleItem(stack), level);
    }

    public static <C extends Container, T extends Recipe<C>> Optional<RecipeHolder<T>> findRecipe(RecipeType<T> type, C container, Level level) {
        return level.getRecipeManager().getRecipeFor(type, container, level);
    }

    private static class DummySingleItem
    implements Container {
        private final ItemStack stack;

        public DummySingleItem(ItemStack stack) {
            this.stack = stack;
        }

        public int getContainerSize() {
            return 1;
        }

        public boolean isEmpty() {
            return false;
        }

        public ItemStack getItem(int p_18941_) {
            return this.stack;
        }

        public ItemStack removeItem(int p_18942_, int p_18943_) {
            return ItemStack.EMPTY;
        }

        public ItemStack removeItemNoUpdate(int p_18951_) {
            return null;
        }

        public void setItem(int p_18944_, ItemStack p_18945_) {
        }

        public void setChanged() {
        }

        public boolean stillValid(Player p_18946_) {
            return true;
        }

        public void clearContent() {
        }
    }
}

