/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers.storages;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.text.NumberFormat;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.storages.ITankHolder;

public class SCTank
extends FluidTank {
    private final ITankHolder owner;
    private final int tankid;
    private boolean isLocked;

    public SCTank(ITankHolder owner, int tankSize, int tankid) {
        super(tankSize);
        this.owner = owner;
        this.tankid = tankid;
    }

    public SCTank copy() {
        SCTank tank = new SCTank(this.owner, this.capacity, this.tankid);
        if (!this.getFluid().isEmpty()) {
            tank.setFluid(this.getFluid().copy());
        }
        return tank;
    }

    public void containerTransfer() {
        ItemStack itemStack = this.owner.getInputContainer(this.tankid);
        if (itemStack.isEmpty()) {
            return;
        }
        FluidUtil.getFluidHandler((ItemStack)itemStack).ifPresent(itemHandler -> {
            FluidStack fluidStack = itemHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            if (!fluidStack.isEmpty()) {
                FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)this, (int)1000, null, (boolean)false);
                if (result.isSuccess()) {
                    IFluidHandlerItem handler;
                    ItemStack container = result.getResult();
                    Optional opt = FluidUtil.getFluidHandler((ItemStack)container);
                    if (opt.isPresent() && !(fluidStack = (handler = (IFluidHandlerItem)opt.orElseThrow(RuntimeException::new)).drain(1000, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && fluidStack.getAmount() == 1000) {
                        FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)this, (int)1000, null, (boolean)true);
                        this.owner.setInputContainer(this.tankid, container);
                        return;
                    }
                    if (!container.isEmpty()) {
                        this.owner.addToOutputContainer(this.tankid, container);
                    }
                    if (container.getCount() == 0) {
                        FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)this, (int)1000, null, (boolean)true);
                        itemStack.shrink(1);
                        if (itemStack.isEmpty()) {
                            this.owner.setInputContainer(this.tankid, ItemStack.EMPTY);
                        }
                    }
                }
            } else {
                ItemStack container;
                FluidActionResult result = SCTank.tryFillContainer(itemStack, (IFluidHandler)this, Integer.MAX_VALUE, null, false);
                if (result.isSuccess() && !(container = result.getResult()).isEmpty()) {
                    this.owner.addToOutputContainer(this.tankid, container);
                    if (container.getCount() == 0) {
                        FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)this, (int)1000, null, (boolean)true);
                        itemStack.shrink(1);
                        if (itemStack.isEmpty()) {
                            this.owner.setInputContainer(this.tankid, ItemStack.EMPTY);
                        }
                    }
                }
            }
        });
    }

    @Deprecated
    public static FluidActionResult tryFillContainer(@NotNull ItemStack container, IFluidHandler fluidSource, int maxAmount, @Nullable Player player, boolean doFill) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return FluidUtil.getFluidHandler((ItemStack)containerCopy).map(containerFluidHandler -> {
            FluidStack simulatedTransfer = FluidUtil.tryFluidTransfer((IFluidHandler)containerFluidHandler, (IFluidHandler)fluidSource, (int)maxAmount, (boolean)false);
            if (!simulatedTransfer.isEmpty()) {
                if (doFill) {
                    FluidUtil.tryFluidTransfer((IFluidHandler)containerFluidHandler, (IFluidHandler)fluidSource, (int)maxAmount, (boolean)true);
                    if (player != null) {
                        SoundEvent soundevent = simulatedTransfer.getFluid().getFluidType().getSound(simulatedTransfer, SoundActions.BUCKET_FILL);
                        player.level().playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    containerFluidHandler.fill(simulatedTransfer, IFluidHandler.FluidAction.EXECUTE);
                }
                ItemStack resultContainer = containerFluidHandler.getContainer();
                return new FluidActionResult(resultContainer);
            }
            return FluidActionResult.FAILURE;
        }).orElse(FluidActionResult.FAILURE);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.fluid.isEmpty() || maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        int drained = maxDrain;
        if (this.fluid.getAmount() < drained) {
            drained = this.fluid.getAmount();
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            this.fluid.shrink(drained);
            if (this.fluid.getAmount() <= 0 && !this.isLocked) {
                this.fluid = FluidStack.EMPTY;
            }
            this.onContentsChanged();
        }
        return stack;
    }

    public void setLocked(boolean val) {
        this.isLocked = val;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public String getMouseOver() {
        String name = Localization.MODULES.TANKS.EMPTY.translate(new String[0]);
        int amount = 0;
        if (!this.fluid.isEmpty()) {
            name = this.fluid.getDisplayName().getString();
            amount = this.fluid.getAmount();
        }
        NumberFormat format = NumberFormat.getInstance();
        return name + ": " + format.format(amount) + " / " + format.format(this.capacity);
    }

    protected void onContentsChanged() {
        this.owner.onFluidUpdated(this.tankid);
    }

    public static void applyColour(FluidStack fluidStack) {
        int fluidColor = FluidStackHooks.getColor((Fluid)fluidStack.getFluid());
        float red = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(fluidColor & 0xFF) / 255.0f;
        float alpha = (float)(fluidColor >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawFluid(GuiGraphics guiGraphics, AbstractContainerScreen<?> gui, int startX, int startY) {
        if (this.fluid.isEmpty()) {
            return;
        }
        int fluidLevel = (int)(48.0f * ((float)this.fluid.getAmount() / (float)this.capacity));
        TextureAtlasSprite icon = FluidStackHooks.getStillTexture((Fluid)this.fluid.getFluid());
        if (icon == null) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        SCTank.applyColour(this.fluid);
        for (int y = 0; y < 3; ++y) {
            int pixels = fluidLevel - (2 - y) * 16;
            if (pixels <= 0) continue;
            if (pixels > 16) {
                pixels = 16;
            }
            for (int x = 0; x < 2; ++x) {
                this.owner.drawImage(guiGraphics, this.tankid, gui, icon, startX + 2 + 16 * x, startY + 1 + 16 * y + (16 - pixels), 16, pixels);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

