/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers.storages;

import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import vswe.stevescarts.containers.slots.ISpecialItemTransferValidator;
import vswe.stevescarts.containers.slots.ISpecialSlotValidator;

public class TransferHandler {
    public static boolean isSlotOfType(Slot slot, Class slotType) {
        if (slot instanceof ISpecialSlotValidator) {
            ISpecialSlotValidator specSlot = (ISpecialSlotValidator)slot;
            return specSlot.isSlotValid();
        }
        return slotType.isInstance(slot);
    }

    public static boolean isItemValidForTransfer(Slot slot, @Nonnull ItemStack item, TRANSFER_TYPE type) {
        if (slot instanceof ISpecialItemTransferValidator) {
            ISpecialItemTransferValidator specSlot = (ISpecialItemTransferValidator)slot;
            return specSlot.isItemValidForTransfer(item, type);
        }
        return slot.mayPlace(item);
    }

    public static void TransferItem(@Nonnull ItemStack iStack, Container inv, AbstractContainerMenu cont, int maxItems) {
        TransferHandler.TransferItem(iStack, inv, cont, Slot.class, null, maxItems);
    }

    public static void TransferItem(@Nonnull ItemStack iStack, Container inv, AbstractContainerMenu cont, Class validSlot, int maxItems, TRANSFER_TYPE type) {
        TransferHandler.TransferItem(iStack, inv, 0, inv.getContainerSize() - 1, cont, validSlot, null, maxItems, type, false);
    }

    public static void TransferItem(@Nonnull ItemStack iStack, Container inv, AbstractContainerMenu cont, Class validSlot, Class invalidSlot, int maxItems) {
        TransferHandler.TransferItem(iStack, inv, 0, inv.getContainerSize() - 1, cont, validSlot, invalidSlot, maxItems);
    }

    public static void TransferItem(@Nonnull ItemStack iStack, Container inv, int start, int end, AbstractContainerMenu cont, Class validSlot, Class invalidSlot, int maxItems) {
        TransferHandler.TransferItem(iStack, inv, start, end, cont, validSlot, invalidSlot, maxItems, TRANSFER_TYPE.OTHER, false);
    }

    public static void TransferItem(@Nonnull ItemStack iStack, Container inv, int start, int end, AbstractContainerMenu cont, Class validSlot, Class invalidSlot, int maxItems, TRANSFER_TYPE type, boolean fake) {
        int pos;
        start = Math.max(0, start);
        end = Math.min(inv.getContainerSize() - 1, end);
        int startEmpty = start;
        int startOccupied = start;
        do {
            int i;
            pos = -1;
            for (i = startEmpty; i <= end; ++i) {
                if (!TransferHandler.isSlotOfType(cont.getSlot(i), validSlot) || invalidSlot != null && TransferHandler.isSlotOfType(cont.getSlot(i), invalidSlot) || inv.getItem(i).isEmpty() || inv.getItem(i).getItem() != iStack.getItem() || !inv.getItem(i).isStackable() || inv.getItem(i).getCount() >= inv.getItem(i).getMaxStackSize() || inv.getItem(i).getCount() >= cont.getSlot(i).getMaxStackSize() || inv.getItem(i).getCount() <= 0 || iStack.getCount() <= 0 || inv.getItem(i).getTag() != null && !inv.getItem(i).getTag().equals((Object)iStack.getTag())) continue;
                pos = i;
                startEmpty = pos + 1;
                break;
            }
            if (pos == -1) {
                for (i = startOccupied; i <= end; ++i) {
                    Slot slot;
                    if (!TransferHandler.isSlotOfType(cont.getSlot(i), validSlot) || invalidSlot != null && TransferHandler.isSlotOfType(cont.getSlot(i), invalidSlot) || !TransferHandler.isItemValidForTransfer(slot = cont.getSlot(i), iStack, type) || !inv.getItem(i).isEmpty()) continue;
                    pos = i;
                    startOccupied = pos + 1;
                    break;
                }
            }
            if (pos == -1) continue;
            ItemStack existingItem = null;
            if (inv.getItem(pos).isEmpty()) {
                ItemStack clone = iStack.copy();
                clone.setCount(0);
                if (!fake) {
                    inv.setItem(pos, clone);
                }
                existingItem = clone;
            } else {
                existingItem = inv.getItem(pos);
            }
            int stackSize = iStack.getCount();
            if (stackSize > existingItem.getMaxStackSize() - existingItem.getCount()) {
                stackSize = existingItem.getMaxStackSize() - existingItem.getCount();
            }
            if (stackSize > cont.getSlot(pos).getMaxStackSize() - existingItem.getCount()) {
                stackSize = cont.getSlot(pos).getMaxStackSize() - existingItem.getCount();
            }
            boolean killMe = false;
            if (maxItems != -1) {
                if (stackSize > maxItems) {
                    stackSize = maxItems;
                    killMe = true;
                }
                maxItems -= stackSize;
            }
            if (stackSize <= 0) {
                pos = -1;
                continue;
            }
            iStack.shrink(stackSize);
            if (!fake) {
                ItemStack stackInSlot = inv.getItem(pos);
                stackInSlot.grow(stackSize);
            }
            if (iStack.getCount() != 0 && !killMe && maxItems != 0) continue;
            pos = -1;
        } while (pos != -1);
        if (!fake) {
            inv.setChanged();
        }
    }

    public static enum TRANSFER_TYPE {
        SHIFT,
        MANAGER,
        OTHER;

    }
}

