/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.IModuleItem;
import vswe.stevescarts.api.modules.data.ModuleData;

public class ItemCartModule
extends Item
implements IModuleItem {
    public ModuleData moduleData;

    public ItemCartModule(ModuleData moduleData) {
        super(new Item.Properties());
        this.moduleData = moduleData;
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        return Component.translatable((String)("item.stevescarts." + this.moduleData.getRawName()));
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> textComponents, @NotNull TooltipFlag flag) {
        if (this.moduleData != null) {
            this.moduleData.addInformation(textComponents, stack.getTag());
            if (flag.isAdvanced()) {
                textComponents.add((Component)Component.literal((String)("ID " + this.moduleData.getID())));
            }
        }
        super.appendHoverText(stack, world, textComponents, flag);
    }

    @Override
    public ModuleData getModuleData() {
        return this.moduleData;
    }

    @Override
    public void addExtraDataToCart(CompoundTag save, @Nonnull ItemStack module, int i) {
        if (module.getTag() != null && module.getTag().contains("Data")) {
            save.putByte("Data" + i, module.getTag().getByte("Data"));
        } else {
            IModuleItem itemCartModule = (IModuleItem)module.getItem();
            ModuleData data = itemCartModule.getModuleData();
            if (data.isUsingExtraData()) {
                save.putByte("Data" + i, data.getDefaultExtraData());
            }
        }
    }
}

