/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.items;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.api.StevesCartsAPI;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.client.renders.ItemStackRenderer;
import vswe.stevescarts.entities.EntityMinecartModular;

public class ItemCarts
extends MinecartItem {
    public ItemCarts() {
        super(AbstractMinecart.Type.RIDEABLE, new Item.Properties().stacksTo(1).rarity(Rarity.EPIC));
    }

    public String getName() {
        return "Modular Cart";
    }

    public InteractionResult useOn(UseOnContext itemUseContext) {
        BlockState blockstate;
        Player player = itemUseContext.getPlayer();
        Level world = itemUseContext.getLevel();
        ItemStack stack = player.getItemInHand(itemUseContext.getHand());
        BlockPos pos = itemUseContext.getClickedPos();
        if (!world.isClientSide && (blockstate = world.getBlockState(pos)).is(BlockTags.RAILS)) {
            block8: {
                try {
                    CompoundTag info = stack.getTag();
                    if (info == null || info.contains("maxTime")) break block8;
                    try {
                        EntityMinecartModular cart = new EntityMinecartModular(world, (float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f, info, (Component)Component.literal((String)""));
                        world.addFreshEntity((Entity)cart);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        player.displayClientMessage((Component)Component.literal((String)("The cart failed to be placed into the world, this is due to an issue with one or more modules. Please post your log on the issue tracker here: " + ChatFormatting.BLUE + " https://github.com/modmuss50/SC2/issues")), false);
                        StevesCarts.LOGGER.error(" --------------- Broken cart info --------------- ");
                        StevesCarts.LOGGER.error((Object)info);
                        ByteArrayTag moduleIDTag = (ByteArrayTag)info.get("Modules");
                        for (byte id : moduleIDTag.getAsByteArray()) {
                            try {
                                Class<? extends ModuleBase> moduleClass = StevesCartsAPI.MODULE_REGISTRY.get(id).getModuleClass();
                                StevesCarts.LOGGER.error("--- " + moduleClass.getCanonicalName());
                            }
                            catch (Exception ex) {
                                StevesCarts.LOGGER.error("Failed to load module with ID " + id + "! More info below.");
                                e.printStackTrace();
                            }
                        }
                        StevesCarts.LOGGER.error(" --------------- Broken cart info --------------- ");
                        return InteractionResult.FAIL;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return InteractionResult.FAIL;
                }
            }
            stack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(@NotNull ItemStack item, @Nullable Level p_77624_2_, @NotNull List<Component> list, @NotNull TooltipFlag p_77624_4_) {
        if (item.getTag() != null && item.getTag().contains("modules")) {
            list.add((Component)Component.literal((String)(ChatFormatting.BLUE + "Installed Modules:")));
            ListTag moduleListTag = (ListTag)item.getTag().get("modules");
            if (moduleListTag != null && !moduleListTag.isEmpty()) {
                for (int i = 0; i < moduleListTag.size(); ++i) {
                    CompoundTag moduleTag = (CompoundTag)moduleListTag.get(i);
                    ResourceLocation resourceLocation = new ResourceLocation(moduleTag.getString(String.valueOf(i)));
                    ModuleData moduleData = StevesCartsAPI.MODULE_REGISTRY.get(resourceLocation);
                    if (moduleData == null) continue;
                    list.add((Component)Component.literal((String)(ChatFormatting.GOLD + moduleData.getDisplayName())));
                }
            } else {
                list.add((Component)Component.literal((String)(ChatFormatting.RED + "No modules loaded")));
            }
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ItemStackRenderer.getInstance();
            }
        });
    }
}

