/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotEnchantment;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.EnchantmentData;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ModularEnchantments;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.init.ModSerializers;

public class ModuleEnchants
extends ModuleAddon {
    private final EntityDataAccessor<EnchantmentData> ENCHANT_0 = this.createDw((EntityDataSerializer)ModSerializers.ENCHANT_DATA.get());
    private final EntityDataAccessor<EnchantmentData> ENCHANT_1 = this.createDw((EntityDataSerializer)ModSerializers.ENCHANT_DATA.get());
    private final EntityDataAccessor<EnchantmentData> ENCHANT_2 = this.createDw((EntityDataSerializer)ModSerializers.ENCHANT_DATA.get());
    private final ArrayList<ModularEnchantments.EnchantmentType> enabledTypes = new ArrayList();

    public ModuleEnchants(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void initDw() {
        this.registerDw(this.ENCHANT_0, new EnchantmentData(null));
        this.registerDw(this.ENCHANT_1, new EnchantmentData(null));
        this.registerDw(this.ENCHANT_2, new EnchantmentData(null));
    }

    @Override
    public int numberOfDataWatchers() {
        return 3;
    }

    public EnchantmentData getEnchant(int index) {
        return this.getDw(index == 0 ? this.ENCHANT_0 : (index == 1 ? this.ENCHANT_1 : this.ENCHANT_2));
    }

    public void setEnchant(int index, EnchantmentData data) {
        this.updateDw(index == 0 ? this.ENCHANT_0 : (index == 1 ? this.ENCHANT_1 : this.ENCHANT_2), data, data.isDirty());
    }

    public int getFortuneLevel() {
        if (this.useSilkTouch()) {
            return 0;
        }
        return this.getEnchantLevel(Enchantments.BLOCK_FORTUNE);
    }

    public boolean useSilkTouch() {
        return false;
    }

    public int getUnbreakingLevel() {
        return this.getEnchantLevel(Enchantments.UNBREAKING);
    }

    public int getEfficiencyLevel() {
        return this.getEnchantLevel(Enchantments.BLOCK_EFFICIENCY);
    }

    public int getPowerLevel() {
        return this.getEnchantLevel(Enchantments.POWER_ARROWS);
    }

    public int getPunchLevel() {
        return this.getEnchantLevel(Enchantments.PUNCH_ARROWS);
    }

    public boolean useFlame() {
        return this.getEnchantLevel(Enchantments.FLAMING_ARROWS) > 0;
    }

    public boolean useInfinity() {
        return this.getEnchantLevel(Enchantments.INFINITY_ARROWS) > 0;
    }

    private int getEnchantLevel(Enchantment enchant) {
        for (int i = 0; i < 3; ++i) {
            EnchantmentData test = this.getEnchant(i);
            if (test.getEnchant() == null || test.getEnchant() != enchant) continue;
            return test.getLevel();
        }
        return 0;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    protected int getInventoryHeight() {
        return 3;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotEnchantment(this.getCart(), this.enabledTypes, slotId, 8, 14 + y * 20);
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().level().isClientSide) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (this.getStack(i).isEmpty() || this.getStack(i).getCount() <= 0) continue;
            int count = this.getStack(i).getCount();
            EnchantmentData data = ModularEnchantments.addBook(this.enabledTypes, this.getEnchant(i), this.getStack(i));
            if (this.getStack(i).getCount() == count) continue;
            boolean valid = true;
            for (int j = 0; j < 3; ++j) {
                if (i == j) continue;
                EnchantmentData data2 = this.getEnchant(j);
                if (data.getEnchant() == null || data2.getEnchant() == null || data.getEnchant() != data2.getEnchant()) continue;
                data.setEnchantment(null);
                ItemStack stack = this.getStack(i);
                stack.grow(1);
                valid = false;
                break;
            }
            if (valid && this.getStack(i).getCount() <= 0) {
                this.setStack(i, ItemStack.EMPTY);
            }
            this.setEnchant(i, data);
        }
    }

    public void damageEnchant(ModularEnchantments.EnchantmentType type, int dmg) {
        for (int i = 0; i < 3; ++i) {
            EnchantmentData data = this.getEnchant(i);
            if (data.getEnchant() == null || ModularEnchantments.getType(data.getEnchant()) != type) continue;
            data.damageEnchant(dmg);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/enchant.png");
        for (int i = 0; i < 3; ++i) {
            int[] box = this.getBoxRect(i);
            if (this.inRect(x, y, box)) {
                this.drawImage(guiGraphics, gui, box, 65, 0);
            } else {
                this.drawImage(guiGraphics, gui, box, 0, 0);
            }
            EnchantmentData data = this.getEnchant(i);
            if (data.getEnchant() == null) continue;
            int maxlevel = data.getEnchant().getMaxLevel();
            int value = data.getValue();
            for (int j = 0; j < maxlevel; ++j) {
                int[] bar = this.getBarRect(i, j, maxlevel);
                if (j != maxlevel - 1) {
                    this.drawImage(guiGraphics, gui, bar[0] + bar[2], bar[1], 61 + j, 1, 1, bar[3]);
                }
                int levelmaxvalue = ModularEnchantments.getValue(data.getEnchant(), j + 1);
                if (value > 0) {
                    float mult = (float)value / (float)levelmaxvalue;
                    if (mult > 1.0f) {
                        mult = 1.0f;
                    }
                    bar[2] = (int)((float)bar[2] * mult);
                    this.drawImage(guiGraphics, gui, bar, 1, 13 + 11 * j);
                }
                value -= levelmaxvalue;
            }
        }
    }

    @Override
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        for (int i = 0; i < 3; ++i) {
            EnchantmentData data = this.getEnchant(i);
            String str = data.getEnchant() != null ? data.getInfoText() : Localization.MODULES.ADDONS.ENCHANT_INSTRUCTION.translate(new String[0]);
            this.drawStringOnMouseOver(guiGraphics, gui, str, x, y, this.getBoxRect(i));
        }
    }

    private int[] getBoxRect(int id) {
        return new int[]{40, 17 + id * 20, 61, 12};
    }

    private int[] getBarRect(int id, int barid, int maxlevel) {
        int width = (59 - (maxlevel - 1)) / maxlevel;
        return new int[]{41 + (width + 1) * barid, 18 + id * 20, width, 10};
    }

    @Override
    public int numberOfGuiData() {
        return 9;
    }

    @Override
    protected void Save(CompoundTag nbt, int id) {
        super.Save(nbt, id);
        for (int i = 0; i < 3; ++i) {
            EnchantmentData data = this.getEnchant(i);
            if (data.getEnchant() == null) continue;
            nbt.putString(this.generateNBTName("EffectId" + i, id), BuiltInRegistries.ENCHANTMENT.getKey((Object)data.getEnchant()).toString());
            nbt.putInt(this.generateNBTName("Value" + i, id), data.getValue());
        }
    }

    @Override
    protected void Load(CompoundTag nbt, int id) {
        super.Load(nbt, id);
        for (int i = 0; i < 3; ++i) {
            if (!nbt.contains(this.generateNBTName("EffectId" + i, id))) continue;
            EnchantmentData data = new EnchantmentData((Enchantment)BuiltInRegistries.ENCHANTMENT.get(new ResourceLocation(nbt.getString(this.generateNBTName("EffectId" + i, id)))));
            data.setValue(nbt.getInt(this.generateNBTName("Value" + i, id)));
            this.setEnchant(i, data);
        }
    }

    @Override
    public int guiWidth() {
        return 110;
    }

    public void addType(ModularEnchantments.EnchantmentType type) {
        this.enabledTypes.add(type);
    }
}

