/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.api.modules.template.ModuleEngine;
import vswe.stevescarts.api.modules.template.ModuleTool;
import vswe.stevescarts.api.slots.SlotChest;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.LabelInformation;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;

public class ModuleLabel
extends ModuleAddon {
    private ArrayList<LabelInformation> labels = new ArrayList<1>();
    private int delay = 0;
    private ArrayList<SlotStevesCarts> storageSlots;
    private ModuleTool tool;
    private EntityDataAccessor<Integer> SECONDS;
    private EntityDataAccessor<Byte> USED;
    private EntityDataAccessor<Integer> DATA;
    private EntityDataAccessor<Byte> ACTIVE;

    public ModuleLabel(EntityMinecartModular cart) {
        super(cart);
        this.labels.add(new LabelInformation(Localization.MODULES.ADDONS.NAME){

            @Override
            public Component getLabel() {
                return ModuleLabel.this.getCart().getName();
            }
        });
        this.labels.add(new LabelInformation(Localization.MODULES.ADDONS.DISTANCE){

            @Override
            public Component getLabel() {
                return Component.literal((String)Localization.MODULES.ADDONS.DISTANCE_LONG.translate(String.valueOf((int)ModuleLabel.this.getCart().distanceTo((Entity)ModuleLabel.this.getClientPlayer()))));
            }
        });
        this.labels.add(new LabelInformation(Localization.MODULES.ADDONS.POSITION){

            @Override
            public Component getLabel() {
                return Component.literal((String)Localization.MODULES.ADDONS.POSITION_LONG.translate(String.valueOf(ModuleLabel.this.getCart().x()), String.valueOf(ModuleLabel.this.getCart().y()), String.valueOf(ModuleLabel.this.getCart().z())));
            }
        });
        this.labels.add(new LabelInformation(Localization.MODULES.ADDONS.FUEL){

            @Override
            public Component getLabel() {
                int seconds = (Integer)ModuleLabel.this.getDw(ModuleLabel.this.SECONDS);
                if (seconds == -1) {
                    return Component.literal((String)Localization.MODULES.ADDONS.FUEL_NO_CONSUMPTION.translate(new String[0]));
                }
                int minutes = seconds / 60;
                seconds -= minutes * 60;
                int hours = minutes / 60;
                return Component.literal((String)String.format(Localization.MODULES.ADDONS.FUEL_LONG.translate(new String[0]) + ": %02d:%02d:%02d", hours, minutes -= hours * 60, seconds));
            }
        });
        this.labels.add(new LabelInformation(Localization.MODULES.ADDONS.STORAGE){

            @Override
            public Component getLabel() {
                int used = ((Byte)ModuleLabel.this.getDw(ModuleLabel.this.USED)).byteValue();
                if (used < 0) {
                    used += 256;
                }
                return Component.literal((String)(ModuleLabel.this.storageSlots == null ? "" : Localization.MODULES.ADDONS.STORAGE.translate(new String[0]) + ": " + used + "/" + ModuleLabel.this.storageSlots.size() + (String)(ModuleLabel.this.storageSlots.size() == 0 ? "" : "[" + (int)(100.0f * (float)used / (float)ModuleLabel.this.storageSlots.size()) + "%]")));
            }
        });
    }

    @Override
    public void preInit() {
        if (this.getCart().getModules() != null) {
            for (ModuleBase moduleBase : this.getCart().getModules()) {
                if (!(moduleBase instanceof ModuleTool)) continue;
                this.tool = (ModuleTool)moduleBase;
                this.labels.add(new LabelInformation(Localization.MODULES.ADDONS.DURABILITY){

                    @Override
                    public Component getLabel() {
                        if (!ModuleLabel.this.tool.useDurability()) {
                            return Component.literal((String)Localization.MODULES.ADDONS.UNBREAKABLE.translate(new String[0]));
                        }
                        int data = (Integer)ModuleLabel.this.getDw(ModuleLabel.this.DATA);
                        if (data == 0) {
                            return Component.literal((String)Localization.MODULES.ADDONS.BROKEN.translate(new String[0]));
                        }
                        if (data > 0) {
                            return Component.literal((String)(Localization.MODULES.ADDONS.DURABILITY.translate(new String[0]) + ": " + data + " / " + ModuleLabel.this.tool.getMaxDurability() + " [" + 100 * data / ModuleLabel.this.tool.getMaxDurability() + "%]"));
                        }
                        if (data == -1) {
                            return Component.empty();
                        }
                        if (data == -2) {
                            return Component.literal((String)Localization.MODULES.ADDONS.NOT_BROKEN.translate(new String[0]));
                        }
                        return Component.literal((String)(Localization.MODULES.ADDONS.REPAIR.translate(new String[0]) + " [" + -(data + 3) + "%]"));
                    }
                });
                break;
            }
        }
    }

    @Override
    public void init() {
        this.storageSlots = new ArrayList();
        for (ModuleBase module : this.getCart().getModules()) {
            if (module.getSlots() == null) continue;
            for (SlotStevesCarts slot : module.getSlots()) {
                if (!(slot instanceof SlotChest)) continue;
                this.storageSlots.add(slot);
            }
        }
    }

    private boolean hasTool() {
        return this.tool != null;
    }

    private boolean hasToolWithDurability() {
        return this.hasTool() && this.tool.useDurability();
    }

    @Override
    public void addToLabel(ArrayList<Component> label) {
        for (int i = 0; i < this.labels.size(); ++i) {
            if (!this.isActive(i)) continue;
            label.add(this.labels.get(i).getLabel());
        }
    }

    private int[] getBoxArea(int i) {
        return new int[]{10, 17 + i * 12, 8, 8};
    }

    @Override
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/label.png");
        for (int i = 0; i < this.labels.size(); ++i) {
            int[] rect = this.getBoxArea(i);
            this.drawImage(guiGraphics, gui, rect, this.isActive(i) ? 8 : 0, 0);
            this.drawImage(guiGraphics, gui, rect, this.inRect(x, y, rect) ? 8 : 0, 8);
        }
    }

    private boolean isActive(int i) {
        return !this.isPlaceholder() && (this.getDw(this.ACTIVE) & 1 << i) != 0;
    }

    private void toggleActive(int i) {
        this.updateDw(this.ACTIVE, (byte)(this.getDw(this.ACTIVE) ^ 1 << i));
    }

    @Override
    public int numberOfDataWatchers() {
        int count = 3;
        if (this.hasToolWithDurability()) {
            ++count;
        }
        return count;
    }

    @Override
    public void initDw() {
        this.SECONDS = this.createDw(EntityDataSerializers.INT);
        this.USED = this.createDw(EntityDataSerializers.BYTE);
        this.DATA = this.createDw(EntityDataSerializers.INT);
        this.ACTIVE = this.createDw(EntityDataSerializers.BYTE);
        this.registerDw(this.ACTIVE, (byte)0);
        this.registerDw(this.SECONDS, 0);
        this.registerDw(this.USED, (byte)0);
        if (this.hasToolWithDurability()) {
            this.registerDw(this.DATA, -1);
        }
    }

    @Override
    public void update() {
        if (!this.isPlaceholder() && !this.getCart().level().isClientSide) {
            if (this.delay <= 0) {
                int data;
                if (this.isActive(3)) {
                    data = 0;
                    for (ModuleEngine engine : this.getCart().getEngines()) {
                        if (engine.getPriority() == 3) continue;
                        data += engine.getTotalFuel();
                    }
                    if (data != 0) {
                        int consumption = this.getCart().getConsumption();
                        data = consumption == 0 ? -1 : (data /= consumption * 20);
                    }
                    this.updateDw(this.SECONDS, data);
                }
                if (this.isActive(4)) {
                    data = 0;
                    for (SlotStevesCarts slot : this.storageSlots) {
                        if (!slot.hasItem()) continue;
                        ++data;
                    }
                    this.updateDw(this.USED, (byte)data);
                }
                if (this.hasToolWithDurability()) {
                    if (this.isActive(5)) {
                        if (this.tool.isRepairing()) {
                            if (this.tool.isActuallyRepairing()) {
                                this.updateDw(this.DATA, -3 - this.tool.getRepairPercentage());
                            } else {
                                this.updateDw(this.DATA, -2);
                            }
                        } else {
                            this.updateDw(this.DATA, this.tool.getCurrentDurability());
                        }
                    } else if (this.getDw(this.DATA) != -1) {
                        this.updateDw(this.DATA, -1);
                    }
                }
                this.delay = 20;
            } else if (this.delay > 0) {
                --this.delay;
            }
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        for (int i = 0; i < this.labels.size(); ++i) {
            int[] rect = this.getBoxArea(i);
            if (!this.inRect(x, y, rect)) continue;
            this.sendPacket(0, (byte)i);
            break;
        }
    }

    @Override
    protected int numberOfPackets() {
        return 1;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            this.toggleActive(data[0]);
        }
    }

    @Override
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, Localization.MODULES.ADDONS.LABELS.translate(new String[0]), 8, 6, 0x404040);
        for (int i = 0; i < this.labels.size(); ++i) {
            int[] rect = this.getBoxArea(i);
            this.drawString(guiGraphics, gui, this.labels.get(i).getName(), rect[0] + 12, rect[1] + 1, 0x404040);
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public int guiWidth() {
        return 92;
    }

    @Override
    public int guiHeight() {
        return 77;
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        this.updateDw(this.ACTIVE, tagCompound.getByte(this.generateNBTName("Active", id)));
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        tagCompound.putByte(this.generateNBTName("Active", id), this.getDw(this.ACTIVE).byteValue());
    }
}

