/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.IFluidBlock;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.modules.workers.ModuleLiquidDrainer;
import vswe.stevescarts.modules.workers.tools.ModuleDrill;

public class ModuleLiquidSensors
extends ModuleAddon {
    private float sensorRotation;
    private int activetime = -1;
    private int mult = 1;
    private EntityDataAccessor<Byte> SENSOR_INFO;

    public ModuleLiquidSensors(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        super.update();
        if (this.isDrillSpinning()) {
            this.sensorRotation += 0.05f * (float)this.mult;
            if (this.mult == 1 && (double)this.sensorRotation > 0.7853981633974483 || this.mult == -1 && (double)this.sensorRotation < -0.7853981633974483) {
                this.mult *= -1;
            }
        } else {
            if (this.sensorRotation != 0.0f) {
                if (this.sensorRotation > 0.0f) {
                    this.sensorRotation -= 0.05f;
                    if (this.sensorRotation < 0.0f) {
                        this.sensorRotation = 0.0f;
                    }
                } else {
                    this.sensorRotation += 0.05f;
                    if (this.sensorRotation > 0.0f) {
                        this.sensorRotation = 0.0f;
                    }
                }
            }
            if (this.activetime >= 0) {
                ++this.activetime;
                if (this.activetime >= 10) {
                    this.setLight(1);
                    this.activetime = -1;
                }
            }
        }
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.SENSOR_INFO = this.createDw(EntityDataSerializers.BYTE);
        this.registerDw(this.SENSOR_INFO, (byte)1);
    }

    private void activateLight(int light) {
        if (this.getLight() == 3 && light == 2) {
            return;
        }
        this.setLight(light);
        this.activetime = 0;
    }

    public void getInfoFromDrill(byte data) {
        byte light = (byte)(data & 3);
        if (light != 1) {
            this.activateLight(light);
        }
        data = (byte)(data & 0xFFFFFFFC);
        data = (byte)(data | (byte)this.getLight());
        this.setSensorInfo(data);
    }

    private void setLight(int val) {
        if (this.isPlaceholder()) {
            return;
        }
        byte data = this.getDw(this.SENSOR_INFO);
        data = (byte)(data & 0xFFFFFFFC);
        data = (byte)(data | (byte)val);
        this.setSensorInfo(data);
    }

    private void setSensorInfo(byte val) {
        if (this.isPlaceholder()) {
            return;
        }
        this.updateDw(this.SENSOR_INFO, val);
    }

    public int getLight() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getLiquidLight();
        }
        return this.getDw(this.SENSOR_INFO) & 3;
    }

    protected boolean isDrillSpinning() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getDrillSpinning();
        }
        return (this.getDw(this.SENSOR_INFO) & 4) != 0;
    }

    public float getSensorRotation() {
        return this.sensorRotation;
    }

    public boolean isDangerous(ModuleDrill drill, BlockPos pos, boolean isUp) {
        boolean isLiquid;
        Block block = this.getCart().level().getBlockState(pos).getBlock();
        if (block == Blocks.LAVA) {
            this.handleLiquid(drill, pos);
            return true;
        }
        if (block == Blocks.WATER) {
            this.handleLiquid(drill, pos);
            return true;
        }
        if (block != null && block instanceof IFluidBlock) {
            this.handleLiquid(drill, pos);
            return true;
        }
        boolean isWater = block == Blocks.WATER || block == Blocks.WATER || block == Blocks.ICE;
        boolean isLava = block == Blocks.LAVA || block == Blocks.LAVA;
        boolean isOther = block != null && block instanceof IFluidBlock;
        boolean bl = isLiquid = isWater || isLava || isOther;
        if (!isLiquid) {
            boolean isFalling;
            if (isUp && (isFalling = block instanceof FallingBlock)) {
                return this.isDangerous(drill, pos.offset(0, 1, 0), true) || this.isDangerous(drill, pos.offset(1, 0, 0), false) || this.isDangerous(drill, pos.offset(-1, 0, 0), false) || this.isDangerous(drill, pos.offset(0, 0, 1), false) || this.isDangerous(drill, pos.offset(0, 0, -1), false);
            }
            return false;
        }
        if (isUp) {
            this.handleLiquid(drill, pos);
            return true;
        }
        BlockState state = this.getCart().level().getBlockState(pos);
        return false;
    }

    private void handleLiquid(ModuleDrill drill, BlockPos pos) {
        ModuleLiquidDrainer liquiddrainer = null;
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleLiquidDrainer)) continue;
            liquiddrainer = (ModuleLiquidDrainer)module;
            break;
        }
        if (liquiddrainer != null) {
            liquiddrainer.handleLiquid(drill, pos);
        }
    }
}

