/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.api.slots.SlotChest;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.blocks.tileentities.TileEntityCargo;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;

public abstract class ModuleRecipe
extends ModuleAddon {
    private EntityDataAccessor<Byte> TARGET;
    private EntityDataAccessor<Byte> MAX_ITEM_COUNT;
    private EntityDataAccessor<Byte> MODE;
    protected boolean dirty = true;
    protected ArrayList<SlotStevesCarts> inputSlots;
    protected ArrayList<SlotStevesCarts> outputSlots;
    protected ArrayList<SlotStevesCarts> allTheSlots = new ArrayList();

    public ModuleRecipe(EntityMinecartModular cart) {
        super(cart);
        this.outputSlots = new ArrayList();
    }

    protected abstract int getLimitStartX();

    protected abstract int getLimitStartY();

    @Override
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        if (this.canUseAdvancedFeatures()) {
            int[] area = this.getArea();
            ResourceHelper.bindResource("/gui/recipe.png");
            this.drawImage(guiGraphics, gui, area[0] - 2, area[1] - 2, 0, 0, 20, 20);
            if (this.getDw(this.MODE) == 1) {
                for (int i = 0; i < 3; ++i) {
                    this.drawControlRect(guiGraphics, gui, x, y, i);
                }
            } else {
                this.drawControlRect(guiGraphics, gui, x, y, 1);
            }
        }
    }

    private void drawControlRect(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y, int i) {
        int[] rect;
        int v = i * 11;
        this.drawImage(guiGraphics, gui, rect, 20 + (this.inRect(x, y, rect = this.getControlRect(i)) ? 22 : 0), v);
    }

    private int[] getControlRect(int i) {
        return new int[]{this.getLimitStartX(), this.getLimitStartY() + 12 * i, 22, 11};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        if (this.canUseAdvancedFeatures()) {
            String str = null;
            switch (this.getDw(this.MODE)) {
                case 0: {
                    str = "Inf";
                    break;
                }
                case 1: {
                    str = String.valueOf(this.getDw(this.MAX_ITEM_COUNT));
                    break;
                }
                default: {
                    str = "X";
                }
            }
            this.drawString(guiGraphics, gui, str, this.getControlRect(1), 0x404040);
        }
    }

    @Override
    public void drawBackgroundItems(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        if (this.canUseAdvancedFeatures()) {
            ItemStack icon = this.isTargetInvalid() ? new ItemStack((ItemLike)Items.MINECART, 1) : TileEntityCargo.itemSelections.get(this.getDw(this.TARGET).byteValue()).getIcon();
            int[] area = this.getArea();
            this.drawItemInInterface(guiGraphics, gui, icon, area[0], area[1]);
        }
    }

    private boolean isTargetInvalid() {
        return this.getDw(this.TARGET) < 0 || this.getDw(this.TARGET) >= TileEntityCargo.itemSelections.size() || TileEntityCargo.itemSelections.get(this.getDw(this.TARGET).byteValue()).getValidSlot() == null;
    }

    @Override
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        if (this.canUseAdvancedFeatures()) {
            Object str = Localization.MODULES.ADDONS.RECIPE_OUTPUT.translate(new String[0]) + "\n" + Localization.MODULES.ADDONS.CURRENT.translate(new String[0]) + ": ";
            str = this.isTargetInvalid() ? str + Localization.MODULES.ADDONS.INVALID_OUTPUT.translate(new String[0]) : str + TileEntityCargo.itemSelections.get(this.getDw(this.TARGET).byteValue()).getName();
            this.drawStringOnMouseOver(guiGraphics, gui, (String)str, x, y, this.getArea());
            for (int i = 0; i < 3; ++i) {
                if (i == 1) {
                    str = Localization.MODULES.ADDONS.RECIPE_MODE.translate(new String[0]) + "\n" + Localization.MODULES.ADDONS.CURRENT.translate(new String[0]) + ": ";
                    switch (this.getDw(this.MODE)) {
                        case 0: {
                            str = str + Localization.MODULES.ADDONS.RECIPE_NO_LIMIT.translate(new String[0]);
                            break;
                        }
                        case 1: {
                            str = str + Localization.MODULES.ADDONS.RECIPE_LIMIT.translate(new String[0]);
                            break;
                        }
                        default: {
                            str = str + Localization.MODULES.ADDONS.RECIPE_DISABLED.translate(new String[0]);
                            break;
                        }
                    }
                } else {
                    str = this.getDw(this.MODE) != 1 ? null : Localization.MODULES.ADDONS.RECIPE_CHANGE_AMOUNT.translate(i == 0 ? "0" : "1") + "\n" + Localization.MODULES.ADDONS.RECIPE_CHANGE_AMOUNT_10.translate(new String[0]) + "\n" + Localization.MODULES.ADDONS.RECIPE_CHANGE_AMOUNT_64.translate(new String[0]);
                }
                if (str == null) continue;
                this.drawStringOnMouseOver(guiGraphics, gui, (String)str, x, y, this.getControlRect(i));
            }
        }
    }

    protected abstract int[] getArea();

    @Override
    public int numberOfGuiData() {
        return this.canUseAdvancedFeatures() ? 3 : 0;
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (this.canUseAdvancedFeatures()) {
            if (this.inRect(x, y, this.getArea())) {
                this.sendPacket(0, (byte)button);
            }
            for (int i = 0; i < 3; ++i) {
                if (this.getDw(this.MODE) != 1 && i != 1 || !this.inRect(x, y, this.getControlRect(i))) continue;
                if (i == 1) {
                    this.sendPacket(1, (byte)button);
                    break;
                }
                byte encodedData = (byte)(i != 0 ? 1 : 0);
                if (Screen.hasControlDown()) {
                    encodedData = (byte)(encodedData | 2);
                } else if (Screen.hasShiftDown()) {
                    encodedData = (byte)(encodedData | 4);
                }
                this.sendPacket(2, encodedData);
                break;
            }
        }
    }

    @Override
    protected int numberOfPackets() {
        return this.canUseAdvancedFeatures() ? 3 : 0;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (this.canUseAdvancedFeatures()) {
            int mode = this.getDw(this.MODE).byteValue();
            if (id == 0) {
                this.dirty = true;
                this.changeTarget(data[0] == 0);
            } else if (id == 1) {
                if (data[0] == 0) {
                    if (++mode > 2) {
                        mode = 0;
                    }
                } else if (--mode < 0) {
                    mode = 2;
                }
                this.updateDw(this.MODE, (byte)mode);
            } else if (id == 2) {
                int dif;
                int n = dif = (data[0] & 1) == 0 ? 1 : -1;
                if ((data[0] & 2) != 0) {
                    dif *= 64;
                } else if ((data[0] & 4) != 0) {
                    dif *= 10;
                }
                int maxItemCount = Math.min(Math.max(1, this.getDw(this.MAX_ITEM_COUNT) + dif), 999);
                this.updateDw(this.MAX_ITEM_COUNT, (byte)maxItemCount);
            }
        }
    }

    private void changeTarget(boolean up) {
        int target = this.getDw(this.TARGET).byteValue();
        if (target >= TileEntityCargo.itemSelections.size()) {
            this.updateDw(this.TARGET, (byte)0);
        } else {
            target = up ? ++target : --target;
            this.updateDw(this.TARGET, (byte)target);
        }
    }

    protected abstract boolean canUseAdvancedFeatures();

    protected Class getValidSlot() {
        if (this.isTargetInvalid()) {
            return null;
        }
        return TileEntityCargo.itemSelections.get(this.getDw(this.TARGET).byteValue()).getValidSlot();
    }

    @Override
    public int numberOfDataWatchers() {
        return 3;
    }

    @Override
    public void initDw() {
        super.initDw();
        this.TARGET = this.createDw(EntityDataSerializers.BYTE);
        this.MODE = this.createDw(EntityDataSerializers.BYTE);
        this.MAX_ITEM_COUNT = this.createDw(EntityDataSerializers.BYTE);
        this.registerDw(this.TARGET, (byte)3);
        this.registerDw(this.MODE, (byte)0);
        this.registerDw(this.MAX_ITEM_COUNT, (byte)1);
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        if (this.canUseAdvancedFeatures()) {
            this.updateDw(this.TARGET, tagCompound.getByte(this.generateNBTName("Target", id)));
            this.updateDw(this.MODE, tagCompound.getByte(this.generateNBTName("Mode", id)));
            this.updateDw(this.MAX_ITEM_COUNT, tagCompound.getByte(this.generateNBTName("MaxItems", id)));
        }
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        if (this.canUseAdvancedFeatures()) {
            tagCompound.putByte(this.generateNBTName("Target", id), this.getDw(this.TARGET).byteValue());
            tagCompound.putByte(this.generateNBTName("Mode", id), this.getDw(this.MODE).byteValue());
            tagCompound.putShort(this.generateNBTName("MaxItems", id), (short)this.getDw(this.MAX_ITEM_COUNT).byteValue());
        }
    }

    protected void prepareLists() {
        if (this.inputSlots == null) {
            this.inputSlots = new ArrayList();
            for (ModuleBase module : this.getCart().getModules()) {
                if (module.getSlots() == null) continue;
                for (SlotStevesCarts slot : module.getSlots()) {
                    if (!(slot instanceof SlotChest)) continue;
                    this.inputSlots.add(slot);
                }
            }
        }
        if (this.dirty) {
            this.allTheSlots.clear();
            this.outputSlots.clear();
            Class validSlot = this.getValidSlot();
            if (validSlot != null) {
                for (ModuleBase module2 : this.getCart().getModules()) {
                    if (module2.getSlots() == null) continue;
                    for (SlotStevesCarts slot2 : module2.getSlots()) {
                        if (validSlot.isInstance((Object)slot2)) {
                            this.outputSlots.add(slot2);
                            this.allTheSlots.add(slot2);
                            continue;
                        }
                        if (!(slot2 instanceof SlotChest)) continue;
                        this.allTheSlots.add(slot2);
                    }
                }
            }
            this.dirty = false;
        }
    }

    protected boolean canCraftMoreOfResult(@Nonnull ItemStack result) {
        if (this.getDw(this.MODE) == 0) {
            return true;
        }
        if (this.getDw(this.MODE) == 2) {
            return false;
        }
        byte count = 0;
        for (int i = 0; i < this.outputSlots.size(); ++i) {
            ItemStack item = this.outputSlots.get(i).getItem();
            if (item.isEmpty() || !ItemStack.isSameItem((ItemStack)item, (ItemStack)result) || !ItemStack.isSameItemSameTags((ItemStack)item, (ItemStack)result) || (count += item.getCount()) < this.getDw(this.MAX_ITEM_COUNT)) continue;
            return false;
        }
        return true;
    }
}

