/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import vswe.stevescarts.api.modules.interfaces.IActivatorModule;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;

public class ModuleShield
extends ModuleAddon
implements IActivatorModule {
    private boolean shield = true;
    private float shieldDistance = 18.0f;
    private float shieldAngle;
    private float lastShieldAngle;
    private int[] buttonRect = new int[]{20, 20, 24, 12};
    private EntityDataAccessor<Boolean> STATUS;
    private boolean setup;

    public ModuleShield(EntityMinecartModular cart) {
        super(cart);
    }

    protected boolean shieldSetting() {
        return this.getShieldStatus();
    }

    public float getShieldDistance() {
        return this.shieldDistance;
    }

    public float getShieldAngle() {
        return this.shieldAngle;
    }

    public float getLastShieldAngle() {
        return this.lastShieldAngle;
    }

    public boolean hasShield() {
        return this.shield;
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().level().isClientSide && !this.setup) {
            if (this.isPlaceholder() || !this.getDw(this.STATUS).booleanValue()) {
                this.shieldDistance = 0.0f;
                this.shield = false;
            }
            this.setup = true;
        }
        if (this.hasShield() && !this.getCart().hasFuelForModule() && !this.getCart().level().isClientSide) {
            this.setShieldStatus(false);
        }
        if (this.hasShield()) {
            this.getCart().clearFire();
        }
        if (!this.getShieldStatus() && this.shieldDistance > 0.0f) {
            this.shieldDistance -= 0.25f;
            if (this.shieldDistance <= 0.0f) {
                this.shield = false;
            }
        } else if (this.getShieldStatus() && this.shieldDistance < 18.0f) {
            this.shieldDistance += 0.25f;
            this.shield = true;
        }
        if (this.shield) {
            this.lastShieldAngle = this.shieldAngle;
            this.shieldAngle = (float)((double)(this.shieldAngle + 0.125f) % 314.1592653589793);
        }
    }

    @Override
    public boolean receiveDamage(DamageSource source, float val) {
        if (this.hasShield()) {
            return false;
        }
        return super.receiveDamage(source, val);
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 75;
    }

    @Override
    public int guiHeight() {
        return 35;
    }

    @Override
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    public void setShieldStatus(boolean val) {
        if (!this.isPlaceholder()) {
            this.updateDw(this.STATUS, val);
        }
    }

    private boolean getShieldStatus() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getShieldActive();
        }
        return this.getDw(this.STATUS);
    }

    @Override
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/shield.png");
        int imageID = this.getShieldStatus() ? 1 : 0;
        int borderID = 0;
        if (this.inRect(x, y, this.buttonRect)) {
            borderID = 1;
        }
        this.drawImage(guiGraphics, gui, this.buttonRect, 0, this.buttonRect[3] * borderID);
        int srcY = this.buttonRect[3] * 2 + imageID * (this.buttonRect[3] - 2);
        this.drawImage(guiGraphics, gui, this.buttonRect[0] + 1, this.buttonRect[1] + 1, 0, srcY, this.buttonRect[2] - 2, this.buttonRect[3] - 2);
    }

    @Override
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(guiGraphics, gui, this.getStateName(), x, y, this.buttonRect);
    }

    private String getStateName() {
        return Localization.MODULES.ADDONS.SHIELD.translate(this.getShieldStatus() ? "1" : "0");
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.buttonRect)) {
            this.sendPacket(0);
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            this.updateDw(this.STATUS, !this.getShieldStatus());
        }
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public int numberOfDataWatchers() {
        return 2;
    }

    @Override
    public void initDw() {
        this.STATUS = this.createDw(EntityDataSerializers.BOOLEAN);
        this.registerDw(this.STATUS, false);
    }

    @Override
    public int getConsumption(boolean isMoving) {
        return this.hasShield() ? 20 : super.getConsumption(isMoving);
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        tagCompound.putBoolean(this.generateNBTName("Shield", id), this.getShieldStatus());
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        this.setShieldStatus(tagCompound.getBoolean(this.generateNBTName("Shield", id)));
    }

    @Override
    public void doActivate(int id) {
        this.setShieldStatus(true);
    }

    @Override
    public void doDeActivate(int id) {
        this.setShieldStatus(false);
    }

    @Override
    public boolean isActive(int id) {
        return this.getShieldStatus();
    }
}

