/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotCartCrafterResult;
import vswe.stevescarts.containers.slots.SlotFurnaceInput;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.RecipeHelper;
import vswe.stevescarts.modules.addons.ModuleRecipe;

public class ModuleSmelter
extends ModuleRecipe {
    private int energyBuffer;
    private int cooldown = 0;

    public ModuleSmelter(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        if (this.getCart().level().isClientSide) {
            return;
        }
        if (this.getCart().hasFuelForModule() && this.energyBuffer < 10) {
            ++this.energyBuffer;
        }
        if (this.cooldown <= 0) {
            if (this.energyBuffer == 10) {
                ItemStack recipe = this.getStack(0);
                ItemStack result = ItemStack.EMPTY;
                if (!recipe.isEmpty() && this.getSmeltingResult() != null) {
                    result = this.getSmeltingResult();
                }
                if (!result.isEmpty()) {
                    result = result.copy();
                }
                if (!result.isEmpty() && this.getCart().getModules() != null && this.getValidSlot() != null) {
                    this.prepareLists();
                    if (this.canCraftMoreOfResult(result)) {
                        ItemStack item;
                        int i;
                        NonNullList originals = NonNullList.create();
                        for (i = 0; i < this.allTheSlots.size(); ++i) {
                            item = ((SlotStevesCarts)((Object)this.allTheSlots.get(i))).getItem();
                            originals.add((Object)(item.isEmpty() ? ItemStack.EMPTY : item.copy()));
                        }
                        for (i = 0; i < this.inputSlots.size(); ++i) {
                            item = ((SlotStevesCarts)((Object)this.inputSlots.get(i))).getItem();
                            if (item.isEmpty() || !ItemStack.isSameItem((ItemStack)item, (ItemStack)recipe) || !ItemStack.isSameItemSameTags((ItemStack)item, (ItemStack)recipe)) continue;
                            ItemStack itemStack = item;
                            itemStack.shrink(1);
                            if (itemStack.getCount() <= 0) {
                                ((SlotStevesCarts)((Object)this.inputSlots.get(i))).set(ItemStack.EMPTY);
                            }
                            this.getCart().addItemToChest(result, this.getValidSlot(), null);
                            if (result.getCount() != 0) {
                                for (int j = 0; j < this.allTheSlots.size(); ++j) {
                                    ((SlotStevesCarts)((Object)this.allTheSlots.get(j))).set((ItemStack)originals.get(j));
                                }
                                break;
                            }
                            this.energyBuffer = 0;
                            break;
                        }
                    }
                }
            }
            this.cooldown = 40;
        } else {
            --this.cooldown;
        }
    }

    @Nullable
    public SmeltingRecipe getRecipeSmelting() {
        return RecipeHelper.findSmeltRecipe(this.getStack(0), this.getCart().level()).map(RecipeHolder::value).orElse(null);
    }

    @Nullable
    public ItemStack getSmeltingResult() {
        SmeltingRecipe recipe = this.getRecipeSmelting();
        if (recipe != null) {
            return recipe.getResultItem((RegistryAccess)RegistryAccess.EMPTY).copy();
        }
        return ItemStack.EMPTY;
    }

    @Override
    public int getConsumption(boolean isMoving) {
        if (this.energyBuffer < 10) {
            return 15;
        }
        return super.getConsumption(isMoving);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    protected int getInventoryHeight() {
        return 2;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        if (y == 0) {
            return new SlotFurnaceInput(this.getCart(), this.getCart().level(), slotId, 10 + 18 * x, 15 + 18 * y);
        }
        return new SlotCartCrafterResult(this.getCart(), slotId, 10 + 18 * x, 15 + 18 * y);
    }

    @Override
    public int numberOfGuiData() {
        return super.numberOfGuiData() + 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        super.checkGuiData(info);
        this.updateGuiData(info, super.numberOfGuiData() + 0, (short)this.energyBuffer);
    }

    @Override
    public void receiveGuiData(int id, short data) {
        super.receiveGuiData(id, data);
        if (id == super.numberOfGuiData() + 0) {
            this.energyBuffer = data;
        }
    }

    @Override
    public void onInventoryChanged() {
        super.onInventoryChanged();
        if (this.getCart().level().isClientSide) {
            if (!this.getStack(0).isEmpty() && !this.getSmeltingResult().isEmpty()) {
                this.setStack(1, this.getSmeltingResult());
            } else {
                this.setStack(1, ItemStack.EMPTY);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        super.drawForeground(guiGraphics, gui);
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return this.canUseAdvancedFeatures() ? 100 : 45;
    }

    @Override
    protected int[] getArea() {
        return new int[]{32, 25, 16, 16};
    }

    @Override
    protected boolean canUseAdvancedFeatures() {
        return false;
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        super.Load(tagCompound, id);
        this.energyBuffer = tagCompound.getByte(this.generateNBTName("Buffer", id));
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        super.Save(tagCompound, id);
        tagCompound.putByte(this.generateNBTName("Buffer", id), (byte)this.energyBuffer);
    }

    @Override
    protected int getLimitStartX() {
        return 55;
    }

    @Override
    protected int getLimitStartY() {
        return 15;
    }
}

