/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.engines;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.template.ModuleEngine;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;

public abstract class ModuleSolarBase
extends ModuleEngine {
    private int light;
    private boolean maxLight;
    private int panelCoolDown;
    protected boolean down = true;
    private boolean upState;
    private boolean setup;
    private EntityDataAccessor<Integer> LIGHT;
    private EntityDataAccessor<Boolean> UP_STATE;
    private EntityDataAccessor<Integer> PRIORITY;

    public ModuleSolarBase(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    protected EntityDataAccessor<Integer> getPriorityDw() {
        return this.PRIORITY;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public void update() {
        super.update();
        this.updateSolarModel();
    }

    @Override
    protected void loadFuel() {
        this.updateLight();
        this.updateDataForModel();
        this.chargeSolar();
    }

    @Override
    public int getTotalFuel() {
        return this.getFuelLevel();
    }

    @Override
    public float[] getGuiBarColor() {
        return new float[]{1.0f, 1.0f, 0.0f};
    }

    private void updateLight() {
        if (!this.getCart().level().isDay() || this.getCart().level().isRaining()) {
            this.light = 0;
        } else if (this.getCart().level().canSeeSky(this.getCart().blockPosition())) {
            this.light = 15;
        }
    }

    private void updateDataForModel() {
        if (this.isPlaceholder()) {
            this.light = this.getSimInfo().getMaxLight() ? 15 : 14;
        } else if (this.getCart().level().isClientSide) {
            this.light = this.getDw(this.LIGHT);
        } else {
            this.updateDw(this.LIGHT, this.light);
        }
        boolean bl = this.maxLight = this.light == 15;
        if (!this.upState && this.light == 15) {
            this.light = 14;
        }
    }

    private void chargeSolar() {
        if (this.light == 15 && this.getCart().level().random.nextInt(8) < 4) {
            this.setFuelLevel(this.getFuelLevel() + this.getGenSpeed());
            if (this.getFuelLevel() > this.getMaxCapacity()) {
                this.setFuelLevel(this.getMaxCapacity());
            }
        }
    }

    public int getLight() {
        return this.light;
    }

    @Override
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, Localization.MODULES.ENGINES.SOLAR.translate(new String[0]), 8, 6, 0x404040);
        Object strfuel = Localization.MODULES.ENGINES.NO_POWER.translate(new String[0]);
        if (this.getFuelLevel() > 0) {
            strfuel = "Power: " + this.getFuelLevel();
        }
        this.drawString(guiGraphics, gui, (String)strfuel, 8, 42, 0x404040);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        super.drawBackground(guiGraphics, gui, x, y);
        ResourceHelper.bindResource("/gui/solar.png");
        int lightWidth = this.light * 3;
        if (this.light == 15) {
            lightWidth += 2;
        }
        this.drawImage(guiGraphics, gui, 9, 20, 0, 0, 54, 18);
        this.drawImage(guiGraphics, gui, 15, 21, 0, 18, lightWidth, 16);
    }

    @Override
    public int numberOfDataWatchers() {
        return super.numberOfDataWatchers() + 2;
    }

    @Override
    public void initDw() {
        this.PRIORITY = this.createDw(EntityDataSerializers.INT);
        super.initDw();
        this.LIGHT = this.createDw(EntityDataSerializers.INT);
        this.UP_STATE = this.createDw(EntityDataSerializers.BOOLEAN);
        this.registerDw(this.LIGHT, 0);
        this.registerDw(this.UP_STATE, false);
    }

    protected boolean isGoingDown() {
        return this.down;
    }

    public void updateSolarModel() {
        if (this.getCart().level().isClientSide) {
            this.updateDataForModel();
            if (this.UP_STATE != null && !this.setup) {
                boolean tmpUp = this.getDw(this.UP_STATE);
                if (tmpUp) {
                    this.setAnimDone();
                    this.upState = true;
                    this.down = false;
                }
                this.setup = true;
            }
        }
        this.panelCoolDown += this.maxLight ? 1 : -1;
        if (this.down && this.panelCoolDown < 0) {
            this.panelCoolDown = 0;
        } else if (!this.down && this.panelCoolDown > 0) {
            this.panelCoolDown = 0;
        } else if (Math.abs(this.panelCoolDown) > 20) {
            this.panelCoolDown = 0;
            this.down = !this.down;
        }
        this.upState = this.updatePanels();
        if (!this.getCart().level().isClientSide) {
            this.updateDw(this.UP_STATE, this.upState);
        }
    }

    @Override
    public int numberOfGuiData() {
        return 2;
    }

    @Override
    protected void doGuiDataCheck(AbstractContainerMenu con, List<Player> players, boolean isNew) {
        this.updateGuiData(con, players, isNew, 0, (short)(this.getFuelLevel() & 0xFFFF));
        this.updateGuiData(con, players, isNew, 1, (short)(this.getFuelLevel() >> 16 & 0xFFFF));
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            int dataint = data;
            if (dataint < 0) {
                dataint += 65536;
            }
            this.setFuelLevel(this.getFuelLevel() & 0xFFFF0000 | dataint);
        } else if (id == 1) {
            this.setFuelLevel(this.getFuelLevel() & 0xFFFF | data << 16);
        }
    }

    protected abstract int getMaxCapacity();

    protected abstract int getGenSpeed();

    protected abstract boolean updatePanels();

    protected abstract void setAnimDone();

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        super.Save(tagCompound, id);
        tagCompound.putInt(this.generateNBTName("Fuel", id), this.getFuelLevel());
        tagCompound.putBoolean(this.generateNBTName("Up", id), this.upState);
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        super.Load(tagCompound, id);
        this.setFuelLevel(tagCompound.getInt(this.generateNBTName("Fuel", id)));
        this.upState = tagCompound.getBoolean(this.generateNBTName("Up", id));
        if (this.upState) {
            this.setAnimDone();
        }
    }
}

