/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.hull;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import vswe.stevescarts.api.modules.template.ModuleHull;
import vswe.stevescarts.entities.EntityMinecartModular;

public class ModulePig
extends ModuleHull {
    private int oinkTimer = this.getRandomTimer();

    public ModulePig(EntityMinecartModular cart) {
        super(cart);
    }

    private void oink() {
    }

    private int getRandomTimer() {
        this.oinkTimer = this.getCart().random.nextInt(900) + 300;
        return this.oinkTimer;
    }

    @Override
    public void update() {
        if (this.oinkTimer <= 0) {
            this.oink();
            this.oinkTimer = this.getRandomTimer();
        } else {
            --this.oinkTimer;
        }
    }

    @Nonnull
    private ItemStack getHelmet() {
        if (this.getCart().getPassengers().isEmpty()) {
            return ItemStack.EMPTY;
        }
        Entity rider = (Entity)this.getCart().getPassengers().get(0);
        if (rider != null && rider instanceof LivingEntity) {
            return ((LivingEntity)rider).getItemBySlot(EquipmentSlot.HEAD);
        }
        return ItemStack.EMPTY;
    }

    public boolean hasHelment() {
        ItemStack item = this.getHelmet();
        return !item.isEmpty() && item.getItem() instanceof ArmorItem && ((ArmorItem)item.getItem()).getEquipmentSlot() == EquipmentSlot.HEAD;
    }

    public ResourceLocation getHelmetResource(boolean isOverlay) {
        if (!this.hasHelment()) {
            return null;
        }
        ItemStack item = this.getHelmet();
        if (item.isEmpty()) {
            return null;
        }
        return new ResourceLocation("");
    }

    public boolean hasHelmetColor(boolean isOverlay) {
        return this.getHelmetColor(isOverlay) != -1;
    }

    public int getHelmetColor(boolean isOverlay) {
        if (this.hasHelment()) {
            ItemStack item = this.getHelmet();
            return Minecraft.getInstance().getItemColors().getColor(item, isOverlay ? 1 : 0);
        }
        return -1;
    }

    @Override
    public int getConsumption(boolean isMoving) {
        if (!isMoving) {
            return super.getConsumption(isMoving);
        }
        return 1;
    }
}

