/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Giant;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.interfaces.IActivatorModule;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;

public class ModuleCage
extends ModuleBase
implements IActivatorModule {
    private int[] autoRect = new int[]{15, 20, 24, 12};
    private int[] manualRect = new int[]{this.autoRect[0] + this.autoRect[2] + 5, this.autoRect[1], this.autoRect[2], this.autoRect[3]};
    private EntityNearestTarget sorter = new EntityNearestTarget((Entity)this.getCart());
    private int cooldown = 0;
    private boolean disablePickup;

    public ModuleCage(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 80;
    }

    @Override
    public int guiHeight() {
        return 35;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/cage.png");
        this.drawButton(guiGraphics, gui, x, y, this.autoRect, this.disablePickup ? 2 : 3);
        this.drawButton(guiGraphics, gui, x, y, this.manualRect, this.isCageEmpty() ? 0 : 1);
    }

    private void drawButton(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y, int[] coords, int imageID) {
        if (this.inRect(x, y, coords)) {
            this.drawImage(guiGraphics, gui, coords, 0, coords[3]);
        } else {
            this.drawImage(guiGraphics, gui, coords, 0, 0);
        }
        int srcY = coords[3] * 2 + imageID * (coords[3] - 2);
        this.drawImage(guiGraphics, gui, coords[0] + 1, coords[1] + 1, 0, srcY, coords[2] - 2, coords[3] - 2);
    }

    @Override
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(guiGraphics, gui, Localization.MODULES.ATTACHMENTS.CAGE_AUTO.translate(this.disablePickup ? "0" : "1"), x, y, this.autoRect);
        this.drawStringOnMouseOver(guiGraphics, gui, Localization.MODULES.ATTACHMENTS.CAGE.translate(this.isCageEmpty() ? "0" : "1"), x, y, this.manualRect);
    }

    private boolean isCageEmpty() {
        return this.getCart().getCartRider() == null;
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0) {
            if (this.inRect(x, y, this.autoRect)) {
                this.sendPacket(0);
            } else if (this.inRect(x, y, this.manualRect)) {
                this.sendPacket(1);
            }
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            this.disablePickup = !this.disablePickup;
        } else if (id == 1) {
            if (!this.isCageEmpty()) {
                this.manualDrop();
            } else {
                this.manualPickUp();
            }
        }
    }

    @Override
    public int numberOfPackets() {
        return 2;
    }

    @Override
    public void update() {
        super.update();
        if (this.cooldown > 0) {
            --this.cooldown;
        } else if (!this.disablePickup) {
            this.pickUpCreature(2);
            this.cooldown = 20;
        }
    }

    private void manualDrop() {
        if (!this.isCageEmpty()) {
            this.getCart().ejectPassengers();
            this.cooldown = 20;
        }
    }

    private void manualPickUp() {
        this.pickUpCreature(5);
    }

    private void pickUpCreature(int searchDistance) {
        if (this.getCart().level().isClientSide || !this.isCageEmpty()) {
            return;
        }
        List entities = this.getCart().level().getEntitiesOfClass(LivingEntity.class, this.getCart().getBoundingBox().inflate((double)searchDistance, 4.0, (double)searchDistance));
        entities.sort(this.sorter);
        for (LivingEntity target : entities) {
            if (target instanceof Player || target instanceof IronGolem || target instanceof EnderDragon || target instanceof Slime || target instanceof WaterAnimal || target instanceof WitherBoss || target instanceof EnderMan || target instanceof Spider && !(target instanceof CaveSpider) || target instanceof Giant || target instanceof FlyingAnimal || !target.getPassengers().isEmpty()) continue;
            target.startRiding((Entity)this.getCart());
            return;
        }
    }

    @Override
    public float mountedOffset(Entity rider) {
        if (rider instanceof Bat) {
            return 0.5f;
        }
        if (rider instanceof Zombie || rider instanceof Skeleton) {
            return -0.75f;
        }
        return super.mountedOffset(rider);
    }

    @Override
    public int numberOfGuiData() {
        return 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (byte)(this.disablePickup ? 1 : 0));
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.disablePickup = data != 0;
        }
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        tagCompound.putBoolean(this.generateNBTName("disablePickup", id), this.disablePickup);
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        this.disablePickup = tagCompound.getBoolean(this.generateNBTName("disablePickup", id));
    }

    @Override
    public boolean isActive(int id) {
        if (id == 0) {
            return !this.disablePickup;
        }
        return !this.isCageEmpty();
    }

    @Override
    public void doActivate(int id) {
        if (id == 0) {
            this.disablePickup = false;
        } else {
            this.manualPickUp();
        }
    }

    @Override
    public void doDeActivate(int id) {
        if (id == 0) {
            this.disablePickup = true;
        } else {
            this.manualDrop();
        }
    }

    private static class EntityNearestTarget
    implements Comparator<LivingEntity> {
        private Entity entity;

        public EntityNearestTarget(Entity entity) {
            this.entity = entity;
        }

        public int compareDistanceSq(Entity entity1, Entity entity2) {
            double distance1 = this.entity.distanceTo(entity1);
            double distance2 = this.entity.distanceTo(entity2);
            return Double.compare(distance1, distance2);
        }

        @Override
        public int compare(LivingEntity o1, LivingEntity o2) {
            return this.compareDistanceSq((Entity)o1, (Entity)o2);
        }
    }
}

