/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotFirework;
import vswe.stevescarts.entities.EntityMinecartModular;

public class ModuleFirework
extends ModuleBase {
    private int fireCooldown;

    public ModuleFirework(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        if (this.fireCooldown > 0) {
            --this.fireCooldown;
        }
    }

    @Override
    public void activatedByRail(int x, int y, int z, boolean active) {
        if (active && this.fireCooldown == 0 && this.getCart().hasFuel()) {
            this.fire();
            this.fireCooldown = 20;
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotFirework(this.getCart(), slotId, 8 + x * 18, 16 + y * 18);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return 15 + this.getInventoryWidth() * 18;
    }

    @Override
    public int guiHeight() {
        return 20 + this.getInventoryHeight() * 18;
    }

    @Override
    protected int getInventoryWidth() {
        return 8;
    }

    @Override
    protected int getInventoryHeight() {
        return 3;
    }

    public void fire() {
        if (this.getCart().level().isClientSide) {
            return;
        }
        ItemStack firework = this.getFirework();
        if (!firework.isEmpty()) {
            this.launchFirework(firework);
        }
    }

    @Nonnull
    private ItemStack getFirework() {
        boolean hasGunpowder = false;
        boolean hasPaper = false;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item.isEmpty()) continue;
            if (item.getItem() == Items.FIREWORK_ROCKET) {
                ItemStack firework = item.copy();
                firework.setCount(1);
                this.removeItemStack(item, firework.getCount(), i);
                return firework;
            }
            if (item.getItem() == Items.PAPER) {
                hasPaper = true;
                continue;
            }
            if (item.getItem() != Items.GUNPOWDER) continue;
            hasGunpowder = true;
        }
        if (hasPaper && hasGunpowder) {
            ItemStack charge;
            int chargeCount;
            ItemStack firework2 = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
            int maxGunpowder = this.getCart().random.nextInt(3) + 1;
            int countGunpowder = 0;
            boolean removedPaper = false;
            for (int j = 0; j < this.getInventorySize(); ++j) {
                ItemStack item2 = this.getStack(j);
                if (item2.isEmpty()) continue;
                if (item2.getItem() == Items.PAPER && !removedPaper) {
                    this.removeItemStack(item2, 1, j);
                    removedPaper = true;
                    continue;
                }
                if (item2.getItem() != Items.GUNPOWDER || countGunpowder >= maxGunpowder) continue;
                while (item2.getCount() > 0 && countGunpowder < maxGunpowder) {
                    ++countGunpowder;
                    this.removeItemStack(item2, 1, j);
                }
            }
            for (chargeCount = 1; chargeCount < 7 && this.getCart().random.nextInt(3 + chargeCount / 3) == 0; ++chargeCount) {
            }
            CompoundTag itemstackNBT = new CompoundTag();
            CompoundTag fireworksNBT = new CompoundTag();
            ListTag explosionsNBT = new ListTag();
            for (int k = 0; k < chargeCount && !(charge = this.getCharge()).isEmpty(); ++k) {
                if (!charge.hasTag() || !charge.getTag().contains("Explosion")) continue;
                explosionsNBT.add((Object)charge.getTag().get("Explosion"));
            }
            fireworksNBT.put("Explosions", (Tag)explosionsNBT);
            fireworksNBT.putByte("Flight", (byte)countGunpowder);
            itemstackNBT.put("Fireworks", (Tag)fireworksNBT);
            firework2.setTag(itemstackNBT);
            return firework2;
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    private ItemStack getCharge() {
        int[] fade;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item.isEmpty() || item.getItem() != Items.FIREWORK_STAR) continue;
            ItemStack charge = item.copy();
            charge.setCount(1);
            this.removeItemStack(item, charge.getCount(), i);
            return charge;
        }
        ItemStack charge2 = new ItemStack((ItemLike)Items.FIREWORK_STAR);
        CompoundTag itemNBT = new CompoundTag();
        CompoundTag explosionNBT = new CompoundTag();
        byte type = 0;
        boolean removedGunpowder = false;
        boolean canHasTrail = this.getCart().random.nextInt(16) == 0;
        boolean canHasFlicker = this.getCart().random.nextInt(8) == 0;
        boolean canHasModifier = this.getCart().random.nextInt(4) == 0;
        byte modifierType = (byte)(this.getCart().random.nextInt(4) + 1);
        boolean removedModifier = false;
        boolean removedDiamond = false;
        boolean removedGlow = false;
        for (int j = 0; j < this.getInventorySize(); ++j) {
            ItemStack item2 = this.getStack(j);
            if (item2 == null) continue;
            if (item2.getItem() == Items.GUNPOWDER && !removedGunpowder) {
                this.removeItemStack(item2, 1, j);
                removedGunpowder = true;
                continue;
            }
            if (item2.getItem() == Items.GLOWSTONE_DUST && canHasFlicker && !removedGlow) {
                this.removeItemStack(item2, 1, j);
                removedGlow = true;
                explosionNBT.putBoolean("Flicker", true);
                continue;
            }
            if (item2.getItem() == Items.DIAMOND && canHasTrail && !removedDiamond) {
                this.removeItemStack(item2, 1, j);
                removedDiamond = true;
                explosionNBT.putBoolean("Trail", true);
                continue;
            }
            if (!canHasModifier || removedModifier || !(item2.getItem() == Items.FIREWORK_STAR && modifierType == 1 || item2.getItem() == Items.GOLD_NUGGET && modifierType == 2 || item2.getItem() == Items.SKELETON_SKULL && modifierType == 3) && (item2.getItem() != Items.FEATHER || modifierType != 4)) continue;
            this.removeItemStack(item2, 1, j);
            removedModifier = true;
            type = modifierType;
        }
        int[] colors = this.generateColors(type != 0 ? 7 : 8);
        if (colors == null) {
            return null;
        }
        explosionNBT.putIntArray("Colors", colors);
        if (this.getCart().random.nextInt(4) == 0 && (fade = this.generateColors(8)) != null) {
            explosionNBT.putIntArray("FadeColors", fade);
        }
        explosionNBT.putByte("Type", type);
        itemNBT.put("Explosion", (Tag)explosionNBT);
        charge2.setTag(itemNBT);
        return charge2;
    }

    private int[] generateColors(int maxColorCount) {
        int colorCount;
        int[] maxColors = new int[16];
        int[] currentColors = new int[16];
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (!item.isEmpty() && item.getItem() != Items.BLACK_DYE) continue;
        }
        for (colorCount = this.getCart().random.nextInt(2) + 1; colorCount <= maxColorCount - 2 && this.getCart().random.nextInt(2) == 0; colorCount += 2) {
        }
        ArrayList<Integer> colorPointers = new ArrayList<Integer>();
        for (int j = 0; j < 16; ++j) {
            if (maxColors[j] <= 0) continue;
            colorPointers.add(j);
        }
        if (colorPointers.size() == 0) {
            return null;
        }
        ArrayList<Integer> usedColors = new ArrayList<Integer>();
        while (colorCount > 0 && colorPointers.size() > 0) {
            int n2;
            int n;
            int pointerId = this.getCart().random.nextInt(colorPointers.size());
            int colorId = (Integer)colorPointers.get(pointerId);
            int[] array2 = currentColors;
            int n3 = n = colorId;
            array2[n3] = array2[n3] + 1;
            int[] array3 = maxColors;
            int n4 = n2 = colorId;
            array3[n4] = array3[n4] - 1;
            if (array3[n4] <= 0) {
                colorPointers.remove(pointerId);
            }
            usedColors.add(colorId);
            --colorCount;
        }
        int[] colors = new int[usedColors.size()];
        for (int k = 0; k < colors.length; ++k) {
        }
        return colors;
    }

    private void removeItemStack(@Nonnull ItemStack item, int count, int id) {
        if (!this.getCart().hasCreativeSupplies()) {
            item.shrink(count);
            if (item.getCount() <= 0) {
                this.setStack(id, ItemStack.EMPTY);
            }
        }
    }

    private void launchFirework(@Nonnull ItemStack firework) {
        FireworkRocketEntity rocket = new FireworkRocketEntity(this.getCart().level(), (double)this.getCart().blockPosition().getX(), (double)this.getCart().blockPosition().getY() + 1.0, (double)this.getCart().blockPosition().getZ(), firework);
        this.getCart().level().addFreshEntity((Entity)rocket);
    }
}

