/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.interfaces.ISuppliesModule;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotArrow;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ModularEnchantments;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.addons.ModuleEnchants;
import vswe.stevescarts.modules.addons.projectiles.ModuleProjectile;

public class ModuleShooter
extends ModuleBase
implements ISuppliesModule {
    private ArrayList<ModuleProjectile> projectiles;
    private ModuleEnchants enchanter;
    private int pipeSelectionX;
    private int pipeSelectionY;
    private int intervalSelectionX;
    private int intervalSelectionY;
    private int[] intervalSelection;
    private int[] intervalDragArea;
    private int dragState = -1;
    private final ArrayList<Integer> pipes;
    private final float[] pipeRotations;
    private final int[] AInterval = new int[]{1, 3, 5, 7, 10, 13, 17, 21, 27, 35, 44, 55, 70, 95, 130, 175, 220, 275, 340, 420, 520, 650};
    private int arrowTick;
    private EntityDataAccessor<Byte> ACTIVE_PIPE;
    private EntityDataAccessor<Integer> ARROW_INTERVAL;
    private EntityDataAccessor<Integer> ARROW_COOLDOWN_STATE;

    public ModuleShooter(EntityMinecartModular cart) {
        super(cart);
        this.pipes = new ArrayList<Integer>();
        this.generatePipes(this.pipes);
        this.pipeRotations = new float[this.pipes.size()];
        this.generateInterfaceRegions();
    }

    @Override
    public void init() {
        super.init();
        this.projectiles = new ArrayList();
        for (ModuleBase module : this.getCart().getModules()) {
            if (module instanceof ModuleProjectile) {
                this.projectiles.add((ModuleProjectile)module);
                continue;
            }
            if (!(module instanceof ModuleEnchants)) continue;
            this.enchanter = (ModuleEnchants)module;
            this.enchanter.addType(ModularEnchantments.EnchantmentType.SHOOTER);
        }
    }

    @Override
    protected int getInventoryHeight() {
        return 2;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotArrow(this.getCart(), this, slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, Localization.MODULES.ATTACHMENTS.SHOOTER.translate(new String[0]), 8, 6, 0x404040);
        int delay = this.AInterval[this.getInterval()];
        double freq = 20.0 / (double)(delay + 1);
        Object s = String.valueOf((double)((int)(freq * 1000.0)) / 1000.0);
        this.drawString(guiGraphics, gui, Localization.MODULES.ATTACHMENTS.FREQUENCY.translate(new String[0]) + ":", this.intervalDragArea[0] + this.intervalDragArea[2] + 5, 15, 0x404040);
        this.drawString(guiGraphics, gui, (String)s, this.intervalDragArea[0] + this.intervalDragArea[2] + 5, 23, 0x404040);
        s = (double)delay / 20.0 + Localization.MODULES.ATTACHMENTS.SECONDS.translate(new String[0]);
        this.drawString(guiGraphics, gui, Localization.MODULES.ATTACHMENTS.DELAY.translate(new String[0]) + ":", this.intervalDragArea[0] + this.intervalDragArea[2] + 5, 35, 0x404040);
        this.drawString(guiGraphics, gui, (String)s, this.intervalDragArea[0] + this.intervalDragArea[2] + 5, 43, 0x404040);
    }

    @Override
    public int guiWidth() {
        return super.guiWidth() + this.guiExtraWidth();
    }

    protected int guiExtraWidth() {
        return 112;
    }

    @Override
    public int guiHeight() {
        return Math.max(super.guiHeight(), this.guiRequiredHeight());
    }

    protected int guiRequiredHeight() {
        return 67;
    }

    protected void generateInterfaceRegions() {
        this.pipeSelectionX = this.guiWidth() - 110;
        this.pipeSelectionY = (this.guiHeight() - 12 - 26) / 2 + 12;
        this.intervalSelectionX = this.pipeSelectionX + 26 + 8;
        this.intervalSelectionY = 10;
        this.intervalSelection = new int[]{this.intervalSelectionX, this.intervalSelectionY, 14, 53};
        this.intervalDragArea = new int[]{this.intervalSelectionX - 4, this.intervalSelectionY, 40, 53};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/shooter.png");
        this.drawImage(guiGraphics, gui, this.pipeSelectionX + 9, this.pipeSelectionY + 9 - 1, 0, 104, 8, 9);
        for (int i = 0; i < this.pipes.size(); ++i) {
            int pipe = this.pipes.get(i);
            int pipeX = pipe % 3;
            int pipeY = pipe / 3;
            boolean active = this.isPipeActive(i);
            boolean selected = this.inRect(x, y, this.getRectForPipe(pipe)) || this.getCooldownState() == 0 && active;
            int srcX = pipeX * 9;
            if (!active) {
                srcX += 26;
            }
            int srcY = pipeY * 9;
            if (selected) {
                srcY += 26;
            }
            this.drawImage(guiGraphics, gui, this.getRectForPipe(pipe), srcX, srcY);
        }
        this.drawImage(guiGraphics, gui, this.intervalSelection, 42, 52);
        int size = (int)((float)(this.getInterval() / this.AInterval.length) * 4.0f);
        int targetX = this.intervalSelectionX + 7;
        int targetY = this.intervalSelectionY + this.getInterval() * 2;
        int srcX2 = 0;
        int srcY2 = 52 + size * 13;
        this.drawImage(guiGraphics, gui, targetX, targetY, srcX2, srcY2, 25, 13);
        this.drawImage(guiGraphics, gui, targetX += 7, targetY + 1, srcX2 += 25, srcY2 + 1, 1, 11);
        this.drawImage(guiGraphics, gui, targetX + 1, targetY + 2, srcX2 + 1, srcY2 + 2, 1, 9);
        this.drawImage(guiGraphics, gui, targetX + 1, targetY + 1, srcX2 + 1, srcY2 + 1, Math.min(this.getCooldownState(), 15), 2);
        this.drawImage(guiGraphics, gui, targetX + 15, targetY + 1, srcX2 + 15, srcY2 + 1, 2, Math.max(Math.min(this.getCooldownState(), 25) - 15, 0));
        int len = Math.max(Math.min(this.getCooldownState(), 41) - 25, 0);
        this.drawImage(guiGraphics, gui, targetX + 1 + (16 - len), targetY + 10, srcX2 + 1 + (16 - len), srcY2 + 10, len, 2);
    }

    private int getCurrentCooldownState() {
        double perc = this.arrowTick / this.AInterval[this.getInterval()];
        this.setCooldownState((int)(41.0 * perc));
        return this.getCooldownState();
    }

    private int[] getRectForPipe(int pipe) {
        return new int[]{this.pipeSelectionX + pipe % 3 * 9, this.pipeSelectionY + pipe / 3 * 9, 8, 8};
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0) {
            if (this.inRect(x, y, this.intervalDragArea)) {
                this.dragState = y - (this.intervalSelectionY + this.getInterval() * 2);
                StevesCarts.LOGGER.info("dragState: {}", (Object)this.dragState);
            } else {
                for (int i = 0; i < this.pipes.size(); ++i) {
                    if (!this.inRect(x, y, this.getRectForPipe(this.pipes.get(i)))) continue;
                    this.sendPacket(0, (byte)i);
                    break;
                }
            }
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
        if (button != -1) {
            this.dragState = -1;
            StevesCarts.LOGGER.info("A dragState: {}, Button: {}", (Object)this.dragState, (Object)button);
        } else if (this.dragState != -1) {
            StevesCarts.LOGGER.info("B dragState: {}, Button: {}", (Object)this.dragState, (Object)button);
            int interval = (y + this.getCart().getRealScrollY() - this.intervalSelectionY - this.dragState) / 2;
            if (interval != this.getInterval() && interval >= 0 && interval < this.AInterval.length) {
                this.sendPacket(1, (byte)interval);
            }
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            byte info = this.getActivePipes();
            info = (byte)(info ^ (byte)(1 << data[0]));
            this.setActivePipes(info);
        } else if (id == 1) {
            byte info = data[0];
            if (info < 0) {
                info = 0;
            } else if (info >= this.AInterval.length) {
                info = (byte)(this.AInterval.length - 1);
            }
            this.setInterval(info);
            this.arrowTick = this.AInterval[info];
        }
    }

    @Override
    public int numberOfPackets() {
        return 2;
    }

    @Override
    public void update() {
        if (!this.getCart().level().isClientSide) {
            if (this.arrowTick > 0) {
                --this.arrowTick;
            } else {
                this.shoot();
            }
        } else {
            this.rotatePipes(false);
        }
    }

    protected void generatePipes(ArrayList<Integer> list) {
        for (int i = 0; i < 9; ++i) {
            if (i == 4) continue;
            list.add(i);
        }
    }

    protected boolean hasProjectileItem() {
        return !this.getProjectileItem(false).isEmpty();
    }

    @Nonnull
    protected ItemStack getProjectileItem(boolean consume) {
        if (consume && this.enchanter != null && this.enchanter.useInfinity()) {
            consume = false;
        }
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (!this.isValidProjectileItem(this.getStack(i))) continue;
            ItemStack projectile = this.getStack(i).copy();
            projectile.setCount(1);
            if (consume && !this.getCart().hasCreativeSupplies()) {
                this.getStack(i).shrink(1);
            }
            return projectile;
        }
        return ItemStack.EMPTY;
    }

    protected void shoot() {
        this.setTimeToNext(this.AInterval[this.getInterval()]);
        if (this.getCart().pushX != 0.0 && this.getCart().pushZ != 0.0 || this.getCart().pushX == 0.0 && this.getCart().pushZ == 0.0 || !this.getCart().hasFuel()) {
            return;
        }
        boolean hasShot = false;
        for (int i = 0; i < this.pipes.size(); ++i) {
            if (!this.isPipeActive(i)) continue;
            int pipe = this.pipes.get(i);
            if (!this.hasProjectileItem()) break;
            int x = pipe % 3 - 1;
            int y = pipe / 3 - 1;
            if (this.getCart().pushZ > 0.0) {
                y *= -1;
                x *= -1;
            } else if (!(this.getCart().pushZ < 0.0)) {
                if (this.getCart().pushX < 0.0) {
                    int temp = -x;
                    x = y;
                    y = temp;
                } else if (this.getCart().pushX > 0.0) {
                    int temp = x;
                    x = -y;
                    y = temp;
                }
            }
            Entity projectile = this.getProjectile(null, this.getProjectileItem(true));
            projectile.moveTo(this.getCart().getX() + (double)x * 1.5, this.getCart().getY() + 0.75, this.getCart().getZ() + (double)y * 1.5);
            this.setHeading(projectile, x, 0.1f, y, 1.6f, 12.0f);
            this.setProjectileDamage(projectile);
            this.setProjectileOnFire(projectile);
            this.setProjectileKnockback(projectile);
            this.getCart().level().addFreshEntity(projectile);
            hasShot = true;
            this.damageEnchant();
        }
        if (hasShot) {
            this.getCart().level().levelEvent(1002, this.getCart().blockPosition(), 0);
        }
    }

    protected void damageEnchant() {
        if (this.enchanter != null) {
            this.enchanter.damageEnchant(ModularEnchantments.EnchantmentType.SHOOTER, 1);
        }
    }

    protected void setProjectileOnFire(Entity projectile) {
        if (this.enchanter != null && this.enchanter.useFlame()) {
            projectile.setSecondsOnFire(100);
        }
    }

    protected void setProjectileDamage(Entity projectile) {
        int power;
        if (this.enchanter != null && projectile instanceof Arrow && (power = this.enchanter.getPowerLevel()) > 0) {
            Arrow arrow = (Arrow)projectile;
            arrow.setBaseDamage(arrow.getBaseDamage() + (double)power * 0.5 + 0.5);
        }
    }

    protected void setProjectileKnockback(Entity projectile) {
        int punch;
        if (this.enchanter != null && projectile instanceof Arrow && (punch = this.enchanter.getPunchLevel()) > 0) {
            Arrow arrow = (Arrow)projectile;
            arrow.setKnockback(punch);
        }
    }

    protected void setHeading(Entity projectile, double motionX, double motionY, double motionZ, float motionMult, float motionNoise) {
        if (projectile instanceof Projectile) {
            ((Projectile)projectile).shoot(motionX, motionY, motionZ, motionMult, motionNoise);
        }
    }

    protected Entity getProjectile(Entity target, @Nonnull ItemStack stack) {
        for (ModuleProjectile module : this.projectiles) {
            if (!module.isValidProjectile(stack)) continue;
            return module.createProjectile(target, stack);
        }
        Arrow arrow = new Arrow(this.getCart().level(), 0.0, 0.0, 0.0, stack);
        arrow.setEffectsFromItem(stack);
        arrow.setOwner((Entity)this.getCart());
        return arrow;
    }

    public boolean isValidProjectileItem(@Nonnull ItemStack item) {
        if (item.isEmpty()) {
            return false;
        }
        for (ModuleProjectile module : this.projectiles) {
            if (!module.isValidProjectile(item)) continue;
            return true;
        }
        return item.getItem() instanceof ArrowItem;
    }

    protected void setTimeToNext(int val) {
        this.arrowTick = val;
    }

    private void rotatePipes(boolean isNew) {
        float minRotation = 0.0f;
        float maxRotation = 0.7853982f;
        float speed = 0.15f;
        for (int i = 0; i < this.pipes.size(); ++i) {
            boolean isActive = this.isPipeActive(i);
            if (isNew && isActive) {
                this.pipeRotations[i] = 0.0f;
                continue;
            }
            if (isNew && !isActive) {
                this.pipeRotations[i] = 0.7853982f;
                continue;
            }
            if (isActive && this.pipeRotations[i] > 0.0f) {
                int n = i;
                this.pipeRotations[n] = this.pipeRotations[n] - 0.15f;
                if (!(this.pipeRotations[i] < 0.0f)) continue;
                this.pipeRotations[i] = 0.0f;
                continue;
            }
            if (isActive || !(this.pipeRotations[i] < 0.7853982f)) continue;
            int n = i;
            this.pipeRotations[n] = this.pipeRotations[n] + 0.15f;
            if (!(this.pipeRotations[i] > 0.7853982f)) continue;
            this.pipeRotations[i] = 0.7853982f;
        }
    }

    @Override
    public int numberOfDataWatchers() {
        return 3;
    }

    @Override
    public void initDw() {
        this.ACTIVE_PIPE = this.createDw(EntityDataSerializers.BYTE);
        this.ARROW_INTERVAL = this.createDw(EntityDataSerializers.INT);
        this.ARROW_COOLDOWN_STATE = this.createDw(EntityDataSerializers.INT);
        this.registerDw(this.ACTIVE_PIPE, (byte)0);
        this.registerDw(this.ARROW_INTERVAL, 5);
        this.registerDw(this.ARROW_COOLDOWN_STATE, 0);
    }

    public int getInterval() {
        return this.isPlaceholder() ? 5 : this.getDw(this.ARROW_INTERVAL);
    }

    public void setInterval(int interval) {
        this.updateDw(this.ARROW_INTERVAL, interval);
    }

    public int getCooldownState() {
        return this.isPlaceholder() ? 0 : this.getDw(this.ARROW_COOLDOWN_STATE);
    }

    public void setCooldownState(int cooldown) {
        this.updateDw(this.ARROW_COOLDOWN_STATE, cooldown);
    }

    public void setActivePipes(byte val) {
        this.updateDw(this.ACTIVE_PIPE, val);
    }

    public byte getActivePipes() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getActivePipes();
        }
        return this.getDw(this.ACTIVE_PIPE);
    }

    protected boolean isPipeActive(int id) {
        return (this.getActivePipes() & 1 << id) != 0;
    }

    public int getPipeCount() {
        return this.pipes.size();
    }

    public float getPipeRotation(int id) {
        return this.pipeRotations[id];
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        tagCompound.putByte(this.generateNBTName("Pipes", id), this.getActivePipes());
        tagCompound.putByte(this.generateNBTName("Interval", id), (byte)this.getInterval());
        this.saveTick(tagCompound, id);
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        this.setActivePipes(tagCompound.getByte(this.generateNBTName("Pipes", id)));
        this.setInterval(tagCompound.getByte(this.generateNBTName("Interval", id)));
        this.loadTick(tagCompound, id);
    }

    protected void saveTick(CompoundTag tagCompound, int id) {
        tagCompound.putByte(this.generateNBTName("Tick", id), (byte)this.arrowTick);
    }

    protected void loadTick(CompoundTag tagCompound, int id) {
        this.arrowTick = tagCompound.getByte(this.generateNBTName("Tick", id));
    }

    @Override
    public boolean haveSupplies() {
        return this.hasProjectileItem();
    }
}

