/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.addons.mobdetectors.ModuleMobdetector;
import vswe.stevescarts.modules.realtimers.ModuleShooter;

public class ModuleShooterAdv
extends ModuleShooter {
    private ArrayList<ModuleMobdetector> detectors;
    private EntityNearestTarget sorter = new EntityNearestTarget((Entity)this.getCart());
    private float detectorAngle;
    private EntityDataAccessor<Byte> OPTION;
    private EntityDataAccessor<Byte> RIFLE_DIRECTION;

    public ModuleShooterAdv(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void preInit() {
        super.preInit();
        this.detectors = new ArrayList();
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleMobdetector)) continue;
            this.detectors.add((ModuleMobdetector)module);
        }
    }

    @Override
    protected void generatePipes(ArrayList<Integer> list) {
        list.add(1);
    }

    @Override
    protected int guiExtraWidth() {
        return 100;
    }

    @Override
    protected int guiRequiredHeight() {
        return 10 + 10 * this.detectors.size();
    }

    private int[] getSelectionBox(int id) {
        return new int[]{90, id * 10 + (this.guiHeight() - 10 * this.detectors.size()) / 2, 8, 8};
    }

    @Override
    protected void generateInterfaceRegions() {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, Localization.MODULES.ATTACHMENTS.SHOOTER.translate(new String[0]), 8, 6, 0x404040);
        for (int i = 0; i < this.detectors.size(); ++i) {
            int[] box = this.getSelectionBox(i);
            this.drawString(guiGraphics, gui, this.detectors.get(i).getName(), box[0] + 12, box[1], 0x404040);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/mobdetector.png");
        for (int i = 0; i < this.detectors.size(); ++i) {
            int srcX = this.isOptionActive(i) ? 0 : 8;
            int srcY = this.inRect(x, y, this.getSelectionBox(i)) ? 8 : 0;
            this.drawImage(guiGraphics, gui, this.getSelectionBox(i), srcX, srcY);
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0) {
            for (int i = 0; i < this.detectors.size(); ++i) {
                if (!this.inRect(x, y, this.getSelectionBox(i))) continue;
                this.sendPacket(0, (byte)i);
                break;
            }
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
    }

    @Override
    public int numberOfGuiData() {
        return 0;
    }

    @Override
    protected void checkGuiData(Object[] info) {
    }

    @Override
    protected void shoot() {
        this.setTimeToNext(15);
        if (!this.getCart().hasFuel()) {
            return;
        }
        Entity target = this.getTarget();
        if (target != null) {
            if (this.hasProjectileItem()) {
                this.shootAtTarget(target);
            } else {
                this.getCart().level().levelEvent(1001, this.getCart().blockPosition(), 0);
            }
        }
    }

    private void shootAtTarget(Entity target) {
        Entity projectile = this.getProjectile(target, this.getProjectileItem(true));
        double posY = this.getCart().getY() + (double)this.getCart().getEyeHeight() - (double)0.1f;
        double disX = target.getX() - this.getCart().getX();
        double disY = target.getY() + (double)target.getEyeHeight() - (double)0.7f - posY;
        double disZ = target.getZ() - this.getCart().getZ();
        double dis = Math.sqrt(disX * disX + disZ * disZ);
        if (dis >= 1.0E-7) {
            float theta = (float)(Math.atan2(disZ, disX) * 180.0 / Math.PI) - 90.0f;
            float phi = (float)(-(Math.atan2(disY, dis) * 180.0 / Math.PI));
            this.setRifleDirection((float)Math.atan2(disZ, disX));
            projectile.moveTo(this.getCart().getX(), posY, this.getCart().getZ(), theta, phi);
            float disD5 = (float)dis * 0.2f;
            this.setHeading(projectile, disX, disY + (double)disD5, disZ, 1.6f, 0.0f);
        }
        BlockPos pos = this.getCart().blockPosition();
        this.getCart().level().playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ARROW_HIT, SoundSource.NEUTRAL, 1.0f, 1.0f / (this.getCart().random.nextFloat() * 0.4f + 0.8f));
        this.setProjectileDamage(projectile);
        this.setProjectileOnFire(projectile);
        this.setProjectileKnockback(projectile);
        this.getCart().level().addFreshEntity(projectile);
        this.damageEnchant();
    }

    protected int getTargetDistance() {
        return 16;
    }

    private Entity getTarget() {
        List entities = this.getCart().level().getEntitiesOfClass(LivingEntity.class, this.getCart().getBoundingBox().inflate((double)this.getTargetDistance(), 4.0, (double)this.getTargetDistance()));
        entities.sort(this.sorter);
        for (LivingEntity target : entities) {
            if (target.isDeadOrDying() || !this.hasLineOfSight((Entity)target)) continue;
            for (int i = 0; i < this.detectors.size(); ++i) {
                ModuleMobdetector detector;
                if (!this.isOptionActive(i) || !(detector = this.detectors.get(i)).isValidTarget((Entity)target)) continue;
                return target;
            }
        }
        return null;
    }

    public boolean hasLineOfSight(Entity target) {
        EntityMinecartModular cart = this.getCart();
        Vec3 vec3 = new Vec3(cart.getX(), cart.getEyeY(), cart.getZ());
        Vec3 vec31 = new Vec3(target.getX(), target.getEyeY(), target.getZ());
        return cart.level().clip(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)cart)).getType() == HitResult.Type.MISS;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            this.switchOption(data[0]);
        }
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public int numberOfDataWatchers() {
        return 2;
    }

    @Override
    public void initDw() {
        this.OPTION = this.createDw(EntityDataSerializers.BYTE);
        this.RIFLE_DIRECTION = this.createDw(EntityDataSerializers.BYTE);
        this.registerDw(this.OPTION, (byte)0);
        this.registerDw(this.RIFLE_DIRECTION, (byte)0);
    }

    private void switchOption(int id) {
        byte val = this.getDw(this.OPTION);
        val = (byte)(val ^ (byte)(1 << id));
        this.updateDw(this.OPTION, val);
    }

    public void setOptions(byte val) {
        this.updateDw(this.OPTION, val);
    }

    public byte selectedOptions() {
        return this.getDw(this.OPTION);
    }

    private boolean isOptionActive(int id) {
        return (this.selectedOptions() & 1 << id) != 0;
    }

    @Override
    protected boolean isPipeActive(int id) {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getIsPipeActive();
        }
        return this.selectedOptions() != 0;
    }

    public float getDetectorAngle() {
        return this.detectorAngle;
    }

    @Override
    public void update() {
        super.update();
        if (this.isPipeActive(0)) {
            this.detectorAngle = (float)((double)(this.detectorAngle + 0.1f) % (Math.PI * 2));
        }
    }

    private void setRifleDirection(float val) {
        val /= (float)Math.PI * 2;
        val *= 256.0f;
        if ((val %= 256.0f) < 0.0f) {
            val += 256.0f;
        }
        this.updateDw(this.RIFLE_DIRECTION, (byte)val);
    }

    public float getRifleDirection() {
        float val = this.isPlaceholder() ? 0.0f : (float)this.getDw(this.RIFLE_DIRECTION).byteValue();
        val /= 256.0f;
        return val *= (float)Math.PI * 2;
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        tagCompound.putByte(this.generateNBTName("Options", id), this.selectedOptions());
        this.saveTick(tagCompound, id);
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        this.setOptions(tagCompound.getByte(this.generateNBTName("Options", id)));
        this.loadTick(tagCompound, id);
    }

    private static class EntityNearestTarget
    implements Comparator<Entity> {
        private Entity entity;

        public EntityNearestTarget(Entity entity) {
            this.entity = entity;
        }

        public int compareDistanceSq(Entity entity1, Entity entity2) {
            double distance2;
            double distance1 = this.entity.distanceTo(entity1);
            return distance1 < (distance2 = (double)this.entity.distanceTo(entity2)) ? -1 : (distance1 > distance2 ? 1 : 0);
        }

        @Override
        public int compare(Entity o1, Entity o2) {
            return this.compareDistanceSq(o1, o2);
        }
    }
}

