/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockState;
import vswe.stevescarts.api.modules.interfaces.IActivatorModule;
import vswe.stevescarts.api.modules.template.ModuleWorker;
import vswe.stevescarts.entities.EntityMinecartModular;

public class ModuleRemover
extends ModuleWorker
implements IActivatorModule {
    @Nonnull
    private BlockPos remove = new BlockPos(0, -1, 0);
    private EntityDataAccessor<Boolean> IS_ENABLED;

    public ModuleRemover(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void initDw() {
        this.IS_ENABLED = this.createDw(EntityDataSerializers.BOOLEAN);
        this.registerDw(this.IS_ENABLED, true);
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public byte getWorkPriority() {
        return 120;
    }

    @Override
    protected boolean preventTurnback() {
        return true;
    }

    @Override
    public boolean work() {
        EntityMinecartModular cart = this.getCart();
        Level world = cart.level();
        if (this.remove.getY() != -1 && (this.remove.getX() != cart.x() || this.remove.getZ() != cart.z()) && this.removeRail(world, this.remove, true)) {
            return false;
        }
        BlockPos next = this.getNextblock();
        BlockPos last = this.getLastblock();
        boolean front = this.isRailAtCoords(world, next);
        boolean back = this.isRailAtCoords(world, last);
        if (!front) {
            if (back) {
                this.turnback();
                if (this.removeRail(world, cart.getExactPosition(), false)) {
                    return true;
                }
            }
        } else if (!back && this.removeRail(world, cart.getExactPosition(), false)) {
            return true;
        }
        return false;
    }

    private boolean isRailAtCoords(Level world, BlockPos coords) {
        return RailBlock.isRail((Level)world, (BlockPos)coords.above()) || RailBlock.isRail((Level)world, (BlockPos)coords) || RailBlock.isRail((Level)world, (BlockPos)coords.below());
    }

    private boolean removeRail(Level world, BlockPos pos, boolean flag) {
        if (flag) {
            BlockState blockState = world.getBlockState(pos);
            if (RailBlock.isRail((BlockState)blockState)) {
                if (this.isRemovingEnabled()) {
                    if (this.doPreWork()) {
                        this.startWorking(12);
                        return true;
                    }
                    ItemStack iStack = new ItemStack((ItemLike)blockState.getBlock(), 1);
                    this.getCart().addItemToChest(iStack);
                    if (iStack.getCount() == 0) {
                        world.removeBlock(pos, false);
                    }
                }
                this.remove = new BlockPos(pos.getX(), -1, pos.getZ());
            } else {
                this.remove = new BlockPos(pos.getX(), -1, pos.getZ());
            }
        } else if (RailBlock.isRail((Level)world, (BlockPos)pos.below())) {
            this.remove = pos.below();
        } else if (RailBlock.isRail((Level)world, (BlockPos)pos)) {
            this.remove = pos;
        } else if (RailBlock.isRail((Level)world, (BlockPos)pos.above())) {
            this.remove = pos.above();
        }
        this.stopWorking();
        return false;
    }

    private void enableRemoving(boolean remove) {
        if (!this.isPlaceholder()) {
            this.updateDw(this.IS_ENABLED, remove);
        }
    }

    private boolean isRemovingEnabled() {
        return !this.isPlaceholder() && this.getDw(this.IS_ENABLED) != false;
    }

    @Override
    public void doActivate(int id) {
        this.enableRemoving(true);
    }

    @Override
    public void doDeActivate(int id) {
        this.enableRemoving(false);
    }

    @Override
    public boolean isActive(int id) {
        return this.isRemovingEnabled();
    }
}

