/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers.tools;

import java.util.List;
import javax.annotation.Nonnull;
import net.creeperhost.polylib.helpers.LevelHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.IFluidBlock;
import vswe.stevescarts.SCConfig;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.interfaces.IActivatorModule;
import vswe.stevescarts.api.modules.template.ModuleChest;
import vswe.stevescarts.api.modules.template.ModuleTool;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.modules.addons.ModuleDrillIntelligence;
import vswe.stevescarts.modules.addons.ModuleHeightControl;
import vswe.stevescarts.modules.addons.ModuleIncinerator;
import vswe.stevescarts.modules.addons.ModuleLiquidSensors;
import vswe.stevescarts.modules.addons.ModuleOreTracker;

public abstract class ModuleDrill
extends ModuleTool
implements IActivatorModule {
    private ModuleDrillIntelligence intelligence;
    private ModuleLiquidSensors liquidsensors;
    private ModuleOreTracker tracker;
    private boolean hasHeightController;
    private byte sensorLight = 1;
    private float drillRotation;
    private int miningCoolDown;
    private int[] buttonRect = new int[]{15, 30, 24, 12};
    private boolean setup;
    private EntityDataAccessor<Boolean> IS_MINING;
    private EntityDataAccessor<Boolean> IS_ENABLED;

    public ModuleDrill(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public byte getWorkPriority() {
        return 50;
    }

    @Override
    public void init() {
        super.init();
        for (ModuleBase module : this.getCart().getModules()) {
            if (module instanceof ModuleDrillIntelligence) {
                this.intelligence = (ModuleDrillIntelligence)module;
            }
            if (module instanceof ModuleLiquidSensors) {
                this.liquidsensors = (ModuleLiquidSensors)module;
            }
            if (module instanceof ModuleOreTracker) {
                this.tracker = (ModuleOreTracker)module;
            }
            if (!(module instanceof ModuleHeightControl)) continue;
            this.hasHeightController = true;
        }
    }

    @Override
    public boolean work() {
        Level world = this.getCart().level();
        if (!this.isDrillEnabled()) {
            this.stopDrill();
            this.stopWorking();
            return false;
        }
        if (!this.doPreWork()) {
            this.stopDrill();
            this.stopWorking();
        }
        if (this.isBroken()) {
            return false;
        }
        BlockPos next = this.getNextblock();
        int[] range = this.mineRange();
        for (int holeY = range[1]; holeY >= range[0]; --holeY) {
            for (int holeX = -this.blocksOnSide(); holeX <= this.blocksOnSide(); ++holeX) {
                BlockPos mine;
                if (!this.isMiningSpotAllowed(next, holeX, holeY, range) || !this.mineBlockAndRevive(world, mine = next.offset(this.getCart().z() != next.getZ() ? holeX : 0, holeY, this.getCart().x() != next.getX() ? holeX : 0), next, holeX, holeY)) continue;
                return true;
            }
        }
        BlockPos pos = next.offset(0, range[0], 0);
        if (LevelHelper.isAir((Level)this.getCart().level(), (BlockPos)pos) && !this.isValidForTrack(pos, true) && this.mineBlockAndRevive(world, pos.below(), next, 0, range[0] - 1)) {
            return true;
        }
        this.stopWorking();
        this.stopDrill();
        return false;
    }

    private boolean isMiningSpotAllowed(BlockPos next, int holeX, int holeY, int[] range) {
        int maxHeight = (Integer)SCConfig.drillSize.get() * 2 + 1 - (this.hasHeightController ? (range[2] == 0 ? -1 : 1) : 0);
        if (Math.abs(holeX) <= (Integer)SCConfig.drillSize.get() && holeY <= maxHeight) {
            return this.intelligence == null || this.intelligence.isActive(holeX + this.blocksOnSide(), holeY, range[2], next.getX() > this.getCart().x() || next.getZ() < this.getCart().z());
        }
        return false;
    }

    private int[] mineRange() {
        BlockPos next = this.getNextblock();
        int yTarget = this.getCart().getYTarget();
        if (BaseRailBlock.isRail((Level)this.getCart().level(), (BlockPos)next) || BaseRailBlock.isRail((Level)this.getCart().level(), (BlockPos)next.below())) {
            return new int[]{0, this.blocksOnTop() - 1, 1};
        }
        if (next.getY() > yTarget) {
            return new int[]{-1, this.blocksOnTop() - 1, 1};
        }
        if (next.getY() < yTarget) {
            return new int[]{1, this.blocksOnTop() + 1, 0};
        }
        return new int[]{0, this.blocksOnTop() - 1, 1};
    }

    protected abstract int blocksOnTop();

    protected abstract int blocksOnSide();

    public int getAreaWidth() {
        return this.blocksOnSide() * 2 + 1;
    }

    public int getAreaHeight() {
        return this.blocksOnTop();
    }

    private boolean mineBlockAndRevive(Level world, BlockPos coord, BlockPos next, int holeX, int holeY) {
        if (this.mineBlock(world, coord, next, holeX, holeY, false)) {
            return true;
        }
        if (this.isDead()) {
            this.revive();
            return true;
        }
        return false;
    }

    protected boolean mineBlock(Level world, BlockPos coord, BlockPos next, int holeX, int holeY, boolean flag) {
        List drops;
        BlockPos target;
        if (this.tracker != null && (target = this.tracker.findBlockToMine(this, coord)) != null) {
            coord = target;
        }
        Object valid = this.isValidBlock(world, coord, holeX, holeY, flag);
        BlockEntity storage = null;
        if (valid instanceof BlockEntity) {
            storage = (BlockEntity)valid;
        } else if (valid == null) {
            return false;
        }
        BlockState blockState = world.getBlockState(coord);
        Block block = blockState.getBlock();
        float h = blockState.getDestroySpeed((BlockGetter)world, coord);
        if (h < 0.0f) {
            h = 0.0f;
        }
        if (storage != null) {
            for (int i = 0; i < ((Container)storage).getContainerSize(); ++i) {
                ItemStack iStack = ((Container)storage).getItem(i);
                if (iStack.isEmpty()) continue;
                if (!this.minedItem(world, iStack, next)) {
                    return false;
                }
                ((Container)storage).setItem(i, ItemStack.EMPTY);
            }
        }
        int fortune = this.enchanter != null ? this.enchanter.getFortuneLevel() : 0;
        ItemStack tool = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
        if (fortune > 0) {
            tool.enchant(Enchantments.BLOCK_FORTUNE, fortune);
        }
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)world).withParameter(LootContextParams.TOOL, (Object)tool).withParameter(LootContextParams.ORIGIN, (Object)this.getCart().position());
        if (storage != null) {
            builder.withParameter(LootContextParams.BLOCK_ENTITY, (Object)storage);
        }
        if (!(drops = block.getDrops(blockState, builder)).isEmpty()) {
            boolean shouldRemove = false;
            for (int j = 0; j < drops.size(); ++j) {
                if (!this.minedItem(world, (ItemStack)drops.get(j), next)) {
                    return false;
                }
                shouldRemove = true;
            }
            if (shouldRemove) {
                world.removeBlock(coord, false);
            }
        } else {
            world.removeBlock(coord, false);
        }
        this.damageTool(1 + (int)h);
        this.startWorking(this.getTimeToMine(h));
        this.startDrill();
        return true;
    }

    protected boolean minedItem(Level world, @Nonnull ItemStack iStack, BlockPos Coords) {
        ItemEntity entityitem;
        if (iStack.isEmpty() || iStack.getCount() <= 0) {
            return true;
        }
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleIncinerator)) continue;
            ((ModuleIncinerator)module).incinerate(iStack);
            if (iStack.getCount() > 0) continue;
            return true;
        }
        int size = iStack.getCount();
        this.getCart().addItemToChest(iStack);
        if (iStack.getCount() == 0) {
            return true;
        }
        boolean hasChest = false;
        for (ModuleBase module2 : this.getCart().getModules()) {
            if (!(module2 instanceof ModuleChest)) continue;
            hasChest = true;
            break;
        }
        if (!hasChest) {
            entityitem = new ItemEntity(world, (double)this.getCart().x(), (double)this.getCart().y(), (double)this.getCart().z(), iStack);
            world.addFreshEntity((Entity)entityitem);
            return true;
        }
        if (iStack.getCount() != size) {
            entityitem = new ItemEntity(world, (double)this.getCart().x(), (double)this.getCart().y(), (double)this.getCart().z(), iStack);
            world.addFreshEntity((Entity)entityitem);
            return true;
        }
        return false;
    }

    private int getTimeToMine(float hardness) {
        int efficiency = this.enchanter != null ? this.enchanter.getEfficiencyLevel() : 0;
        return (int)((double)(this.getTimeMult() * hardness) / Math.pow(1.3f, efficiency)) + (this.liquidsensors != null ? 2 : 0);
    }

    protected abstract float getTimeMult();

    public Object isValidBlock(Level world, BlockPos pos, int holeX, int holeY, boolean flag) {
        BlockEntity tileentity;
        if (!flag && BaseRailBlock.isRail((Level)world, (BlockPos)pos) || BaseRailBlock.isRail((Level)world, (BlockPos)pos.above())) {
            return null;
        }
        BlockState blockState = world.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block == null) {
            return null;
        }
        if (block == Blocks.AIR) {
            return null;
        }
        if (block == Blocks.BEDROCK) {
            return null;
        }
        if (block instanceof IFluidBlock) {
            return null;
        }
        if (blockState.getDestroySpeed((BlockGetter)world, pos) < 0.0f) {
            return null;
        }
        if (!world.getFluidState(pos).isEmpty()) {
            return null;
        }
        if (!(holeX == 0 && holeY <= 0 || block != Blocks.TORCH && block != Blocks.REDSTONE_WIRE && block != Blocks.REDSTONE_TORCH && block != Blocks.REPEATER && block != Blocks.COMPARATOR && block != ModBlocks.MODULE_TOGGLER.get())) {
            return null;
        }
        if (block instanceof BaseEntityBlock && Container.class.isInstance(tileentity = world.getBlockEntity(pos))) {
            if (holeX != 0 || holeY > 0) {
                return null;
            }
            return tileentity;
        }
        if (this.liquidsensors != null) {
            if (this.liquidsensors.isDangerous(this, pos.offset(0, 1, 0), true) || this.liquidsensors.isDangerous(this, pos.offset(1, 0, 0), false) || this.liquidsensors.isDangerous(this, pos.offset(-1, 0, 0), false) || this.liquidsensors.isDangerous(this, pos.offset(0, 0, 1), false) || this.liquidsensors.isDangerous(this, pos.offset(0, 0, -1), false)) {
                this.sensorLight = (byte)3;
                return null;
            }
            this.sensorLight = (byte)2;
        }
        return false;
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().level().isClientSide && !this.setup) {
            if (this.isPlaceholder() || !this.getDw(this.IS_MINING).booleanValue()) {
                this.drillRotation = 0.0f;
                this.miningCoolDown = 10;
            }
            this.setup = true;
        }
        if (this.getCart().hasFuel() && this.isMining() || this.miningCoolDown < 10) {
            this.drillRotation = (float)((double)(this.drillRotation + 0.03f * (float)(10 - this.miningCoolDown)) % (Math.PI * 2));
            this.miningCoolDown = this.isMining() ? 0 : ++this.miningCoolDown;
        }
        if (!this.getCart().level().isClientSide && this.liquidsensors != null) {
            byte data = this.sensorLight;
            if (this.isDrillSpinning()) {
                data = (byte)(data | 4);
            }
            this.liquidsensors.getInfoFromDrill(data);
            this.sensorLight = 1;
        }
    }

    protected void startDrill() {
        this.updateDw(this.IS_MINING, true);
    }

    protected void stopDrill() {
        this.updateDw(this.IS_MINING, false);
    }

    protected boolean isMining() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getDrillSpinning();
        }
        return this.getDw(this.IS_MINING);
    }

    protected boolean isDrillSpinning() {
        return this.isMining() || this.miningCoolDown < 10;
    }

    @Override
    public void initDw() {
        super.initDw();
        this.IS_MINING = this.createDw(EntityDataSerializers.BOOLEAN);
        this.IS_ENABLED = this.createDw(EntityDataSerializers.BOOLEAN);
        this.registerDw(this.IS_MINING, false);
        this.registerDw(this.IS_ENABLED, true);
    }

    @Override
    public int numberOfDataWatchers() {
        return 2 + super.numberOfDataWatchers();
    }

    public float getDrillRotation() {
        return this.drillRotation;
    }

    private boolean isDrillEnabled() {
        return this.getDw(this.IS_ENABLED);
    }

    public void setDrillEnabled(boolean val) {
        this.updateDw(this.IS_ENABLED, val);
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.buttonRect)) {
            this.sendPacket(0);
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        this.setDrillEnabled(!this.isDrillEnabled());
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, Localization.MODULES.TOOLS.DRILL.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        super.drawBackground(guiGraphics, gui, x, y);
        ResourceHelper.bindResource("/gui/drill.png");
        int imageID = this.isDrillEnabled() ? 1 : 0;
        int borderID = 0;
        if (this.inRect(x, y, this.buttonRect)) {
            borderID = 1;
        }
        this.drawImage(guiGraphics, gui, this.buttonRect, 0, this.buttonRect[3] * borderID);
        int srcY = this.buttonRect[3] * 2 + imageID * (this.buttonRect[3] - 2);
        this.drawImage(guiGraphics, gui, this.buttonRect[0] + 1, this.buttonRect[1] + 1, 0, srcY, this.buttonRect[2] - 2, this.buttonRect[3] - 2);
    }

    @Override
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        super.drawMouseOver(guiGraphics, gui, x, y);
        this.drawStringOnMouseOver(guiGraphics, gui, this.getStateName(), x, y, this.buttonRect);
    }

    private String getStateName() {
        return Localization.MODULES.TOOLS.TOGGLE.translate(this.isDrillEnabled() ? "1" : "0");
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        super.Save(tagCompound, id);
        tagCompound.putBoolean(this.generateNBTName("DrillEnabled", id), this.isDrillEnabled());
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        super.Load(tagCompound, id);
        this.setDrillEnabled(tagCompound.getBoolean(this.generateNBTName("DrillEnabled", id)));
    }

    @Override
    public boolean receiveDamage(DamageSource source, float val) {
        return !source.is(DamageTypes.LAVA) || !source.is(DamageTypes.ON_FIRE);
    }

    @Override
    public void doActivate(int id) {
        this.setDrillEnabled(true);
    }

    @Override
    public void doDeActivate(int id) {
        this.setDrillEnabled(false);
    }

    @Override
    public boolean isActive(int id) {
        return this.isDrillEnabled();
    }
}

