/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import vswe.stevescarts.network.packets.PacketActivator;
import vswe.stevescarts.network.packets.PacketCargpManager;
import vswe.stevescarts.network.packets.PacketCreateCart;
import vswe.stevescarts.network.packets.PacketDistributorTile;
import vswe.stevescarts.network.packets.PacketFluidSync;
import vswe.stevescarts.network.packets.PacketGuiData;
import vswe.stevescarts.network.packets.PacketMinecartButton;
import vswe.stevescarts.network.packets.PacketMinecartTurn;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = Integer.toString(1);

    public static void init(IEventBus bus) {
        bus.addListener(PacketHandler::registerEvent);
    }

    public static void registerEvent(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("stevescarts").versioned(PROTOCOL_VERSION);
        registrar.play(PacketCreateCart.ID, PacketCreateCart::read, PacketCreateCart::handle);
        registrar.play(PacketMinecartButton.ID, PacketMinecartButton::read, PacketMinecartButton::handle);
        registrar.play(PacketCargpManager.ID, PacketCargpManager::read, PacketCargpManager::handle);
        registrar.play(PacketDistributorTile.ID, PacketDistributorTile::read, PacketDistributorTile::handle);
        registrar.play(PacketActivator.ID, PacketActivator::read, PacketActivator::handle);
        registrar.play(PacketFluidSync.ID, PacketFluidSync::read, PacketFluidSync::handle);
        registrar.play(PacketMinecartTurn.ID, PacketMinecartTurn::read, PacketMinecartTurn::handle);
        registrar.play(PacketGuiData.ID, PacketGuiData::read, PacketGuiData::handle);
    }

    @Deprecated
    public static void sendToServer(CustomPacketPayload msg) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{msg});
    }

    @Deprecated
    public static void sendTo(CustomPacketPayload message, ServerPlayer player) {
        PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{message});
    }
}

