/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network.packets;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import vswe.stevescarts.blocks.tileentities.TileEntityManager;

public class PacketCargpManager
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("stevescarts", "cargo_manager");
    private final BlockPos blockPos;
    private final int id;
    private final byte[] array;

    public PacketCargpManager(BlockPos blockPos, int id, byte[] array) {
        this.blockPos = blockPos;
        this.id = id;
        this.array = array;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.blockPos);
        buf.writeInt(this.id);
        buf.writeByteArray(this.array);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketCargpManager read(FriendlyByteBuf buffer) {
        return new PacketCargpManager(buffer.readBlockPos(), buffer.readInt(), buffer.readByteArray());
    }

    public static void handle(PacketCargpManager msg, PlayPayloadContext ctx) {
        if (ctx.flow() != PacketFlow.SERVERBOUND) {
            return;
        }
        ctx.workHandler().execute(() -> {
            Object patt1654$temp;
            if (msg.blockPos != null && (patt1654$temp = ctx.player().orElse(null)) instanceof ServerPlayer) {
                BlockEntity patt1851$temp;
                ServerPlayer player = patt1654$temp;
                BlockPos blockPos = msg.blockPos;
                if (player.level().getBlockEntity(blockPos) != null && (patt1851$temp = player.level().getBlockEntity(blockPos)) instanceof TileEntityManager) {
                    TileEntityManager manager = (TileEntityManager)patt1851$temp;
                    manager.receivePacket(msg.id, msg.array, (Player)player);
                }
            }
        });
    }
}

