/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network.packets;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;

public class PacketCreateCart
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("stevescarts", "create_cart");
    private final BlockPos blockPos;
    private final int id;
    private final byte[] data;

    public PacketCreateCart(BlockPos blockPos, int id, byte[] data) {
        this.blockPos = blockPos;
        this.id = id;
        this.data = data;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.blockPos);
        buf.writeInt(this.id);
        buf.writeByteArray(this.data);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketCreateCart read(FriendlyByteBuf buffer) {
        return new PacketCreateCart(buffer.readBlockPos(), buffer.readInt(), buffer.readByteArray());
    }

    public static void handle(PacketCreateCart msg, PlayPayloadContext ctx) {
        if (ctx.flow() != PacketFlow.SERVERBOUND) {
            return;
        }
        ctx.workHandler().execute(() -> {
            Object patt1643$temp;
            if (msg.blockPos != null && (patt1643$temp = ctx.player().orElse(null)) instanceof ServerPlayer) {
                BlockEntity patt1826$temp;
                ServerPlayer player = patt1643$temp;
                BlockPos blockPos = msg.blockPos;
                if (player.level().isLoaded(blockPos) && (patt1826$temp = player.level().getBlockEntity(blockPos)) instanceof TileEntityCartAssembler) {
                    TileEntityCartAssembler tileEntityCartAssembler = (TileEntityCartAssembler)patt1826$temp;
                    tileEntityCartAssembler.receivePacket(msg.id, msg.data, player);
                }
            }
        });
    }
}

