/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network.packets;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import vswe.stevescarts.blocks.tileentities.TileEntityDistributor;

public class PacketDistributorTile
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("stevescarts", "distributor");
    private final BlockPos blockPos;
    private final int id;
    private final byte[] array;

    public PacketDistributorTile(BlockPos blockPos, int id, byte[] array) {
        this.blockPos = blockPos;
        this.id = id;
        this.array = array;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.blockPos);
        buf.writeInt(this.id);
        buf.writeByteArray(this.array);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketDistributorTile read(FriendlyByteBuf buffer) {
        return new PacketDistributorTile(buffer.readBlockPos(), buffer.readInt(), buffer.readByteArray());
    }

    public static void handle(PacketDistributorTile msg, PlayPayloadContext ctx) {
        if (ctx.flow() != PacketFlow.SERVERBOUND) {
            return;
        }
        ctx.workHandler().execute(() -> {
            Object patt1671$temp;
            if (msg.blockPos != null && (patt1671$temp = ctx.player().orElse(null)) instanceof ServerPlayer) {
                BlockEntity patt1868$temp;
                ServerPlayer player = patt1671$temp;
                BlockPos blockPos = msg.blockPos;
                if (player.level().getBlockEntity(blockPos) != null && (patt1868$temp = player.level().getBlockEntity(blockPos)) instanceof TileEntityDistributor) {
                    TileEntityDistributor tileEntityDistributor = (TileEntityDistributor)patt1868$temp;
                    tileEntityDistributor.receivePacket(msg.id, msg.array, player);
                }
            }
        });
    }
}

