/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network.packets;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import vswe.stevescarts.blocks.tileentities.TileEntityLiquid;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;

public class PacketFluidSync
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("stevescarts", "fluid_sync");
    private FluidStack fluidStack;
    private BlockPos pos;
    private int tankID;

    public PacketFluidSync(FluidStack fluidStack, BlockPos pos, int tankID) {
        this.fluidStack = fluidStack;
        this.pos = pos;
        this.tankID = tankID;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeFluidStack(this.fluidStack);
        buf.writeBlockPos(this.pos);
        buf.writeInt(this.tankID);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketFluidSync read(FriendlyByteBuf buffer) {
        return new PacketFluidSync(buffer.readFluidStack(), buffer.readBlockPos(), buffer.readInt());
    }

    public static void handle(PacketFluidSync msg, PlayPayloadContext ctx) {
        if (ctx.flow() != PacketFlow.CLIENTBOUND) {
            return;
        }
        ctx.workHandler().execute(() -> {
            ClientLevel level = Minecraft.getInstance().level;
            if (level == null) {
                return;
            }
            BlockEntity tile = level.getBlockEntity(msg.pos);
            if (tile instanceof TileEntityLiquid) {
                TileEntityLiquid entityLiquid = (TileEntityLiquid)tile;
                entityLiquid.tanks[msg.tankID].setFluid(msg.fluidStack);
            } else if (tile instanceof TileEntityUpgrade) {
                TileEntityUpgrade entityUpgrade = (TileEntityUpgrade)tile;
                entityUpgrade.tank.setFluid(msg.fluidStack);
            }
        });
    }
}

