/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network.packets;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import vswe.stevescarts.entities.EntityMinecartModular;

public class PacketMinecartTurn
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("stevescarts", "cart_turn");
    private final int cartID;

    public PacketMinecartTurn(int cartID) {
        this.cartID = cartID;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.cartID);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketMinecartTurn read(FriendlyByteBuf buffer) {
        return new PacketMinecartTurn(buffer.readInt());
    }

    public static void handle(PacketMinecartTurn msg, PlayPayloadContext ctx) {
        if (ctx.flow() != PacketFlow.SERVERBOUND) {
            return;
        }
        ctx.workHandler().execute(() -> {
            Object patt1354$temp = ctx.player().orElse(null);
            if (patt1354$temp instanceof ServerPlayer) {
                ServerPlayer player = patt1354$temp;
                Level level = player.level();
                if (level.getEntity(msg.cartID) == null) {
                    return;
                }
                Entity patt1550$temp = level.getEntity(msg.cartID);
                if (patt1550$temp instanceof EntityMinecartModular) {
                    EntityMinecartModular entityMinecartModular = (EntityMinecartModular)patt1550$temp;
                    entityMinecartModular.turnback();
                }
            }
        });
    }
}

