/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.upgrades;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import vswe.stevescarts.api.upgrades.BaseUpgradeEffect;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.upgrades.Blueprint;
import vswe.stevescarts.upgrades.CombustionFuel;
import vswe.stevescarts.upgrades.Deployer;
import vswe.stevescarts.upgrades.Disassemble;
import vswe.stevescarts.upgrades.FuelCapacity;
import vswe.stevescarts.upgrades.FuelCost;
import vswe.stevescarts.upgrades.InputChest;
import vswe.stevescarts.upgrades.InterfaceUpgradeEffect;
import vswe.stevescarts.upgrades.InventoryUpgradeEffect;
import vswe.stevescarts.upgrades.Manager;
import vswe.stevescarts.upgrades.Recharger;
import vswe.stevescarts.upgrades.Redstone;
import vswe.stevescarts.upgrades.Solar;
import vswe.stevescarts.upgrades.TankUpgradeEffect;
import vswe.stevescarts.upgrades.ThermalFuel;
import vswe.stevescarts.upgrades.TimeFlat;
import vswe.stevescarts.upgrades.TimeFlatCart;
import vswe.stevescarts.upgrades.TimeFlatRemoved;
import vswe.stevescarts.upgrades.Transposer;
import vswe.stevescarts.upgrades.WorkEfficiency;

public class AssemblerUpgrade {
    private static HashMap<Byte, AssemblerUpgrade> upgrades = new HashMap();
    private final byte id;
    private final String name;
    private final ArrayList<BaseUpgradeEffect> effects;
    private String icon;

    public static HashMap<Byte, AssemblerUpgrade> getUpgrades() {
        return upgrades;
    }

    public static Collection<AssemblerUpgrade> getUpgradesList() {
        return upgrades.values();
    }

    public static AssemblerUpgrade getUpgrade(int id) {
        return upgrades.get((byte)id);
    }

    public static void init() {
        new AssemblerUpgrade(0, "Batteries").addEffect(new FuelCapacity(5000)).addEffect(new Recharger(40));
        new AssemblerUpgrade(1, "Power Crystal").addEffect(new FuelCapacity(15000)).addEffect(new Recharger(150));
        new AssemblerUpgrade(2, "Module knowledge").addEffect(new TimeFlat(-750)).addEffect(new TimeFlatCart(-5000)).addEffect(new WorkEfficiency(-0.01f));
        new AssemblerUpgrade(3, "Industrial espionage").addEffect(new TimeFlat(-2500)).addEffect(new TimeFlatCart(-14000)).addEffect(new WorkEfficiency(-0.01f));
        new AssemblerUpgrade(4, "Experienced assembler").addEffect(new WorkEfficiency(0.1f)).addEffect(new FuelCost(0.3f));
        new AssemblerUpgrade(5, "New Era").addEffect(new WorkEfficiency(1.0f)).addEffect(new FuelCost(30.0f));
        new AssemblerUpgrade(6, "CO2 friendly").addEffect(new FuelCost(-0.15f));
        new AssemblerUpgrade(7, "Generic engine").addEffect(new CombustionFuel()).addEffect(new FuelCost(0.05f));
        new AssemblerUpgrade(8, "Module input", 1).addEffect(new InputChest(7, 3));
        new AssemblerUpgrade(9, "Production line").addEffect(new Blueprint());
        new AssemblerUpgrade(10, "Cart Deployer").addEffect(new Deployer());
        new AssemblerUpgrade(11, "Cart Modifier").addEffect(new Disassemble());
        new AssemblerUpgrade(12, "Cart Crane").addEffect(new Transposer());
        new AssemblerUpgrade(13, "Redstone Control").addEffect(new Redstone());
        new AssemblerUpgrade(14, "Creative Mode").addEffect(new WorkEfficiency(10000.0f)).addEffect(new FuelCost(-1.0f));
        new AssemblerUpgrade(15, "Quick Demolisher").addEffect(new TimeFlatRemoved(-8000));
        new AssemblerUpgrade(16, "Entropy").addEffect(new TimeFlatRemoved(-32000)).addEffect(new TimeFlat(3000));
        new AssemblerUpgrade(17, "Manager Bridge").addEffect(new Manager()).addEffect(new TimeFlatCart(200));
        new AssemblerUpgrade(18, "Thermal Engine").addEffect(new ThermalFuel()).addEffect(new FuelCost(0.05f));
        new AssemblerUpgrade(19, "Solar Panel").addEffect(new Solar());
    }

    public AssemblerUpgrade(int id, String name) {
        this(id, name, 0);
    }

    public AssemblerUpgrade(int id, String name, int sideTexture) {
        this.id = (byte)id;
        this.name = name;
        this.effects = new ArrayList();
        upgrades.put(this.id, this);
    }

    public byte getId() {
        return this.id;
    }

    public String getName() {
        return "block.stevescarts.upgrade_" + this.getRawName();
    }

    public AssemblerUpgrade addEffect(BaseUpgradeEffect effect) {
        this.effects.add(effect);
        return this;
    }

    public ArrayList<BaseUpgradeEffect> getEffects() {
        return this.effects;
    }

    public int getInventorySize() {
        InventoryUpgradeEffect inv = this.getInventoryEffect();
        if (inv != null) {
            return inv.getInventorySize();
        }
        return 0;
    }

    public InterfaceUpgradeEffect getInterfaceEffect() {
        for (BaseUpgradeEffect effect : this.effects) {
            if (!(effect instanceof InterfaceUpgradeEffect)) continue;
            return (InterfaceUpgradeEffect)effect;
        }
        return null;
    }

    public InventoryUpgradeEffect getInventoryEffect() {
        for (BaseUpgradeEffect effect : this.effects) {
            if (!(effect instanceof InventoryUpgradeEffect)) continue;
            return (InventoryUpgradeEffect)effect;
        }
        return null;
    }

    public TankUpgradeEffect getTankEffect() {
        for (BaseUpgradeEffect effect : this.effects) {
            if (!(effect instanceof TankUpgradeEffect)) continue;
            return (TankUpgradeEffect)effect;
        }
        return null;
    }

    public void init(TileEntityUpgrade upgrade) {
        for (BaseUpgradeEffect effect : this.effects) {
            effect.init(upgrade);
        }
    }

    public void load(TileEntityUpgrade upgrade, CompoundTag compound) {
        for (BaseUpgradeEffect effect : this.effects) {
            effect.load(upgrade, compound);
        }
    }

    public void save(TileEntityUpgrade upgrade, CompoundTag compound) {
        for (BaseUpgradeEffect effect : this.effects) {
            effect.save(upgrade, compound);
        }
    }

    public void update(TileEntityUpgrade upgrade) {
        for (BaseUpgradeEffect effect : this.effects) {
            effect.update(upgrade);
        }
    }

    public void removed(TileEntityUpgrade upgrade) {
        for (BaseUpgradeEffect effect : this.effects) {
            effect.removed(upgrade);
        }
    }

    public String getRawName() {
        return this.name.replace(":", "").replace(" ", "_").toLowerCase(Locale.ROOT);
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }
}

