/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt;

import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.belt.ToolBeltItem;
import dev.gigaherz.toolbelt.network.BeltContentsChange;
import dev.gigaherz.toolbelt.slot.BeltAttachment;
import java.util.Optional;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class BeltFinderBeltSlot
extends BeltFinder {
    public static final String FINDER_ID = "belt_slot";

    public static void initBaubles() {
        BeltFinder.addFinder(new BeltFinderBeltSlot());
    }

    @Override
    protected Optional<BeltFinder.BeltGetter> getSlotFromId(Player player, int slotId) {
        return Optional.of(new ExtensionSlotBeltGetter((LivingEntity)player, BeltAttachment.get((LivingEntity)player)));
    }

    @Override
    public String getName() {
        return FINDER_ID;
    }

    @Override
    public Optional<? extends BeltFinder.BeltGetter> findStack(LivingEntity player, boolean allowCosmetic) {
        BeltAttachment attachment = BeltAttachment.get(player);
        return attachment.getContents().getItem() instanceof ToolBeltItem ? Optional.of(new ExtensionSlotBeltGetter(player, attachment)) : Optional.empty();
    }

    private static class ExtensionSlotBeltGetter
    implements BeltFinder.BeltGetter {
        private final LivingEntity player;
        private final BeltAttachment slot;

        private ExtensionSlotBeltGetter(LivingEntity player, BeltAttachment slot) {
            this.player = player;
            this.slot = slot;
        }

        @Override
        public ItemStack getBelt() {
            return this.slot.getContents();
        }

        @Override
        public void setBelt(ItemStack stack) {
            this.slot.setContents(stack);
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public void syncToClients() {
            LivingEntity thePlayer = this.slot.getOwner();
            if (thePlayer.level().isClientSide) {
                return;
            }
            PacketDistributor.TRACKING_ENTITY_AND_SELF.with((Object)thePlayer).send(new CustomPacketPayload[]{new BeltContentsChange(thePlayer, BeltFinderBeltSlot.FINDER_ID, 0, this.slot.getContents())});
        }
    }
}

