/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.belt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.belt.ToolBeltItem;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class BeltIngredient
extends Ingredient {
    public static final Codec<BeltIngredient> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("upgrade_level").forGetter(obj -> obj.level)).apply((Applicative)inst, BeltIngredient::new));
    private final int level;

    public static BeltIngredient withLevel(int level) {
        return new BeltIngredient(level);
    }

    protected BeltIngredient(int level) {
        super(Stream.of(new Ingredient.ItemValue(((ToolBeltItem)ToolBelt.BELT.get()).of(level))));
        this.level = level;
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && stack.getItem() == ToolBelt.BELT.get() && ((ToolBeltItem)ToolBelt.BELT.get()).getLevel(stack) == this.level;
    }
}

