/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.belt;

import dev.gigaherz.toolbelt.ConfigData;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ToolBeltInventory
implements IItemHandlerModifiable {
    private final ItemStack itemStack;

    public ToolBeltInventory(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    private CompoundTag getTagOrDummy() {
        CompoundTag tag = this.itemStack.getTag();
        if (tag == null) {
            tag = new CompoundTag();
        }
        return tag;
    }

    private CompoundTag getOrCreateTag() {
        return this.itemStack.getOrCreateTag();
    }

    public int getSlots() {
        return Mth.clamp((int)this.getTagOrDummy().getInt("Size"), (int)2, (int)9);
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        ListTag tagList = this.getTagOrDummy().getList("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.getCompound(i);
            if (itemTags.getInt("Slot") != slot) continue;
            return ItemStack.of((CompoundTag)itemTags);
        }
        return ItemStack.EMPTY;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        boolean hasStack;
        this.validateSlotIndex(slot);
        CompoundTag itemTag = null;
        boolean bl = hasStack = stack.getCount() > 0;
        if (hasStack) {
            itemTag = new CompoundTag();
            itemTag.putInt("Slot", slot);
            stack.save(itemTag);
        }
        ListTag tagList = this.getTagOrDummy().getList("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag existing = tagList.getCompound(i);
            if (existing.getInt("Slot") != slot) continue;
            if (hasStack) {
                tagList.set(i, (Tag)itemTag);
            } else {
                tagList.remove(i);
            }
            return;
        }
        if (hasStack) {
            tagList.add((Object)itemTag);
        }
        CompoundTag tag0 = this.getOrCreateTag();
        tag0.put("Items", (Tag)tagList);
        this.itemStack.setTag(tag0);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (!this.canInsertItem(slot, stack)) {
            return stack;
        }
        if (stack.getCount() <= 0) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        int limit = stack.getMaxStackSize();
        if (existing.getCount() > 0) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.getCount() <= 0) {
                existing = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
            this.setStackInSlot(slot, existing);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.getCount() - limit)) : ItemStack.EMPTY;
    }

    protected boolean canInsertItem(int slot, ItemStack stack) {
        return ConfigData.isItemStackAllowed(stack);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.getCount() <= 0) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                this.setStackInSlot(slot, ItemStack.EMPTY);
            }
            return existing;
        }
        if (!simulate) {
            this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.getCount() - toExtract)));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return false;
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }
}

