/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.client;

import com.mojang.blaze3d.platform.InputConstants;
import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ConfigData;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.client.RadialMenuScreen;
import dev.gigaherz.toolbelt.client.ToolBeltLayer;
import dev.gigaherz.toolbelt.network.OpenBeltSlotInventory;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.Input;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.lwjgl.glfw.GLFW;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="toolbelt", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEvents {
    public static KeyMapping OPEN_TOOL_MENU_KEYBIND;
    public static KeyMapping CYCLE_TOOL_MENU_LEFT_KEYBIND;
    public static KeyMapping CYCLE_TOOL_MENU_RIGHT_KEYBIND;
    public static KeyMapping OPEN_BELT_SLOT_KEYBIND;
    private static boolean toolMenuKeyWasDown;
    public static ModelLayerLocation BELT_LAYER;

    public static void wipeOpen() {
        while (OPEN_TOOL_MENU_KEYBIND.consumeClick()) {
        }
    }

    @SubscribeEvent
    public static void handleKeys(TickEvent.ClientTickEvent ev) {
        if (ev.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen == null) {
            boolean toolMenuKeyIsDown = OPEN_TOOL_MENU_KEYBIND.isDown();
            if (toolMenuKeyIsDown && !toolMenuKeyWasDown) {
                while (OPEN_TOOL_MENU_KEYBIND.consumeClick()) {
                    ItemStack inHand;
                    if (mc.screen != null || !ConfigData.isItemStackAllowed(inHand = mc.player.getMainHandItem())) continue;
                    BeltFinder.findBelt((LivingEntity)mc.player).ifPresent(getter -> mc.setScreen((Screen)new RadialMenuScreen((BeltFinder.BeltGetter)getter)));
                }
            }
            toolMenuKeyWasDown = toolMenuKeyIsDown;
        } else {
            toolMenuKeyWasDown = true;
        }
        if (ConfigData.customBeltSlotEnabled) {
            while (OPEN_BELT_SLOT_KEYBIND.consumeClick()) {
                if (mc.screen != null) continue;
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new OpenBeltSlotInventory()});
            }
        }
    }

    @SubscribeEvent
    public static void updateInputEvent(MovementInputUpdateEvent event) {
        if (Minecraft.getInstance().screen instanceof RadialMenuScreen) {
            Options settings = Minecraft.getInstance().options;
            Input eInput = event.getInput();
            eInput.up = ClientEvents.isKeyDown0(settings.keyUp);
            eInput.down = ClientEvents.isKeyDown0(settings.keyDown);
            eInput.left = ClientEvents.isKeyDown0(settings.keyLeft);
            eInput.right = ClientEvents.isKeyDown0(settings.keyRight);
            float f = eInput.up == eInput.down ? 0.0f : (eInput.forwardImpulse = eInput.up ? 1.0f : -1.0f);
            eInput.leftImpulse = eInput.left == eInput.right ? 0.0f : (eInput.left ? 1.0f : -1.0f);
            eInput.jumping = ClientEvents.isKeyDown0(settings.keyJump);
            eInput.shiftKeyDown = ClientEvents.isKeyDown0(settings.keyShift);
            if (Minecraft.getInstance().player.isMovingSlowly()) {
                eInput.leftImpulse = (float)((double)eInput.leftImpulse * 0.3);
                eInput.forwardImpulse = (float)((double)eInput.forwardImpulse * 0.3);
            }
        }
    }

    public static boolean isKeyDown0(KeyMapping keybind) {
        if (keybind.isUnbound()) {
            return false;
        }
        return switch (keybind.getKey().getType()) {
            case InputConstants.Type.KEYSYM -> InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keybind.getKey().getValue());
            case InputConstants.Type.MOUSE -> {
                if (GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)keybind.getKey().getValue()) == 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static boolean isKeyDown(KeyMapping keybind) {
        if (keybind.isUnbound()) {
            return false;
        }
        boolean isDown = switch (keybind.getKey().getType()) {
            case InputConstants.Type.KEYSYM -> InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keybind.getKey().getValue());
            case InputConstants.Type.MOUSE -> {
                if (GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)keybind.getKey().getValue()) == 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
        return isDown && keybind.getKeyConflictContext().isActive() && keybind.getKeyModifier().isActive(keybind.getKeyConflictContext());
    }

    static {
        toolMenuKeyWasDown = false;
        BELT_LAYER = new ModelLayerLocation(new ResourceLocation("minecraft:player"), "toolbelt_belt");
    }

    @Mod.EventBusSubscriber(modid="toolbelt", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void initKeybinds(RegisterKeyMappingsEvent event) {
            OPEN_TOOL_MENU_KEYBIND = new KeyMapping("key.toolbelt.open", 82, "key.toolbelt.category");
            event.register(OPEN_TOOL_MENU_KEYBIND);
            CYCLE_TOOL_MENU_LEFT_KEYBIND = new KeyMapping("key.toolbelt.cycle.left", InputConstants.UNKNOWN.getValue(), "key.toolbelt.category");
            event.register(CYCLE_TOOL_MENU_LEFT_KEYBIND);
            CYCLE_TOOL_MENU_RIGHT_KEYBIND = new KeyMapping("key.toolbelt.cycle.right", InputConstants.UNKNOWN.getValue(), "key.toolbelt.category");
            event.register(CYCLE_TOOL_MENU_RIGHT_KEYBIND);
            OPEN_BELT_SLOT_KEYBIND = new KeyMapping("key.toolbelt.slot", 86, "key.toolbelt.category");
            event.register(OPEN_BELT_SLOT_KEYBIND);
        }

        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> ItemProperties.register((Item)((Item)ToolBelt.BELT.get()), (ResourceLocation)ToolBelt.location("has_custom_color"), (pStack, pLevel, pEntity, pSeed) -> {
                DyeableLeatherItem dyeable;
                Item patt7880$temp = pStack.getItem();
                return patt7880$temp instanceof DyeableLeatherItem && (dyeable = (DyeableLeatherItem)patt7880$temp).hasCustomColor(pStack) ? 1 : 0;
            }));
        }

        @SubscribeEvent
        public static void colors(RegisterColorHandlersEvent.Item event) {
            event.register((pStack, pTintIndex) -> {
                DyeableLeatherItem dyeable;
                Item patt8316$temp;
                return pTintIndex == 0 && (patt8316$temp = pStack.getItem()) instanceof DyeableLeatherItem && (dyeable = (DyeableLeatherItem)patt8316$temp).hasCustomColor(pStack) ? dyeable.getColor(pStack) : -1;
            }, new ItemLike[]{(ItemLike)ToolBelt.BELT.get()});
        }

        @SubscribeEvent
        public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(BELT_LAYER, ToolBeltLayer.BeltModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void construct(EntityRenderersEvent.AddLayers event) {
            ModBusEvents.addLayerToHumanoid(event, EntityType.ARMOR_STAND, ToolBeltLayer::new);
            ModBusEvents.addLayerToHumanoid(event, EntityType.ZOMBIE, ToolBeltLayer::new);
            ModBusEvents.addLayerToHumanoid(event, EntityType.SKELETON, ToolBeltLayer::new);
            ModBusEvents.addLayerToHumanoid(event, EntityType.HUSK, ToolBeltLayer::new);
            ModBusEvents.addLayerToHumanoid(event, EntityType.DROWNED, ToolBeltLayer::new);
            ModBusEvents.addLayerToHumanoid(event, EntityType.STRAY, ToolBeltLayer::new);
            ModBusEvents.addLayerToPlayerSkin(event, PlayerSkin.Model.WIDE, ToolBeltLayer::new);
            ModBusEvents.addLayerToPlayerSkin(event, PlayerSkin.Model.SLIM, ToolBeltLayer::new);
        }

        private static <E extends Player, M extends HumanoidModel<E>> void addLayerToPlayerSkin(EntityRenderersEvent.AddLayers event, PlayerSkin.Model skinName, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
            EntityRenderer renderer = event.getSkin(skinName);
            if (renderer instanceof LivingEntityRenderer) {
                LivingEntityRenderer ler = (LivingEntityRenderer)renderer;
                ler.addLayer(factory.apply(ler));
            }
        }

        private static <E extends LivingEntity, M extends HumanoidModel<E>> void addLayerToHumanoid(EntityRenderersEvent.AddLayers event, EntityType<E> entityType, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
            EntityRenderer renderer = event.getRenderer(entityType);
            if (renderer instanceof LivingEntityRenderer) {
                LivingEntityRenderer ler = (LivingEntityRenderer)renderer;
                ler.addLayer(factory.apply(ler));
            }
        }

        private static <E extends LivingEntity, M extends EntityModel<E>> void addLayerToLiving(EntityRenderersEvent.AddLayers event, EntityType<E> entityType, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
            LivingEntityRenderer renderer = (LivingEntityRenderer)event.getRenderer(entityType);
            if (renderer != null) {
                renderer.addLayer(factory.apply(renderer));
            }
        }
    }
}

