/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ConfigData;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.belt.ToolBeltItem;
import dev.gigaherz.toolbelt.client.ClientEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class ToolBeltLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation TEXTURE_BELT = ToolBelt.location("textures/entity/belt.png");
    private static final ResourceLocation TEXTURE_BELT_DYED = ToolBelt.location("textures/entity/dyed_belt.png");
    private final BeltModel<T> beltModel = new BeltModel(Minecraft.getInstance().getEntityModels().bakeLayer(ClientEvents.BELT_LAYER));

    public ToolBeltLayer(RenderLayerParent<T, M> owner) {
        super(owner);
    }

    private void translateToBody(LivingEntity entity, PoseStack poseStack) {
        ((HumanoidModel)this.getParentModel()).body.translateAndRotate(poseStack);
        if (entity.isBaby() && !(entity instanceof Villager)) {
            poseStack.scale(0.52f, 0.52f, 0.52f);
            poseStack.translate(0.0, 1.4, 0.0);
        }
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int lightness, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!ConfigData.showBeltOnPlayers) {
            return;
        }
        BeltFinder.findBelt(entity, true).ifPresent(getter -> {
            if (getter.isHidden()) {
                return;
            }
            ItemStack stack = getter.getBelt();
            matrixStack.pushPose();
            this.translateToBody((LivingEntity)entity, matrixStack);
            IItemHandler cap = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
            if (cap != null) {
                ItemStack rightItem;
                boolean rightHanded = entity.getMainArm() == HumanoidArm.RIGHT;
                ItemStack firstItem = cap.getStackInSlot(0);
                ItemStack secondItem = cap.getStackInSlot(1);
                ItemStack leftItem = rightHanded ? firstItem : secondItem;
                ItemStack itemStack = rightItem = rightHanded ? secondItem : firstItem;
                if (!leftItem.isEmpty() || !rightItem.isEmpty()) {
                    matrixStack.pushPose();
                    if (((HumanoidModel)this.getParentModel()).young) {
                        matrixStack.translate(0.0f, 0.75f, 0.0f);
                        matrixStack.scale(0.5f, 0.5f, 0.5f);
                    }
                    ToolBeltLayer.renderHeldItem(entity, rightItem, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, matrixStack, buffer, lightness);
                    ToolBeltLayer.renderHeldItem(entity, leftItem, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, matrixStack, buffer, lightness);
                    matrixStack.popPose();
                }
            }
            matrixStack.translate(0.0f, 0.19f, 0.0f);
            matrixStack.scale(0.85f, 0.6f, 0.78f);
            Item patt4443$temp = stack.getItem();
            if (patt4443$temp instanceof ToolBeltItem) {
                ToolBeltItem beltItem = (ToolBeltItem)patt4443$temp;
                this.beltModel.hasColor = beltItem.hasCustomColor(stack);
                if (this.beltModel.hasColor) {
                    int dyeColor = beltItem.getColor(stack);
                    this.beltModel.dyeRed = (float)FastColor.ARGB32.red((int)dyeColor) / 255.0f;
                    this.beltModel.dyeGreen = (float)FastColor.ARGB32.green((int)dyeColor) / 255.0f;
                    this.beltModel.dyeBlue = (float)FastColor.ARGB32.blue((int)dyeColor) / 255.0f;
                }
            }
            ToolBeltLayer.renderColoredCutoutModel(this.beltModel, (ResourceLocation)this.getTextureLocation(entity), (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)lightness, (LivingEntity)entity, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.popPose();
        });
    }

    private static void renderHeldItem(LivingEntity player, ItemStack stack, ItemDisplayContext transformType, HumanoidArm handSide, PoseStack matrixStack, MultiBufferSource buffer, int lightness) {
        if (stack.isEmpty()) {
            return;
        }
        matrixStack.pushPose();
        if (handSide == HumanoidArm.LEFT) {
            matrixStack.translate(-0.271875f, 0.7f, -0.1f);
        } else {
            matrixStack.translate(0.271875f, 0.7f, -0.1f);
        }
        matrixStack.mulPose(Axis.XP.rotationDegrees(40.0f));
        float scale = ConfigData.beltItemScale;
        matrixStack.scale(scale, scale, scale);
        Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer().renderItem(player, stack, transformType, handSide == HumanoidArm.LEFT, matrixStack, buffer, lightness);
        matrixStack.popPose();
    }

    protected ResourceLocation getTextureLocation(T pEntity) {
        return BeltFinder.findBelt(pEntity, true).map(getter -> {
            ToolBeltItem beltItem;
            ItemStack stack = getter.getBelt();
            Item patt6339$temp = stack.getItem();
            return patt6339$temp instanceof ToolBeltItem && (beltItem = (ToolBeltItem)patt6339$temp).hasCustomColor(stack) ? TEXTURE_BELT_DYED : TEXTURE_BELT;
        }).orElse(TEXTURE_BELT);
    }

    public static class BeltModel<T extends LivingEntity>
    extends EntityModel<T> {
        private static final String BELT = "belt";
        private static final String BUCKLE = "buckle";
        private static final String LEFT_POCKET = "left_pocket";
        private static final String RIGHT_POCKET = "right_pocket";
        private final ModelPart belt;
        private final ModelPart buckle;
        private final ModelPart left_pocket;
        private final ModelPart right_pocket;
        public boolean hasColor;
        public float dyeRed;
        public float dyeGreen;
        public float dyeBlue;

        public BeltModel(ModelPart part) {
            super(RenderType::entityCutoutNoCull);
            this.belt = part.getChild(BELT);
            this.buckle = part.getChild(BUCKLE);
            this.left_pocket = part.getChild(LEFT_POCKET);
            this.right_pocket = part.getChild(RIGHT_POCKET);
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.getRoot();
            partdefinition.addOrReplaceChild(BELT, CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 10.0f, -3.0f, 10.0f, 4.0f, 6.0f), PartPose.ZERO);
            partdefinition.addOrReplaceChild(BUCKLE, CubeListBuilder.create().texOffs(10, 10).addBox(-2.5f, 9.5f, -3.5f, 5.0f, 5.0f, 1.0f), PartPose.ZERO);
            partdefinition.addOrReplaceChild(LEFT_POCKET, CubeListBuilder.create().texOffs(0, 10).addBox(-2.0f, 12.0f, 5.0f, 4.0f, 4.0f, 1.0f), PartPose.rotation((float)0.0f, (float)-90.0f, (float)0.0f));
            partdefinition.addOrReplaceChild(RIGHT_POCKET, CubeListBuilder.create().texOffs(0, 10).addBox(-2.0f, 12.0f, 5.0f, 4.0f, 4.0f, 1.0f), PartPose.rotation((float)0.0f, (float)90.0f, (float)0.0f));
            return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
        }

        public void renderToBuffer(PoseStack matrixStack, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            float cRed = red;
            float cGreen = green;
            float cBlue = blue;
            if (this.hasColor) {
                cRed *= this.dyeRed;
                cGreen *= this.dyeGreen;
                cBlue *= this.dyeBlue;
            }
            this.belt.render(matrixStack, vertexBuilder, packedLightIn, packedOverlayIn, cRed, cGreen, cBlue, alpha);
            this.left_pocket.render(matrixStack, vertexBuilder, packedLightIn, packedOverlayIn, cRed, cGreen, cBlue, alpha);
            this.right_pocket.render(matrixStack, vertexBuilder, packedLightIn, packedOverlayIn, cRed, cGreen, cBlue, alpha);
            matrixStack.pushPose();
            matrixStack.scale(0.8f, 1.0f, 1.0f);
            this.buckle.render(matrixStack, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStack.popPose();
        }

        public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        }
    }
}

