/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.common;

import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.belt.ToolBeltInventory;
import dev.gigaherz.toolbelt.common.BeltSlot;
import dev.gigaherz.toolbelt.common.LockedSlot;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class BeltContainer
extends AbstractContainerMenu {
    public final int beltSlots;
    private ItemStack blockedStack;
    private final int blockedSlot;

    public BeltContainer(int id, Inventory inventory, FriendlyByteBuf extraData) {
        this(id, inventory, extraData.readVarInt(), extraData.readItem());
    }

    public BeltContainer(int id, Inventory playerInventory, int blockedSlot, ItemStack blockedStack) {
        super((MenuType)ToolBelt.BELT_MENU.get(), id);
        ToolBeltInventory inv;
        IItemHandler iItemHandler;
        this.blockedStack = blockedStack;
        this.blockedSlot = blockedSlot;
        if (blockedSlot >= 0 && !this.stillValid(playerInventory.player)) {
            blockedStack = ItemStack.EMPTY;
        }
        ToolBeltInventory beltInventory = this.stillValid(playerInventory.player) && (iItemHandler = Objects.requireNonNull((IItemHandler)blockedStack.getCapability(Capabilities.ItemHandler.ITEM), "Item handler not present.")) instanceof ToolBeltInventory ? (inv = (ToolBeltInventory)iItemHandler) : new ToolBeltInventory(new ItemStack((ItemLike)ToolBelt.BELT.get()));
        this.beltSlots = beltInventory.getSlots();
        int xoff = (9 - this.beltSlots) * 18 / 2;
        for (int k = 0; k < this.beltSlots; ++k) {
            this.addSlot(new BeltSlot((Container)playerInventory, blockedStack, blockedSlot, k, 8 + xoff + k * 18, 20));
        }
        this.bindPlayerInventory((Container)playerInventory);
    }

    private void bindPlayerInventory(Container playerInventory) {
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                int index = j1 + l * 9 + 9;
                this.addSlot(this.blockedSlot == index ? new LockedSlot(playerInventory, index, 8 + j1 * 18, l * 18 + 51) : new Slot(playerInventory, index, 8 + j1 * 18, l * 18 + 51));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(this.blockedSlot == i1 ? new LockedSlot(playerInventory, i1, 8 + i1 * 18, 109) : new Slot(playerInventory, i1, 8 + i1 * 18, 109));
        }
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        if (!playerIn.level().isClientSide) {
            BeltFinder.sendSync(playerIn);
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
    }

    public boolean stillValid(Player playerIn) {
        ItemStack held = playerIn.getInventory().getItem(this.blockedSlot);
        boolean equal = this.blockedSlot < 0 || held == this.blockedStack || ItemStack.isSameItemSameTags((ItemStack)held, (ItemStack)this.blockedStack);
        this.blockedStack = held;
        return equal;
    }

    public void clicked(int slot, int button, ClickType clickType, Player player) {
        if (clickType == ClickType.SWAP && button == this.blockedSlot) {
            return;
        }
        super.clicked(slot, button, clickType, player);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        int end;
        int start;
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem() || index == this.blockedSlot) {
            return ItemStack.EMPTY;
        }
        ItemStack containedStack = slot.getItem();
        ItemStack originalStack = containedStack.copy();
        boolean reverse = false;
        if (index < this.beltSlots) {
            start = this.beltSlots;
            end = this.slots.size();
            reverse = true;
        } else {
            start = 0;
            end = this.beltSlots;
        }
        if (!this.moveItemStackTo(containedStack, start, end, reverse)) {
            return ItemStack.EMPTY;
        }
        if (containedStack.getCount() == 0) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return originalStack;
    }
}

