/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.integration;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import dev.gigaherz.sewingkit.api.SewingRecipeBuilder;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.belt.ToolBeltItem;
import dev.gigaherz.toolbelt.integration.SewingKitIntegration;
import dev.gigaherz.toolbelt.integration.SewingUpgradeRecipeBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class SewingUpgradeRecipe
extends SewingRecipe {
    public static final Codec<SewingUpgradeRecipe> CODEC = RecordCodecBuilder.create(instance -> SewingRecipe.defaultSewingFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, SewingUpgradeRecipe::new));

    public static SewingRecipeBuilder builder(Item result, CompoundTag tag) {
        return SewingUpgradeRecipe.builder(result, 1, tag);
    }

    public static SewingRecipeBuilder builder(Item result, int count, @Nullable CompoundTag tag) {
        return new SewingUpgradeRecipeBuilder(result, count, tag);
    }

    public SewingUpgradeRecipe(String group, NonNullList<SewingRecipe.Material> materials, Optional<Ingredient> pattern, Optional<Ingredient> tool, ItemStack output, boolean showNotification) {
        super(group, materials, pattern, tool, output, showNotification);
    }

    public SewingUpgradeRecipe(String group, NonNullList<SewingRecipe.Material> materials, @Nullable Ingredient pattern, @Nullable Ingredient tool, ItemStack output, boolean showNotification) {
        super(group, materials, pattern, tool, output, showNotification);
    }

    public boolean matches(Container inv, Level worldIn) {
        if (!super.matches(inv, worldIn)) {
            return false;
        }
        int inputUpgradeLevel = 0;
        for (int i = 2; i < 6; ++i) {
            ItemStack materialStack = inv.getItem(i);
            Item item = materialStack.getItem();
            if (!(item instanceof ToolBeltItem)) continue;
            ToolBeltItem belt = (ToolBeltItem)item;
            inputUpgradeLevel = belt.getLevel(materialStack);
            break;
        }
        ItemStack upgradedBelt = this.getResultItem();
        int upgradeLevel = ((ToolBeltItem)ToolBelt.BELT.get()).getLevel(upgradedBelt);
        return inputUpgradeLevel + 1 == upgradeLevel;
    }

    public ItemStack assemble(Container inv, RegistryAccess registryAccess) {
        CompoundTag inputTag;
        ItemStack inputBelt = ItemStack.EMPTY;
        for (int i = 2; i < 6; ++i) {
            if (!(inv.getItem(i).getItem() instanceof ToolBeltItem)) continue;
            inputBelt = inv.getItem(i);
            break;
        }
        ItemStack upgradedBelt = super.assemble(inv, registryAccess);
        if (inputBelt.getCount() > 0 && (inputTag = inputBelt.getTag()) != null) {
            CompoundTag tag = upgradedBelt.getOrCreateTag();
            upgradedBelt.setTag(inputTag.copy().merge(tag));
        }
        return upgradedBelt;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SewingKitIntegration.SEWING_UGRADE_SERIALIZER.get();
    }

    public static class Serializer
    extends SewingRecipe.SerializerBase<SewingUpgradeRecipe> {
        public Codec<SewingUpgradeRecipe> codec() {
            return CODEC;
        }

        protected SewingUpgradeRecipe makeRecipe(FriendlyByteBuf buffer, String group, NonNullList<SewingRecipe.Material> materials, Ingredient pattern, Ingredient tool, ItemStack result, boolean showNotification) {
            return new SewingUpgradeRecipe(group, materials, pattern, tool, result, showNotification);
        }
    }
}

