/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.network;

import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ConfigData;
import dev.gigaherz.toolbelt.ToolBelt;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SwapItems
implements CustomPacketPayload {
    public static final ResourceLocation ID = ToolBelt.location("swap_items");
    public int swapWith;

    public SwapItems(int windowId) {
        this.swapWith = windowId;
    }

    public SwapItems(FriendlyByteBuf buf) {
        this.swapWith = buf.readInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.swapWith);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> SwapItems.swapItem(this.swapWith, (Player)context.player().orElseThrow()));
    }

    public static void swapItem(int swapWith, Player player) {
        BeltFinder.findBelt((LivingEntity)player).ifPresent(getter -> {
            ItemStack stack = getter.getBelt();
            if (stack.getCount() <= 0) {
                return;
            }
            ItemStack inHand = player.getMainHandItem();
            if (!ConfigData.isItemStackAllowed(inHand)) {
                return;
            }
            IItemHandlerModifiable cap = (IItemHandlerModifiable)Objects.requireNonNull((IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM), "No inventory!");
            if (swapWith < 0) {
                player.setItemInHand(InteractionHand.MAIN_HAND, ItemHandlerHelper.insertItem((IItemHandler)cap, (ItemStack)inHand, (boolean)false));
            } else {
                ItemStack inSlot = cap.getStackInSlot(swapWith);
                player.setItemInHand(InteractionHand.MAIN_HAND, inSlot);
                cap.setStackInSlot(swapWith, inHand);
            }
            getter.setBelt(stack);
            getter.syncToClients();
        });
    }
}

