/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.slot;

import dev.gigaherz.toolbelt.ConfigData;
import dev.gigaherz.toolbelt.network.SyncBeltSlotContents;
import dev.gigaherz.toolbelt.slot.IBeltSlotItem;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BeltAttachment
implements INBTSerializable<CompoundTag> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean ENABLE_DEBUG_LOGGING = "true".equals(System.getProperty("toolbelt.debug", FMLEnvironment.production ? "false" : "true"));
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"toolbelt");
    public static final DeferredHolder<AttachmentType<?>, AttachmentType<BeltAttachment>> BELT_ATTACHMENT = ATTACHMENT_TYPES.register("belt", () -> AttachmentType.serializable(BeltAttachment::new).build());
    private final LivingEntity owner;
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            BeltAttachment.this.onContentsChanged();
        }
    };

    private static void printDebugLog(String message, Object ... params) {
        if (ENABLE_DEBUG_LOGGING) {
            LOGGER.info(message, params);
        }
    }

    public static void register(IEventBus modEventBus) {
        ATTACHMENT_TYPES.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)new EventHandlers());
    }

    public static BeltAttachment get(LivingEntity player) {
        return (BeltAttachment)player.getData(BELT_ATTACHMENT);
    }

    private void dropContents() {
        ItemStack stack = this.getContents();
        if (stack.getCount() > 0) {
            BeltAttachment.printDebugLog("Entity {}({}) has item in the belt slot, but the belt is disabled. Dropping to the ground.", this.owner.getScoreboardName(), this.owner.getUUID());
            if (this.owner instanceof Player) {
                ItemHandlerHelper.giveItemToPlayer((Player)((Player)this.owner), (ItemStack)stack);
            } else {
                this.owner.spawnAtLocation(stack, 0.1f);
            }
            this.setContents(ItemStack.EMPTY);
        }
    }

    private void syncToSelf() {
        this.syncTo((Player)this.owner);
    }

    protected void syncTo(Player target) {
        PacketDistributor.PLAYER.with((Object)((ServerPlayer)target)).send(new CustomPacketPayload[]{new SyncBeltSlotContents((Player)this.owner, this)});
    }

    protected void syncTo(PacketDistributor.PacketTarget target) {
        target.send(new CustomPacketPayload[]{new SyncBeltSlotContents((Player)this.owner, this)});
    }

    public BeltAttachment(IAttachmentHolder holder) {
        this.owner = (LivingEntity)holder;
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.owner;
    }

    public void onContentsChanged() {
        if (!ConfigData.customBeltSlotEnabled) {
            return;
        }
        if (this.getOwner() != null && !this.getOwner().level().isClientSide) {
            this.syncTo(PacketDistributor.TRACKING_ENTITY_AND_SELF.with((Object)this.getOwner()));
        }
    }

    public CompoundTag serializeNBT() {
        return this.inventory.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.inventory.deserializeNBT(nbt);
    }

    @Nonnull
    public ItemStack getContents() {
        return this.inventory.getStackInSlot(0);
    }

    public void setContents(@Nonnull ItemStack stack) {
        ItemStack oldStack = this.getContents();
        if (oldStack == stack) {
            return;
        }
        if (!oldStack.isEmpty()) {
            this.notifyUnequip(oldStack);
        }
        this.inventory.setStackInSlot(0, stack);
        if (!stack.isEmpty()) {
            this.notifyEquip(stack);
        }
    }

    private void notifyEquip(ItemStack stack) {
        IBeltSlotItem extItem = (IBeltSlotItem)stack.getCapability(IBeltSlotItem.CAPABILITY);
        if (extItem != null) {
            extItem.onEquipped(stack, this);
        }
    }

    private void notifyUnequip(ItemStack stack) {
        IBeltSlotItem extItem = (IBeltSlotItem)stack.getCapability(IBeltSlotItem.CAPABILITY);
        if (extItem != null) {
            extItem.onUnequipped(stack, this);
        }
    }

    private void onWornTick() {
        ItemStack stack = this.getContents();
        if (stack.isEmpty()) {
            return;
        }
        IBeltSlotItem extItem = (IBeltSlotItem)stack.getCapability(IBeltSlotItem.CAPABILITY);
        if (extItem != null) {
            extItem.onWornTick(stack, this);
        }
    }

    public boolean canEquip(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        IBeltSlotItem extItem = (IBeltSlotItem)stack.getCapability(IBeltSlotItem.CAPABILITY);
        if (extItem != null) {
            return extItem.canEquip(stack, this);
        }
        return false;
    }

    public boolean canUnequip() {
        ItemStack stack = this.getContents();
        if (stack.isEmpty()) {
            return false;
        }
        IBeltSlotItem extItem = (IBeltSlotItem)stack.getCapability(IBeltSlotItem.CAPABILITY);
        if (extItem != null) {
            return extItem.canEquip(stack, this);
        }
        return true;
    }

    private static class EventHandlers {
        private EventHandlers() {
        }

        @SubscribeEvent
        public void attachCapabilities(EntityJoinLevelEvent event) {
        }

        @SubscribeEvent
        public void joinWorld(PlayerEvent.PlayerLoggedInEvent event) {
            if (!ConfigData.customBeltSlotEnabled) {
                return;
            }
            Player target = event.getEntity();
            if (target.level().isClientSide) {
                return;
            }
            BeltAttachment.get((LivingEntity)target).syncToSelf();
        }

        @SubscribeEvent
        public void joinWorld(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!ConfigData.customBeltSlotEnabled) {
                return;
            }
            Player target = event.getEntity();
            if (target.level().isClientSide) {
                return;
            }
            BeltAttachment.get((LivingEntity)target).syncToSelf();
        }

        @SubscribeEvent
        public void track(PlayerEvent.StartTracking event) {
            if (!ConfigData.customBeltSlotEnabled) {
                return;
            }
            Entity target = event.getTarget();
            if (target.level().isClientSide) {
                return;
            }
            if (target instanceof Player) {
                BeltAttachment.get((LivingEntity)target).syncToSelf();
            }
        }

        @SubscribeEvent
        public void entityTick(TickEvent.PlayerTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            if (ConfigData.customBeltSlotEnabled) {
                BeltAttachment.get((LivingEntity)event.player).onWornTick();
            } else {
                BeltAttachment.get((LivingEntity)event.player).dropContents();
            }
        }

        @SubscribeEvent
        public void playerDeath(LivingDropsEvent event) {
            if (!ConfigData.customBeltSlotEnabled) {
                return;
            }
            LivingEntity entity = event.getEntity();
            BeltAttachment attachment = BeltAttachment.get(entity);
            ItemStack stack = attachment.getContents();
            if (stack.getCount() > 0) {
                BeltAttachment.printDebugLog("Processing belt slot data for entity death {}({})", entity.getScoreboardName(), entity.getUUID());
                if (EnchantmentHelper.hasVanishingCurse((ItemStack)stack)) {
                    stack = ItemStack.EMPTY;
                    attachment.setContents(stack);
                } else if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!entity.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) && !player.isSpectator()) {
                        BeltAttachment.printDebugLog("Entity is player, and keepInventory is not set. Spilling...", new Object[0]);
                        Collection old = entity.captureDrops(event.getDrops());
                        player.drop(stack, true, false);
                        entity.captureDrops(old);
                        attachment.setContents(ItemStack.EMPTY);
                    }
                } else {
                    entity.spawnAtLocation(stack);
                    attachment.setContents(ItemStack.EMPTY);
                }
            }
        }

        @SubscribeEvent
        public void playerClone(PlayerEvent.Clone event) {
            if (!ConfigData.customBeltSlotEnabled) {
                return;
            }
            Player oldPlayer = event.getOriginal();
            Player newPlayer = event.getEntity();
            BeltAttachment.printDebugLog("Processing respawn for entity {}({})", newPlayer.getScoreboardName(), newPlayer.getUUID());
            BeltAttachment oldBelt = BeltAttachment.get((LivingEntity)oldPlayer);
            BeltAttachment.printDebugLog("Old entity has data, copying...", new Object[0]);
            ItemStack stack = oldBelt.getContents();
            BeltAttachment newBelt = BeltAttachment.get((LivingEntity)newPlayer);
            newBelt.setContents(stack);
        }
    }
}

