/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib;

import appeng.api.config.Actionable;
import appeng.api.config.IncludeExclude;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.me.helpers.PlayerSource;
import de.mari_023.ae2wtlib.networking.UpdateRestockPacket;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import de.mari_023.ae2wtlib.wct.CraftingTerminalHandler;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHandler;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHost;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetMode;
import java.util.function.Consumer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class AE2wtlibEvents {
    public static void restock(ServerPlayer player, ItemStack item, int count, Consumer<ItemStack> setStack) {
        if (player.isCreative()) {
            return;
        }
        if (item.isEmpty()) {
            return;
        }
        CraftingTerminalHandler cTHandler = CraftingTerminalHandler.getCraftingTerminalHandler((Player)player);
        if (!cTHandler.inRange()) {
            return;
        }
        if (!ItemWT.getBoolean(cTHandler.getCraftingTerminal(), "restock")) {
            return;
        }
        if (cTHandler.getTargetGrid() == null) {
            return;
        }
        if (cTHandler.getTargetGrid().getStorageService() == null) {
            return;
        }
        int toAdd = Math.max(item.getMaxStackSize() / 2, 1) - count;
        if (toAdd == 0) {
            return;
        }
        long changed = toAdd > 0 ? cTHandler.getTargetGrid().getStorageService().getInventory().extract((AEKey)AEItemKey.of((ItemStack)item), (long)toAdd, Actionable.MODULATE, (IActionSource)new PlayerSource((Player)player, null)) : -cTHandler.getTargetGrid().getStorageService().getInventory().insert((AEKey)AEItemKey.of((ItemStack)item), (long)(-toAdd), Actionable.MODULATE, (IActionSource)new PlayerSource((Player)player, null));
        item.setCount(count + (int)changed);
        setStack.accept(item);
        int slot = player.getInventory().findSlotMatchingUnusedItem(item);
        if (slot == -1 && player.getInventory().offhand.contains((Object)item)) {
            slot = 36;
        }
        PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new UpdateRestockPacket(slot, item.getCount())});
    }

    public static boolean insertStackInME(ItemStack stack, Player player) {
        if (stack.isEmpty()) {
            return false;
        }
        if (player.level().isClientSide()) {
            return false;
        }
        CraftingTerminalHandler cTHandler = CraftingTerminalHandler.getCraftingTerminalHandler(player);
        ItemStack terminal = cTHandler.getCraftingTerminal();
        if (MagnetHandler.getMagnetSettings((ItemStack)terminal).magnetMode != MagnetMode.PICKUP_ME) {
            return false;
        }
        if (!cTHandler.inRange()) {
            return false;
        }
        MagnetHost magnetHost = cTHandler.getMagnetHost();
        if (magnetHost == null) {
            return false;
        }
        if (magnetHost.getInsertFilter().isEmpty() && magnetHost.getInsertMode() == IncludeExclude.WHITELIST) {
            return false;
        }
        if (!magnetHost.getInsertFilter().matchesFilter((AEKey)AEItemKey.of((ItemStack)stack), magnetHost.getInsertMode())) {
            return false;
        }
        if (cTHandler.getTargetGrid() == null) {
            return false;
        }
        if (cTHandler.getTargetGrid().getStorageService() == null) {
            return false;
        }
        long inserted = cTHandler.getTargetGrid().getStorageService().getInventory().insert((AEKey)AEItemKey.of((ItemStack)stack), (long)stack.getCount(), Actionable.MODULATE, (IActionSource)new PlayerSource(player, null));
        int leftover = (int)((long)stack.getCount() - inserted);
        stack.setCount(leftover);
        return leftover == 0;
    }
}

