/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib;

import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.items.tools.powered.powersink.PoweredItemCapabilities;
import de.mari_023.ae2wtlib.AE2WTLibCreativeTab;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.AE2wtlibConfig;
import de.mari_023.ae2wtlib.AE2wtlibEvents;
import de.mari_023.ae2wtlib.AE2wtlibItems;
import de.mari_023.ae2wtlib.networking.AE2wtlibPacket;
import de.mari_023.ae2wtlib.networking.CycleTerminalPacket;
import de.mari_023.ae2wtlib.networking.RestockAmountPacket;
import de.mari_023.ae2wtlib.networking.UpdateRestockPacket;
import de.mari_023.ae2wtlib.networking.UpdateWUTPackage;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.EntityItemPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

@Mod(value="ae2wtlib")
@Mod.EventBusSubscriber
public class AE2wtlibForge {
    public AE2wtlibForge(IEventBus modEventBus) {
        AE2wtlib.registerMenus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AE2wtlibConfig.SPEC, "ae2wtlib.toml");
        modEventBus.addListener(e -> {
            if (!e.getRegistryKey().equals(Registries.BLOCK)) {
                return;
            }
            AE2wtlibItems items = new AE2wtlibItems();
            AE2wtlib.onAe2Initialized(items);
            AE2WTLibCreativeTab.init();
        });
        modEventBus.addListener(e -> AE2wtlib.addToCreativeTab());
        modEventBus.addListener(event -> {
            IPayloadRegistrar registrar = event.registrar("ae2wtlib");
            AE2wtlibForge.registerPacket(registrar, CycleTerminalPacket.ID, (FriendlyByteBuf.Reader<AE2wtlibPacket>)((FriendlyByteBuf.Reader)CycleTerminalPacket::new));
            AE2wtlibForge.registerPacket(registrar, UpdateWUTPackage.ID, (FriendlyByteBuf.Reader<AE2wtlibPacket>)((FriendlyByteBuf.Reader)UpdateWUTPackage::new));
            AE2wtlibForge.registerPacket(registrar, UpdateRestockPacket.ID, (FriendlyByteBuf.Reader<AE2wtlibPacket>)((FriendlyByteBuf.Reader)UpdateRestockPacket::new));
            AE2wtlibForge.registerPacket(registrar, RestockAmountPacket.ID, (FriendlyByteBuf.Reader<AE2wtlibPacket>)((FriendlyByteBuf.Reader)RestockAmountPacket::new));
        });
        modEventBus.addListener(e -> AE2wtlib.registerScreens());
        modEventBus.addListener(event -> {
            AE2wtlibForge.registerPowerStorageItem(event, AE2wtlibItems.instance().UNIVERSAL_TERMINAL);
            AE2wtlibForge.registerPowerStorageItem(event, AE2wtlibItems.instance().PATTERN_ACCESS_TERMINAL);
            AE2wtlibForge.registerPowerStorageItem(event, AE2wtlibItems.instance().PATTERN_ENCODING_TERMINAL);
        });
    }

    private static void registerPacket(IPayloadRegistrar registrar, ResourceLocation id, FriendlyByteBuf.Reader<AE2wtlibPacket> reader) {
        registrar.play(id, reader, (packet, context) -> context.workHandler().submitAsync(() -> {
            if (context.player().isPresent()) {
                packet.processPacketData((Player)context.player().get());
            }
        }));
    }

    private static void registerPowerStorageItem(RegisterCapabilitiesEvent event, ItemWT item) {
        event.registerItem(Capabilities.EnergyStorage.ITEM, (object, context) -> new PoweredItemCapabilities(object, (IAEItemPowerStorage)item), new ItemLike[]{item});
    }

    @SubscribeEvent
    public static void handle(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        AE2wtlibEvents.restock(player, event.getItem(), event.getResultStack().getCount(), arg_0 -> ((LivingEntityUseItemEvent.Finish)event).setResultStack(arg_0));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handle(PlayerInteractEvent.RightClickBlock event) {
        ServerPlayer player;
        block3: {
            block2: {
                Player player2 = event.getEntity();
                if (!(player2 instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)player2;
                if (!event.isCanceled()) break block3;
            }
            return;
        }
        ItemStack item = event.getItemStack();
        AE2wtlibEvents.restock(player, item, item.getCount(), stack -> player.setItemInHand(event.getHand(), stack));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handle(PlayerInteractEvent.EntityInteractSpecific event) {
        ServerPlayer player;
        block3: {
            block2: {
                Player player2 = event.getEntity();
                if (!(player2 instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)player2;
                if (!event.isCanceled()) break block3;
            }
            return;
        }
        ItemStack item = event.getItemStack();
        AE2wtlibEvents.restock(player, item, item.getCount(), stack -> player.setItemInHand(event.getHand(), stack));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void handle(EntityItemPickupEvent event) {
        if (event.isCanceled()) {
            return;
        }
        event.setCanceled(AE2wtlibEvents.insertStackInME(event.getItem().getItem(), event.getEntity()));
    }
}

